<?php

namespace App\Http\Controllers;

use Illuminate\Foundation\Bus\DispatchesJobs;
use Illuminate\Routing\Controller as BaseController;
use Illuminate\Foundation\Validation\ValidatesRequests;
use Illuminate\Foundation\Auth\Access\AuthorizesRequests;
use Illuminate\http\Request;
use Illuminate\http\Response;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\File;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Facades\Input;
use Hash;


use DB;


class Controller extends BaseController
{
    use AuthorizesRequests, DispatchesJobs, ValidatesRequests;
   
    public function test (Request $request)
    {
        return "good";
    }

    // EMPLOYEE FUNCTIONS
    public function EmployeeSignup (Request $request)
    { 
	    if(isset($request['emp_username']) && !empty($request['emp_username']) 
		    AND isset($request['emp_fname']) && !empty($request['emp_fname'])
		    AND isset($request['emp_lname']) && !empty($request['emp_lname'])
		    AND isset($request['emp_pincode']) && !empty($request['emp_pincode']))
		{
	        $emp_username =$request['emp_username'];
	        $emp_fname =$request['emp_fname'];
	        $emp_lname = $request['emp_lname'];
	        $emp_phone = $request['emp_phone'];
		    $emp_pass = $request['emp_pass'];
		    $emp_email = $request['emp_email'];
		    $emp_pincode = $request['emp_pincode'];
		    $emp_role = $request['emp_role'];
		   
		    $users = DB::select('select * from KOS_Employee where emp_pincode = ?', [$emp_pincode]);
	        if($users)
			{
			    return response()->json(['status'=>'failed','error'=>'Pincode Already Exits for another Employee.']);
			}
			else 
			{
			    try 
				{
					$inserteed = DB::insert('insert into KOS_Employee (emp_username,emp_fname,emp_lname,emp_phone,emp_pass,emp_email,emp_pincode,emp_role) 
					values (?,?,?,?,?,?,?,?)',[$emp_username,$emp_fname,$emp_lname,$emp_phone,$emp_pass,$emp_email,$emp_pincode,$emp_role]);
					
		            if($inserteed)
                    {
                        return response()->json(['status'=>'success']);
                    }
                    else 
 					{
 					    return response()->json(['status'=>'failed','error'=>'Sql Error']);
 					}  
				} 
				catch(\Illuminate\Database\QueryException $ex)
				{ 		
					return response()->json(['status'=>'failed','error'=>'This account already exists']);
				}
			}
    	}
    	else
    	{
    	    return response()->json(['status'=>'failed','error'=>'Incomplete Parameters']);
    	}
    }
    
    public function AdminSignIn (Request $request)
    { 
		if( isset($request['emp_username']) && !empty($request['emp_username']) AND isset($request['emp_pass']) && !empty($request['emp_pass']) ) 
		{
			$emp_username = $request['emp_username'];
			$emp_pass     = $request['emp_pass'];
			$var2 = "Admin";
			
			try 
			{ 
                $users = DB::select('select * from KOS_Employee where emp_username = ? AND emp_pass = ? AND emp_role = ?', [$emp_username,$emp_pass,$var2]);
				if($users)
				{
				    return response()->json(['status'=>'success','data'=>$users]);
				    
				}
				else
				{
					return response()->json(['status'=>'failed','error'=>'Wrong Username or Password. OR you have no access to this system.']);
				}	
				  
			} 
			catch(\Illuminate\Database\QueryException $ex)
			{ 		
				return response()->json(['status'=>'failed','error'=>'Sql Error']);
			}
		
		}
		else 
		{
			return response()->json(['status'=>'failed','error'=>'Incomplete Parameters']);
		}
    }
    
    public function EmployeeSignin (Request $request)
    { 
		if(isset($request['emp_pincode']) && !empty($request['emp_pincode'])) 
			{
				$emp_pincode=$request['emp_pincode'];
				
				try 
				{ 
                    $users = DB::select('select * from KOS_Employee where emp_pincode = ?', [$emp_pincode]);
					if($users)
					{
					    return response()->json(['status'=>'success','data'=>$users]);
					    
					}
					else
					{
						return response()->json(['status'=>'failed','error'=>'Wrong Pin code']);
					}	
					  
				} 
				catch(\Illuminate\Database\QueryException $ex)
				{ 		
					return response()->json(['status'=>'failed','error'=>'Sql Error']);
				}
			
			}
			
		else 
			{
				return response()->json(['status'=>'failed','error'=>'Incomplete Parameters']);
			}
      }
    
    public function EditEmployee (Request $request)
    { 
	    if(isset($request['emp_username']) && !empty($request['emp_username']) 
		    AND isset($request['emp_fname']) && !empty($request['emp_fname'])
		    AND isset($request['emp_lname']) && !empty($request['emp_lname'])
		    AND isset($request['emp_pincode']) && !empty($request['emp_pincode']))
		{
	        $emp_username =$request['emp_username'];
	        $emp_fname =$request['emp_fname'];
	        $emp_lname = $request['emp_lname'];
	        $emp_phone = $request['emp_phone'];
		    $emp_pass = $request['emp_pass'];
		    $emp_email = $request['emp_email'];
		    $emp_pincode = $request['emp_pincode'];
		    $emp_role = $request['emp_role'];
		    
		    $users = DB::select('select * from KOS_Employee where emp_username = ?', [$emp_username ]);						
		    if($users)
			{
			    foreach ($users as $key)
				{
				    $emp_pincode_exist = $key->emp_pincode;
				}
				
				if( $emp_pincode_exist != $emp_pincode )
				{
    			    $users2 = DB::select('select * from KOS_Employee where emp_pincode = ?', [$emp_pincode]);
        	        if($users2)
        			{
        			    return response()->json(['status'=>'failed','error'=>'Pincode Already Exits for another Employee.']);
        			}
        			else 
        			{
        				try 
        				{ 
        					$user_new = DB::update('update KOS_Employee SET emp_fname = ? , emp_lname = ? ,emp_phone = ? ,emp_pass = ? ,emp_email = ? ,emp_pincode = ? ,emp_role = ? where emp_username= ?', [$emp_fname,$emp_lname,$emp_phone,$emp_pass,$emp_email,$emp_pincode,$emp_role,$emp_username]);
        					if ( $user_new)
        					{		
        						return response()->json(['status'=>'success']);
        					}
        					else 
        					{
        						return response()->json(['status'=>'failed','error'=>'Sql Error1']);
        					}
        				} 
        				catch(\Illuminate\Database\QueryException $ex)
        				{ 		
        					return response()->json(['status'=>'failed','error'=>'This account already exists']);
        				}
        			}
				}
				else 
    			{
    				try 
    				{ 
    					$user_new = DB::update('update KOS_Employee SET emp_fname = ? , emp_lname = ? ,emp_phone = ? ,emp_pass = ? ,emp_email = ? ,emp_pincode = ? ,emp_role = ? where emp_username= ?', [$emp_fname,$emp_lname,$emp_phone,$emp_pass,$emp_email,$emp_pincode,$emp_role,$emp_username]);
    					if ( $user_new)
    					{		
    						return response()->json(['status'=>'success']);
    					}
    					else 
    					{
    						return response()->json(['status'=>'failed','error'=>'Sql Error1']);
    					}
    				} 
    				catch(\Illuminate\Database\QueryException $ex)
    				{ 		
    					return response()->json(['status'=>'failed','error'=>'This account already exists']);
    				}
    			}
			}
			else 
			{
		        return response()->json(['status'=>'failed','error'=>'Email Not Exists']);
			}
    	}
    	else
    	{
    	    return response()->json(['status'=>'failed','error'=>'Incomplete Parameters']);
    	}
    }
    
    public function ViewAllEmployees (Request $request)
    { 
		try 
		{ 
            $users = DB::select('select * from 	KOS_Employee ');
			if($users)
			{
			    return response()->json(['status'=>'success','data'=>$users]);
			}
			else
			{
				return response()->json(['status'=>'failed','error'=>'No information found']);
			}	
		} 
		catch(\Illuminate\Database\QueryException $ex)
		{ 		
			return response()->json(['status'=>'failed','error'=>'Sql Error']);
		}
    }
    
    public function ViewEmployee (Request $request)
    { 
        if(isset($request['emp_username']) && !empty($request['emp_username']))
		{
		    $emp_username = $request['emp_username'];
		    
		    try 
			{
			    $users = DB::select ('select * from KOS_Employee where emp_username = ?', [$emp_username]);
	            if($users)
                {
                    return response()->json(['status'=>'success','data'=>$users]);
                }
                else 
 				{
 				    return response()->json(['status'=>'failed','error'=>'No information found']);
 				}  
			} 
			catch(\Illuminate\Database\QueryException $ex)
			{ 		
			    return response()->json(['status'=>'failed','error'=>'try again']);
			}
    	}
    	else
    	{
    	    return response()->json(['status'=>'failed','error'=>'Incomplete Parameters']);
    	}
    }
    
    public function DeleteEmployee (Request $request)
    { 
	    if(isset($request['emp_username']) && !empty($request['emp_username']))
		{
		    $emp_username = $request['emp_username'];
		    try 
			{
			    $deleted = DB::delete ("delete from KOS_Employee  where emp_username='$emp_username'");
	            if($deleted)
                {
                    return response()->json(['status'=>'success']);
                }
                else 
 				{
 				    return response()->json(['status'=>'failed','error'=>'Sql Error']);
 				}  
			} 
			catch(\Illuminate\Database\QueryException $ex)
			{ 		
			    return response()->json(['status'=>'failed','error'=>'try again']);
			}
    	}
    	else
    	{
    	    return response()->json(['status'=>'failed','error'=>'Incomplete Parameters']);
    	}
    }
    
    //VR STATION FUNCTIONS
    public function AddVRStation (Request $request)
    { 
	    if(isset($request['name']) && !empty($request['name']) 
		    AND isset($request['number']) && !empty($request['number'])
		    AND isset($request['playing_time']) && !empty($request['playing_time']))
		{
    	    $name =$request['name'];
    	    $number =$request['number'];
    	    $playing_time = $request['playing_time'];
    	       
			try 
			{ 
				$inserteed = DB::insert('insert into vr_station (name,number,playing_time) values (?,?,?)',[$name,$number,$playing_time]);
				
		        if($inserteed)
                {
                    return response()->json(['status'=>'success']);
                }
                else 
 				{
 				    return response()->json(['status'=>'failed','error'=>'Sql Error']);
 				}  
			} 
			catch(\Illuminate\Database\QueryException $ex)
			{ 		
			    return response()->json(['status'=>'failed','error'=>'This account already exists']);
			}
    	}
    	else
    	{
    	    return response()->json(['status'=>'failed','error'=>'Incomplete Parameters']);
    	}
    }
    
    public function EditVRStation (Request $request)
    { 
	    if(isset($request['station_id']) && !empty($request['station_id']) 
		    AND isset($request['name']) && !empty($request['name']) 
		    AND isset($request['number']) && !empty($request['number'])
		    AND isset($request['playing_time']) && !empty($request['playing_time']))
		{
	        $name =$request['name'];
	        $number =$request['number'];
	        $playing_time = $request['playing_time'];
	        $station_id = $request['station_id'];
		   
		    try 
			{ 
			    $inserted = DB::update("update  vr_station SET  name='$name',number='$number' ,playing_time='$playing_time'  where station_id='$station_id'");
				
	            if($inserted)
                {
                    return response()->json(['status'=>'success']);
                }
                else 
 				{
 				    return response()->json(['status'=>'failed','error'=>'Sql Error']);
 				} 
			} 
			catch(\Illuminate\Database\QueryException $ex)
			{ 		
				return response()->json(['status'=>'failed','error'=>'try again']);
			}
    	}
    	else
    	{
    	    return response()->json(['status'=>'failed','error'=>'Incomplete Parameters']);
    	}
    }
    
    public function ViewAllVRStations (Request $request)
    { 
		//return "get";
		try 
		{ 
            $users = DB::select('select * from 	vr_station ');
			if($users)
			{
		        return response()->json(['status'=>'success','data'=>$users]);
			}
			else
			{
			return response()->json(['status'=>'failed','error'=>'No information found']);
			}
		} 
		catch(\Illuminate\Database\QueryException $ex)
		{ 		
			return response()->json(['status'=>'failed','error'=>'Sql Error']);
		}
    }
    
    public function ViewVRStation (Request $request)
    { 
        if(isset($request['station_id']) && !empty($request['station_id']))
		{
		    $station_id = $request['station_id'];
		    
		    try 
			{
			    $users = DB::select ('select * from vr_station where station_id = ?', [$station_id]);
	            if($users)
                {
                    return response()->json(['status'=>'success','data'=>$users]);
                }
                else 
 				{
 				    return response()->json(['status'=>'failed','error'=>'No information found']);
 				}  
			} 
			catch(\Illuminate\Database\QueryException $ex)
			{ 		
			    return response()->json(['status'=>'failed','error'=>'try again']);
			}
    	}
    	else
    	{
    	    return response()->json(['status'=>'failed','error'=>'Incomplete Parameters']);
    	}
    }
    
    public function DeleteVRStation (Request $request)
    { 
	    if(isset($request['station_id']) && !empty($request['station_id']))
		{
	        $station_id = $request['station_id'];
	       
		    try 
			{ 
			    $deleted = DB::delete ("delete from  vr_station  where station_id='$station_id'");
	            if($deleted)
                {
                    return response()->json(['status'=>'success']);
                }
                else 
 				{
 				    return response()->json(['status'=>'failed','error'=>'Sql Error']);
 				}  
			} 
			catch(\Illuminate\Database\QueryException $ex)
			{ 		
				return response()->json(['status'=>'failed','error'=>'try again']);
			}
    	}
    	else
    	{
    	    return response()->json(['status'=>'failed','error'=>'Incomplete Parameters']);
    	}
    }
    
    //TAX FUNCTIONS
    public function AddTax (Request $request)
    { 
	 if(isset($request['type']) && !empty($request['type']) 
		AND isset($request['tax_amount']) && !empty($request['tax_amount']))
		{
    	    
    	       $type =$request['type'];
    	       $tax_amount =$request['tax_amount'];
    	       
			   try 
				{ 
				
					$inserteed = DB::insert('insert into tax (type,tax_amount) 
					values (?,?)',[$type,$tax_amount]);
					
					
		           if($inserteed)
                      {
                        return response()->json(['status'=>'success']);
                      }
                    else 
 					{
 					return response()->json(['status'=>'failed','error'=>'Sql Error']);
 					}  
 					
 					
				} 
				catch(\Illuminate\Database\QueryException $ex)
				{ 		
					return response()->json(['status'=>'failed','error'=>'This account already exists']);
				}
			    
    	}
    	else
    	{
    	    return response()->json(['status'=>'failed','error'=>'Incomplete Parameters']);
    	}
    }
    
    public function EditTax (Request $request)
    { 
        if(isset($request['taxid']) && !empty($request['taxid']) 
		    AND isset($request['type']) && !empty($request['type']) 
		    AND isset($request['tax_amount']) && !empty($request['tax_amount']))
		{
	        $taxid =$request['taxid'];
	        $type =$request['type'];
	        $tax_amount = $request['tax_amount'];
		   
		    try 
			{ 
			    $inserted = DB::update("update tax SET type='$type',tax_amount='$tax_amount' where taxid='$taxid'");
				
	            if($inserted)
                {
                    return response()->json(['status'=>'success']);
                }
                else 
 				{
 				    return response()->json(['status'=>'failed','error'=>'Sql Error']);
 				} 
			} 
			catch(\Illuminate\Database\QueryException $ex)
			{ 		
				return response()->json(['status'=>'failed','error'=>'try again']);
			}
    	}
    	else
    	{
    	    return response()->json(['status'=>'failed','error'=>'Incomplete Parameters']);
    	}
    }
      
    public function ViewTax (Request $request)
    { 
		
				//return "get";
				try 
				{ 

                    $users = DB::select('select * from 	tax ');
					if($users)
					{
					    return response()->json(['status'=>'success','data'=>$users]);
					    
					}
					else
					{
					return response()->json(['status'=>'failed','error'=>'No information found']);
					}	
					  
				} 
				catch(\Illuminate\Database\QueryException $ex)
				{ 		
					return response()->json(['status'=>'failed','error'=>'Sql Error']);
				}
			
		
      }
    
    public function ViewSingleTax (Request $request)
    { 
        if(isset($request['taxid']) && !empty($request['taxid']))
		{
		    $taxid = $request['taxid'];
		    
		    try 
			{
			    $users = DB::select ('select * from tax where taxid = ?', [$taxid]);
	            if($users)
                {
                    return response()->json(['status'=>'success','data'=>$users]);
                }
                else 
 				{
 				    return response()->json(['status'=>'failed','error'=>'No information found']);
 				}  
			} 
			catch(\Illuminate\Database\QueryException $ex)
			{ 		
			    return response()->json(['status'=>'failed','error'=>'try again']);
			}
    	}
    	else
    	{
    	    return response()->json(['status'=>'failed','error'=>'Incomplete Parameters']);
    	}
    }
    
    public function DeleteTax (Request $request)
    { 
	    if(isset($request['taxid']) && !empty($request['taxid']))
		{
    	    $taxid = $request['taxid'];
    	    
		    try 
			{ 
			    $deleted = DB::delete ("delete from  tax  where taxid='$taxid'");
	            if($deleted)
                {
                    return response()->json(['status'=>'success']);
                }
                else 
 				{
 				    return response()->json(['status'=>'failed','error'=>'Sql Error']);
 				}  
			} 
			catch(\Illuminate\Database\QueryException $ex)
			{ 		
				return response()->json(['status'=>'failed','error'=>'try again']);
			}
    	}
    	else
    	{
    	    return response()->json(['status'=>'failed','error'=>'Incomplete Parameters']);
    	}
    }
      
    //PER HOUR RATE FUNCTIONS
    public function AddRateHour (Request $request)
    { 
	    if(isset($request['hours']) && !empty($request['hours']) 
		    AND isset($request['rate']) && !empty($request['rate']))
		{
            $hours =$request['hours'];
    	    $rate =$request['rate'];
    	    
    	    try 
			{ 
				$inserteed = DB::insert('insert into rate_hour (hours,rate) values (?,?)',[$hours,$rate]);
			
				if($inserteed)
                {
                    return response()->json(['status'=>'success']);
                }
                else 
 				{
 				    return response()->json(['status'=>'failed','error'=>'Sql Error']);
 				}  
			} 
			catch(\Illuminate\Database\QueryException $ex)
			{ 		
			    return response()->json(['status'=>'failed','error'=>'try again']);
			}
    	}
    	else
    	{
    	    return response()->json(['status'=>'failed','error'=>'Incomplete Parameters']);
    	}
    }
    
    public function EditRateHour (Request $request)
    { 
	    if(isset($request['rp_id']) && !empty($request['rp_id']) 
		    AND isset($request['hours']) && !empty($request['hours']) 
		    AND isset($request['rate']) && !empty($request['rate']))
		{
    	    $hours =$request['hours'];
    	    $rate =$request['rate'];
    	    $rp_id = $request['rp_id'];
    	    
    	    try 
			{ 
				
				$inserted = DB::update("update  rate_hour SET  hours='$hours',rate='$rate'  where rp_id='$rp_id'");
					
		        if($inserted)
                {
                    return response()->json(['status'=>'success']);
                }
                else 
 				{
 				    return response()->json(['status'=>'failed','error'=>'Sql Error']);
 				}
			} 
			catch(\Illuminate\Database\QueryException $ex)
			{ 		
				return response()->json(['status'=>'failed','error'=>'try again']);
			}
    	}
    	else
    	{
    	    return response()->json(['status'=>'failed','error'=>'Incomplete Parameters']);
    	}
    }
    
    public function ViewAllRateHours (Request $request)
    { 
		try 
		{
            $users = DB::select('select * from 	rate_hour ');
			if($users)
			{
			    return response()->json(['status'=>'success','data'=>$users]);
			}
			else
			{
				return response()->json(['status'=>'failed','error'=>'No information found']);
			}	
		} 
		catch(\Illuminate\Database\QueryException $ex)
		{ 		
			return response()->json(['status'=>'failed','error'=>'Sql Error']);
		}
    }
    
    public function ViewRatePerHour (Request $request)
    {
        if(isset($request['rp_id']) && !empty($request['rp_id']))
		{
		    $rp_id = $request['rp_id'];
		    
		    try 
			{
			    $users = DB::select ('select * from rate_hour where rp_id = ?', [$rp_id]);
	            if($users)
                {
                    return response()->json(['status'=>'success','data'=>$users]);
                }
                else 
 				{
 				    return response()->json(['status'=>'failed','error'=>'No information found']);
 				}  
			} 
			catch(\Illuminate\Database\QueryException $ex)
			{ 		
			    return response()->json(['status'=>'failed','error'=>'try again']);
			}
    	}
    	else
    	{
    	    return response()->json(['status'=>'failed','error'=>'Incomplete Parameters']);
    	}
    }
      
    public function DeleteRateHour (Request $request)
    { 
	    if(isset($request['rp_id']) && !empty($request['rp_id']))
		{
    	    $rp_id = $request['rp_id'];
    	    try 
			{ 
			    $deleted = DB::delete ("delete from  rate_hour  where rp_id='$rp_id'");
		        if($deleted)
                {
                    return response()->json(['status'=>'success']);
                }
                else 
 				{
 				    return response()->json(['status'=>'failed','error'=>'Sql Error']);
 				}  
			} 
			catch(\Illuminate\Database\QueryException $ex)
			{ 		
				return response()->json(['status'=>'failed','error'=>'try again']);
			}
			    
    	}
    	else
    	{
    	    return response()->json(['status'=>'failed','error'=>'Incomplete Parameters']);
    	}
    }
    
    //AGREEMENT FUNCTIONS
    public function AddAgreement (Request $request)
    { 
        if(isset($request['title']) && !empty($request['title']) 
		    AND isset($request['text']) && !empty($request['text']))
		{
	        $title =$request['title'];
	        $text =$request['text'];
		    try 
			{ 
				$inserteed = DB::insert('insert into agreements (title,text) values (?,?)',[$title,$text]);
				
	            if($inserteed)
                {
                    return response()->json(['status'=>'success']);
                }
                else 
 				{
 				    return response()->json(['status'=>'failed','error'=>'Sql Error']);
 				}  
			} 
			catch(\Illuminate\Database\QueryException $ex)
			{ 		
				return response()->json(['status'=>'failed','error'=>'try again']);
			}
    	}
    	else
    	{
    	    return response()->json(['status'=>'failed','error'=>'Incomplete Parameters']);
    	}
    }
    
    public function EditAgreement (Request $request)
    { 
	    if(isset($request['ag_id']) && !empty($request['ag_id']) 
		    AND isset($request['title']) && !empty($request['title']) 
		    AND isset($request['text']) && !empty($request['text']))
		{
            $ag_id =$request['ag_id'];
            $title =$request['title'];
            $text = $request['text'];
		    try 
			{ 
			    $inserted = DB::update("update  agreements SET  title='$title',text='$text'  where ag_id='$ag_id'");
				
	            if($inserted)
                {
                    return response()->json(['status'=>'success']);
                }
                else 
 				{
 				    return response()->json(['status'=>'failed','error'=>'Sql Error']);
 				}  
			} 
			catch(\Illuminate\Database\QueryException $ex)
			{ 		
				return response()->json(['status'=>'failed','error'=>'try again']);
			}
    	}
    	else
    	{
    	    return response()->json(['status'=>'failed','error'=>'Incomplete Parameters']);
    	}
    }
    
    public function ViewAgreement (Request $request)
    { 
		try 
		{ 
            $users = DB::select('select * from 	agreements ');
			if($users)
			{
			    return response()->json(['status'=>'success','data'=>$users]);
			}
			else
			{
				return response()->json(['status'=>'failed','error'=>'No information found']);
			}	
		} 
		catch(\Illuminate\Database\QueryException $ex)
		{ 		
			return response()->json(['status'=>'failed','error'=>'Sql Error']);
		}
    }
    
    public function ViewSingleAgreement (Request $request)
    { 
        if(isset($request['ag_id']) && !empty($request['ag_id']))
		{
		    $ag_id = $request['ag_id'];
		    
		    try 
			{
			    $users = DB::select ('select * from agreements where ag_id = ?', [$ag_id]);
	            if($users)
                {
                    return response()->json(['status'=>'success','data'=>$users]);
                }
                else 
 				{
 				    return response()->json(['status'=>'failed','error'=>'No information found']);
 				}  
			} 
			catch(\Illuminate\Database\QueryException $ex)
			{ 		
			    return response()->json(['status'=>'failed','error'=>'try again']);
			}
    	}
    	else
    	{
    	    return response()->json(['status'=>'failed','error'=>'Incomplete Parameters']);
    	}
    }
    
    public function DeleteAgreement (Request $request)
    { 
	    if(isset($request['ag_id']) && !empty($request['ag_id']))
		{
    	    $ag_id = $request['ag_id'];
    	    
    	    try 
			{ 
			    $deleted = DB::delete ("delete from  agreements  where ag_id='$ag_id'");
		        if($deleted)
                {
                    return response()->json(['status'=>'success']);
                }
                else 
 				{
 				    return response()->json(['status'=>'failed','error'=>'Sql Error']);
 				}
			} 
			catch(\Illuminate\Database\QueryException $ex)
			{ 		
				return response()->json(['status'=>'failed','error'=>'try again']);
			}
    	}
    	else
    	{
    	    return response()->json(['status'=>'failed','error'=>'Incomplete Parameters']);
    	}
    }
      
    public function VerifyEmail (Request $request)
    { 
	    if(isset($request['email']) && !empty($request['email']))
		{
		    $email = $request['email'];
		    $users = DB::select('select * from customer where email = ?', [$email]);
			if($users)
			{
			     return response()->json(['status'=>'failed','error'=>'Email Already Exits']);
			}
			else 
			{
			    return response()->json(['status'=>'success']); 
			    
			}
    	}
    	else
    	{
    	    return response()->json(['status'=>'failed','error'=>'Incomplete Parameters']);
    	}
    }
      
    public function CustomerSignup (Request $request)
    { 
	    if(isset($request['dob']) && !empty($request['dob']) 
		AND isset($request['fname']) && !empty($request['fname'])
		AND isset($request['lname']) && !empty($request['lname'])
		AND isset($request['phone']) && !empty($request['phone'])
		AND isset($request['email']) && !empty($request['email']))
		{
    	    
    	        $dob =$request['dob'];
    	        $fname =$request['fname'];
    	        $lname = $request['lname'];
    	        $phone = $request['phone'];
			    $email = $request['email'];
			    $child_email = $request['child_email'];
			   
			    $password_w=$request['password'];
			    $children=$request['children'];
	            $password =md5($password_w);
			    $gender = $request['gender'];
			    $age = $request['age'];
			    $add1 = $request['add1'];
			    $add2 = $request['add2'];
			    $country = $request['country'];
			    $state = $request['state'];
			    $city = $request['city'];
			    $zipcode = $request['zipcode'];
			    $type = $request['type'];
			   
			    $customer_id= mt_rand(100000, 999999);
			   
			    function addItems($phone11,$option_details11)
				{
					$type = "child";
				
					$data = json_decode($option_details11);
					
					foreach ($data as $key)
					{
						
						$fname11      =  $key->fname;
						$lname11      =  $key->lname;
						$dob11      =  $key->dob;
						$gender11      =  $key->gender;
						$email11      =  $key->email;
						$age45      =  $key->age;
						$customer_id= mt_rand(100000, 999999);
						
						try 
						{ 
						    $inserteed = DB::insert('insert into customer (customer_id,dob,fname,lname,phone,email,gender,type,age) 
    					    values (?,?,?,?,?,?,?,?,?)',[$customer_id,$dob11,$fname11,$lname11,$phone11,$email11,$gender11,$type,$age45]);
    					
							if($inserteed)
							{
								$ff = 1;
							}
							else 
							{
								$ff = 0;
							}		
						} 
						catch(\Illuminate\Database\QueryException $ex)
						{ 		
							$ff = 0;
						}												
					}
					return $ff;
				}
					
			   
			    if(isset($request['photo']) && !empty($request['photo']))
			    {
			        $request->file('photo');
        			$destinationPath='public/pictures';
        			$file=$request->photo;
        			$extention=$request->photo->extension();
        			//$extention=$file->getClientOriginalExtention();
        			$fileName=round(microtime(true)).".".$extention;
        			$file->move($destinationPath,$fileName);
        			$photo=$fileName;
        			$destination = "pictures/";
        			$target_file = $destination. $photo;
		        }
			    else 
			    {
			        $target_file = null;
			    }
			    
			    if( $type != "single child")
			    {
    			    $users = DB::select('select * from customer where email = ?', [$email]);
    				if($users)
    				{
    				     return response()->json(['status'=>'failed','error'=>'Email Already Exits']);
    				}
    				else 
    				{
        				try 
    					{ 
    				        $inserteed = DB::insert('insert into customer (customer_id,dob,fname,lname,phone,signature,email,child_email,password,gender,age,add1,add2,country,state,city,zipcode,type) 
        					values (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)',[$customer_id,$dob,$fname,$lname,$phone,$target_file,$email,$child_email,$password,$gender,$age,$add1,$add2,$country,$state,$city,$zipcode,$type]);
        					
        		            if($inserteed)
                            {
                                if(isset($request['children']) && !empty($request['children']))
                                {
                                    if(addItems($phone,$children)==1)
									{
									    return response()->json(['status'=>'success']);  
									}
									else 
									{
										return response()->json(['status'=>'failed','error'=>'Sql Error 1']);
									}
                                }
                                else 
                                {
                                    return response()->json(['status'=>'success']);     
                                }
                            }
                            else 
         					{
         				    	return response()->json(['status'=>'failed','error'=>'Sql Error']);
         					}
    					} 
    					catch(\Illuminate\Database\QueryException $ex)
    					{ 		
    						$ff = 0;
    					}
    				}
			    }
			    else
			    {
			        try 
					{ 
				        $inserteed = DB::insert('insert into customer (customer_id,dob,fname,lname,phone,signature,email,child_email,password,gender,age,add1,add2,country,state,city,zipcode,type) 
    					values (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)',[$customer_id,$dob,$fname,$lname,$phone,$target_file,$email,$child_email,$password,$gender,$age,$add1,$add2,$country,$state,$city,$zipcode,$type]);
    					
    		            if($inserteed)
                        {
                            if(isset($request['children']) && !empty($request['children']))
                            {
                                if(addItems($phone,$children)==1)
								{
								    return response()->json(['status'=>'success']);  
								}
								else 
								{
									return response()->json(['status'=>'failed','error'=>'Sql Error 1']);
								}
                            }
                            else 
                            {
                                return response()->json(['status'=>'success']);     
                            }
                        }
                        else 
     					{
     					    return response()->json(['status'=>'failed','error'=>'Sql Error']);
     					}  
					
					} 
					catch(\Illuminate\Database\QueryException $ex)
					{ 		
						$ff = 0;
					}
			    }
    	}
    	else
    	{
    	    return response()->json(['status'=>'failed','error'=>'Incomplete Parameters']);
    	}
    }
    
    public function EditCustomerProfile (Request $request)
    { 
	 if(isset($request['dob']) && !empty($request['dob']) 
		AND isset($request['fname']) && !empty($request['fname'])
		AND isset($request['lname']) && !empty($request['lname'])
		AND isset($request['phone']) && !empty($request['phone'])
	
		AND isset($request['email']) && !empty($request['email']))
		{
    	    
    	       $dob =$request['dob'];
    	       $fname =$request['fname'];
    	       $lname = $request['lname'];
    	       $phone = $request['phone'];
			   $email = $request['email'];
			   
			  $password_w=$request['password'];
			  $children=$request['children'];
				$password =md5($password_w);
			   $gender = $request['gender'];
			   $age = $request['age'];
			   $add1 = $request['add1'];
			   $add2 = $request['add2'];
			   $country = $request['country'];
			   $state = $request['state'];
			   $city = $request['city'];
			   $zipcode = $request['zipcode'];
			   $type = $request['type'];
			    $customer_id = $request['customer_id'];
			   
			   
			   function addItems($phone11,$option_details11)
					{
						$type = "child";
						//echo "hre";
					
						$data = json_decode($option_details11);
						
						
						foreach ($data as $key)
						{
							
							$fname11      =  $key->fname;
							
							//echo "ye lo".$fname11;
							$lname11      =  $key->lname;
							$dob11      =  $key->dob;
							$gender11      =  $key->gender;
							$email11      =  $key->email;
							$customer_id      =  $key->customer_id;
							$age45      =  $key->age;
							
						    if ($customer_id == "nil")
						    {
						        $customer_id= mt_rand(100000, 999999);
    							try 
    							{ 
    							
    							$inserteed = DB::insert('insert into customer (customer_id,dob,fname,lname,phone,email,gender,type,age) 
            					values (?,?,?,?,?,?,?,?,?)',[$customer_id,$dob11,$fname11,$lname11,$phone11,$email11,$gender11,$type,$age45]);
            					
    								if($inserteed)
    								{
    									$ff = 1;
    								}
    								else 
    								{
    									$ff = 0;
    								}		
    							} 
    							catch(\Illuminate\Database\QueryException $ex)
    							{ 		
    								$ff = 0;
    							}												
						        
						    }
						    else 
						    {
						        	try 
        							{ 
        							$inserteed = DB::update('update customer SET age = ? ,phone = ? , dob = ? , fname = ? ,lname = ? ,gender = ?  where customer_id= ?', [$age45,$phone11,$dob11,$fname11,$lname11,$gender11,$customer_id]);
        								if($inserteed)
        								{
        									$ff = 1;
        								}
        								else 
        								{
        									$ff = 0;
        								}		
        							} 
        							catch(\Illuminate\Database\QueryException $ex)
        							{ 		
        								$ff = 0;
        							}
						        
						    }
							
																		
						}
						
						return $ff;
					}
					
			
			 
			 $users = DB::select('select * from customer where email = ?', [$email]);
					if($users)
					{
					    
					      
        				
        				try 
							{ 
							     if(isset($request['photo']) && !empty($request['photo']))
                    			   {
                    			        $request->file('photo');
                            			 $destinationPath='public/pictures';
                            			 $file=$request->photo;
                            			 $extention=$request->photo->extension();
                            			//  $extention=$file->getClientOriginalExtention();
                            			 $fileName=round(microtime(true)).".".$extention;
                            			 $file->move($destinationPath,$fileName);
                            			 $photo=$fileName;
                            			 $destination = "pictures/";
                            			 $target_file = $destination. $photo;
                    			   }
                    			   else 
                    			   {
                    			       $target_file = null;
                    			       
                    			   }
			  
			  
							   $user_new = DB::update('update customer SET signature= ? , dob = ? , fname = ? ,lname = ? ,phone = ? ,gender = ? ,age = ? , add1 = ? ,add2 = ?, country = ? ,state = ?, city = ? ,zipcode = ?   where customer_id= ?', [$target_file,$dob,$fname,$lname,$phone,$gender,$age,$add1,$add2,$country,$state,$city,$zipcode,$customer_id]);
            		           if($user_new)
            		           
                                  {
                                       if(isset($request['children']) && !empty($request['children']))
                                       {
                                           if(addItems($phone,$children)==1)
        									{
        									     $users = DB::select('select * from customer where customer_id = ?', [$customer_id]);
                                					if($users)
                                					{
                                					    
                                					    foreach ($users as $key)
                                						{
                                							$cusemail       =  $key->email;
                                							$childtype ="child";
                                							$userschild = DB::select('select * from customer where email = ? AND type = ? ', [$cusemail, $childtype]);
                                            					if($userschild)
                                            					{
                                            					    
                                            					   $key->children = $userschild;
                                            					   
                                            					    	
                                            					}
                                            					else
                                            					{
                                            				    	$key->children =null  ;
                                            					}
                                						
                                						}
                                					    	return response()->json(['status'=>'success','data'=>$users]);
                                					}
                                					else
                                					{
                                						return response()->json(['status'=>'failed','error'=>'Wrong Email']);
                                					}
                                					
        										//return response()->json(['status'=>'success']);  
        									}
        									else 
        									{
        										return response()->json(['status'=>'failed','error'=>'Sql Error 1']);
        									}
                                       }
                                       else 
                                       {
                                            $users = DB::select('select * from customer where customer_id = ?', [$customer_id]);
                                			if($users)
                                					{
                                					    
                                					    foreach ($users as $key)
                                						{
                                							$cusemail       =  $key->email;
                                							$childtype ="child";
                                							$userschild = DB::select('select * from customer where email = ? AND type = ? ', [$cusemail, $childtype]);
                                            					if($userschild)
                                            					{
                                            					    
                                            					   $key->children = $userschild;
                                            					   
                                            					    	
                                            					}
                                            					else
                                            					{
                                            				    $key->children=null;
                                            					}
                                						
                                						}
                                					    	return response()->json(['status'=>'success','data'=>$users]);
                                					}
                                					else
                                					{
                                						return response()->json(['status'=>'failed','error'=>'Wrong Email']);
                                					}
                                           // return response()->json(['status'=>'success']);     
                                       }
                                    
                                  }
                                else 
             					{
             					return response()->json(['status'=>'failed','error'=>'Sql Error']);
             					}  
							
							} 
							catch(\Illuminate\Database\QueryException $ex)
							{ 		
								$ff = 0;
							}	

					
					     
					}
					else 
					{
					    return response()->json(['status'=>'failed','error'=>'Email not Exists']);
					}

    	}
    	else
    	{
    	    return response()->json(['status'=>'failed','error'=>'Incomplete Parameters']);
    	}
    }
    
    public function UpdateCustomerStatus (Request $request)
    { 
	    if( isset($request['customer_id']) && !empty($request['customer_id']) )
		{
    	    $customer_id =$request['customer_id'];
    	    $parent = "parent";
			
		    $users = DB::select('select * from customer where customer_id = ?', [$customer_id]);
		    if($users)
			{
			    foreach ($users as $key)
                {
                    $custype  =  $key->type;
                }
            
            	try 
				{ 
				    if( $custype == "single child" )
				    {
    				    $user_new = DB::update('update customer SET type = ? where customer_id= ?', [$parent,$customer_id]);
        	            if($user_new)
        	            {
        	                return response()->json(['status'=>'success']);     
                        }
                        else 
         				{
         				    return response()->json(['status'=>'failed','error'=>'Sql Error']);
         				}  
					} 
					else
					{
					    return response()->json(['status'=>'failed','error'=>'You can not update Parent or Child.']);
					}
				}
				catch(\Illuminate\Database\QueryException $ex)
				{ 		
					$ff = 0;
				}	
			}
			else 
			{
			    return response()->json(['status'=>'failed','error'=>'Customer does not Exists']);
			}
    	}
    	else
    	{
    	    return response()->json(['status'=>'failed','error'=>'Incomplete Parameters']);
    	}
    }
    
    public function CustomerSignupOLD (Request $request)
    { 
	 if(isset($request['dob']) && !empty($request['dob']) 
		AND isset($request['fname']) && !empty($request['fname'])
		AND isset($request['lname']) && !empty($request['lname'])
		AND isset($request['phone']) && !empty($request['phone'])
		AND isset($request['photo']) && !empty($request['photo'])
		AND isset($request['email']) && !empty($request['email']))
		{
    	    
    	       $dob =$request['dob'];
    	       $fname =$request['fname'];
    	       $lname = $request['lname'];
    	       $phone = $request['phone'];
			   $email = $request['email'];
			   $customer_id= mt_rand(100000, 999999);
			   
			   $request->file('photo');
			 $destinationPath='public/pictures';
			 $file=$request->photo;
			 $extention=$request->photo->extension();
			//  $extention=$file->getClientOriginalExtention();
			 $fileName=round(microtime(true)).".".$extention;
			 $file->move($destinationPath,$fileName);
			 $photo=$fileName;
			 $destination = "pictures/";
			 $target_file = $destination. $photo;
			 
			 
			 $users = DB::select('select * from customer where email = ?', [$email]);
					if($users)
					{
					     return response()->json(['status'=>'failed','error'=>'Email Already Exits']);
					}
					else 
					{
					      try 
        				{ 
        				
        					$inserteed = DB::insert('insert into customer (customer_id,dob,fname,lname,phone,signature,email) 
        					values (?,?,?,?,?,?,?)',[$customer_id,$dob,$fname,$lname,$phone,$target_file,$email]);
        					
        					
        		           if($inserteed)
                              {
                                return response()->json(['status'=>'success']);
                              }
                            else 
         					{
         					return response()->json(['status'=>'failed','error'=>'Sql Error']);
         					}  
         					
         					
        				} 
        				catch(\Illuminate\Database\QueryException $ex)
        				{ 		
        					return response()->json(['status'=>'failed','error'=>'This account already exists']);
        				}
					    
					}
			   
			 
			    
    	}
    	else
    	{
    	    return response()->json(['status'=>'failed','error'=>'Incomplete Parameters']);
    	}
    }
    
    /*public function CustomerSearch (Request $request)
    { 
		if(isset($request['phone']) && !empty($request['phone'])) 
		{
			$phone=$request['phone'];
			$childtype2 = "child";
			try 
			{ 
                $users = DB::select('select * from customer where phone = ? AND type != ?', [$phone,$childtype2]);
				if($users)
				{
				    foreach ($users as $key)
					{
					    $cusphone       =  $key->phone;
						$parent_id       =  $key->customer_id;
						
						$users_order = DB::select('select * from bookings where customer_id = ? ORDER BY created_at DESC LIMIT 1', [$parent_id]);
    					if($users_order)
    					{
                            foreach ($users_order as $key2)
    						{
    							$timestamp       =  $key2->timestamp;
    							$bk_id       =  $key2->bk_id;
    							$initial_hours       =  $key2->initial_hours;
    							$added_hours       =  $key2->added_hours;
    							$price_per_hour       =  $key2->price_per_hour;
    							$end_time       =  $key2->end_time;
    							$add_price_per_hour       =  $key2->add_price_per_hour;
    						}
        						
                            $key->order_time = $timestamp;
                            $key->bk_id = $bk_id;
                            $key->initial_hours = $initial_hours;
                            $key->added_hours = $added_hours;
                            $key->price_per_hour = $price_per_hour;
                            $key->end_time =  $end_time;
                            $key->add_price_per_hour =  $add_price_per_hour;
    					}
    					else
    					{
                            $key->order_time = null;
                            $key->bk_id = null;
                            $key->initial_hours = null;
                            $key->added_hours = null;
                            $key->price_per_hour = null;
                            $key->end_time =  null;
                            $key->add_price_per_hour = null;
    					}
						
						$childtype ="child";
						$userschild = DB::select('select * from customer where phone = ? AND type = ? ', [$cusphone, $childtype]);
    					if($userschild)
    					{
    			            foreach ($userschild as $key21)
        					{
        						$cusphone       =  $key21->phone;
        						$parent_id2       =  $key21->customer_id;
        						
        						$users_order2 = DB::select('select * from bookings where customer_id = ? ORDER BY created_at DESC LIMIT 1', [$parent_id2]);
            					if($users_order2)
            					{
                                    foreach ($users_order2 as $key22)
            						{
            							$timestamp2       =  $key22->timestamp;
            						    $bk_id2       =  $key22->bk_id;
            							$initial_hours2       =  $key22->initial_hours;
            							$added_hours2      =  $key22->added_hours;
            							$price_per_hour2       =  $key22->price_per_hour;
            							$end_time2       =  $key22->end_time;
            							$add_price_per_hour2       =  $key22->add_price_per_hour;
            						}
                						
                                    $key21->order_time = $timestamp2;
                                    $key21->initial_hours = $initial_hours2;
                                    $key21->added_hours = $added_hours2;
                                    $key21->price_per_hour = $price_per_hour2;
                                    $key21->bk_id2 = $bk_id2;
                                    $key21->end_time =  $end_time2;
                                    $key21->add_price_per_hour = $add_price_per_hour2;
            					}
            					else
            					{
                                    $key21->order_time = null;
                                    $key21->initial_hours = null;
                                    $key21->added_hours = null;
                                    $key21->price_per_hour = null;
                                    $key21->bk_id2 = null;
                                    $key21->end_time =  null;
                                    $key21->add_price_per_hour = null;
            					}
        					}
    					    $key->children = $userschild;
    					}
    					else
    					{
    				    	$key->children = null;
    					}
					}
				    return response()->json(['status'=>'success','data'=>$users]);
				    
				}
				else
				{
					return response()->json(['status'=>'failed','error'=>'Wrong phone number']);
				}	
				  
			} 
			catch(\Illuminate\Database\QueryException $ex)
			{ 		
				return response()->json(['status'=>'failed','error'=>'Sql Error']);
			}
		
		}
		elseif(isset($request['email']) && !empty($request['email'])) 
		{
			$email=$request['email'];
			$childtype2 = "parent";
			try 
			{ 
                $users = DB::select('select * from customer where email = ? AND type = ?', [$email,$childtype2]);
				if($users)
				{
				    foreach ($users as $key)
					{
						$cusphone       =  $key->phone;
						$cusemail       =  $key->email;
						$parent_id       =  $key->customer_id;
						
						$users_order = DB::select('select * from bookings where customer_id = ? ORDER BY created_at DESC LIMIT 1', [$parent_id]);
    					if($users_order)
    					{
    					    foreach ($users_order as $key2)
    						{
    							$timestamp       =  $key2->timestamp;
    							$bk_id       =  $key2->bk_id;
    							$initial_hours       =  $key2->initial_hours;
    							$added_hours       =  $key2->added_hours;
    							$price_per_hour       =  $key2->price_per_hour;
    							$end_time       =  $key2->end_time;
    						    $add_price_per_hour       =  $key2->add_price_per_hour;
    						}
    						
    					    $key->order_time = $timestamp;
    					    $key->bk_id = $bk_id;
    					    $key->initial_hours = $initial_hours;
    					    $key->added_hours = $added_hours;
    					    $key->price_per_hour = $price_per_hour;
    					    $key->end_time =  $end_time;
    					    $key->add_price_per_hour = $add_price_per_hour;
    					}
    					else
    					{
    				    	$key->order_time = null;
    				    	$key->bk_id = null;
        				    $key->initial_hours = null;
        					$key->added_hours = null;
        					$key->price_per_hour = null;
        					$key->end_time =  null;
        					$key->add_price_per_hour = null;
    					}
						
						$childtype ="child";
						$userschild = DB::select('select * from customer where email = ? AND type = ? ', [$cusemail, $childtype]);
						if($userschild)
        				{
    					    foreach ($userschild as $key21)
        					{
        						$cusphone       =  $key21->phone;
        						$parent_id2       =  $key21->customer_id;
        						
        						$users_order2 = DB::select('select * from bookings where customer_id = ? ORDER BY created_at DESC LIMIT 1', [$parent_id2]);
            					if($users_order2)
            					{
                                    foreach ($users_order2 as $key22)
            						{
            							$timestamp2       =  $key22->timestamp;
            						    $bk_id2       =  $key22->bk_id;
            							$initial_hours2       =  $key22->initial_hours;
            							$added_hours2      =  $key22->added_hours;
            							$price_per_hour2       =  $key22->price_per_hour;
            							$end_time2       =  $key22->end_time;
            							$add_price_per_hour2       =  $key22->add_price_per_hour;
            						}
            						
                                    $key21->order_time = $timestamp2;
                                    $key21->initial_hours = $initial_hours2;
                                    $key21->added_hours = $added_hours2;
                                    $key21->price_per_hour = $price_per_hour2;
                                    $key21->bk_id2 = $bk_id2;
                                    $key21->end_time =  $end_time2;
                                    $key21->add_price_per_hour = $add_price_per_hour2;
            					}
            					else
            					{
                                    $key21->order_time = null;
                                    $key21->initial_hours = null;
                                    $key21->added_hours = null;
                                    $key21->price_per_hour = null;
                                    $key21->bk_id2 = null;
                                    $key21->end_time =  null;
                                    $key21->add_price_per_hour = null;
            					}
        					}
    					    $key->children = $userschild;
    					}
    					else
    					{
    				    	$key->children = null;
    					}
					}
				    return response()->json(['status'=>'success','data'=>$users]);
				    
				}
				else
				{
					return response()->json(['status'=>'failed','error'=>'Wrong phone number']);
				}	
				  
			} 
			catch(\Illuminate\Database\QueryException $ex)
			{ 		
				return response()->json(['status'=>'failed','error'=>'Sql Error']);
			}
		
		}
		elseif(isset($request['fname']) && !empty($request['fname'])) 
		{
			$fname=$request['fname'];
			$childtype2 = "child";
			try 
			{ 
                $users = DB::select('select * from customer where fname = ? AND type != ?', [$fname,$childtype2]);
				if($users)
				{
				    foreach ($users as $key)
					{
						$cusphone       =  $key->phone;
						$parent_id       =  $key->customer_id;
						
						$users_order = DB::select('select * from bookings where customer_id = ? ORDER BY created_at DESC LIMIT 1', [$parent_id]);
        				if($users_order)
        				{
            				foreach ($users_order as $key2)
            			    {
            				    $timestamp       =  $key2->timestamp;
            					//return "this".$timestamp;
            					$initial_hours       =  $key2->initial_hours;
            					$added_hours       =  $key2->added_hours;
            					$price_per_hour       =  $key2->price_per_hour;
            					$end_time       =  $key2->end_time;
            					$add_price_per_hour       =  $key2->add_price_per_hour;
            				}
            						
                            $key->order_time = $timestamp;
                            $key->initial_hours = $initial_hours;
                            $key->added_hours = $added_hours;
                            $key->price_per_hour = $price_per_hour;
                            $key->end_time =  $end_time;
                            $key->add_price_per_hour = $add_price_per_hour;
        				}
        				else
        				{
        				    $key->order_time = null;
            				$key->initial_hours = null;
            				$key->added_hours = null;
            				$key->price_per_hour = null;
            				$key->end_time =  null;
            				$key->add_price_per_hour = null;
        				}
						
						$childtype ="child";
						$userschild = DB::select('select * from customer where phone = ? AND type = ? ', [$cusphone, $childtype]);
    					if($userschild)
    					{
    					   $key->children = $userschild;
    					}
    					else
    					{
    				    	$key->children = null;
    					}
					}
				    return response()->json(['status'=>'success','data'=>$users]);
				}
				else
				{
					return response()->json(['status'=>'failed','error'=>'Wrong phone number']);
				}	
				  
			} 
			catch(\Illuminate\Database\QueryException $ex)
			{ 		
				return response()->json(['status'=>'failed','error'=>'Sql Error']);
			}
		}
		elseif(isset($request['customer_id']) && !empty($request['customer_id'])) 
		{
			$customer_id=$request['customer_id'];
			try 
			{ 
                $users = DB::select('select * from customer where customer_id = ? ', [$customer_id]);
				if($users)
				{
				     foreach ($users as $key)
					{
					    
						$cusphone       =  $key->phone;
						$cusemail       =  $key->email;
						$parent_id       =  $key->customer_id;
						
						$users_order = DB::select('select * from bookings where customer_id = ? ORDER BY created_at DESC LIMIT 1', [$parent_id]);
    					if($users_order)
    					{
    					    foreach ($users_order as $key2)
    						{
    							$timestamp       =  $key2->timestamp;
    							$bk_id       =  $key2->bk_id;
    							//return "this".$timestamp;
    							$initial_hours       =  $key2->initial_hours;
    							$added_hours       =  $key2->added_hours;
    							$price_per_hour       =  $key2->price_per_hour;
    							$end_time       =  $key2->end_time;
    							$add_price_per_hour       =  $key2->add_price_per_hour;
    						}
    					    $key->order_time = $timestamp;
    					    $key->bk_id = $bk_id;
    					    $key->initial_hours = $initial_hours;
    					    $key->added_hours = $added_hours;
    					    $key->price_per_hour = $price_per_hour;
    					    $key->end_time =  $end_time;
    					    $key->add_price_per_hour = $add_price_per_hour;
    					}
    					else
    					{
    				    	$key->order_time = null;
    				    	$key->bk_id = null;
        				    $key->initial_hours = null;
        					$key->added_hours = null;
        					$key->price_per_hour = null;
        					$key->end_time =  null;
        					$key->add_price_per_hour = null;
    					}
						
						$childtype ="child";
						$userschild = DB::select('select * from customer where email = ? AND type = ? ', [$cusemail, $childtype]);
						if($userschild)
        				{
    					    foreach ($userschild as $key21)
        					{
        						$cusphone       =  $key21->phone;
        						$parent_id2       =  $key21->customer_id;
        						
        						$users_order2 = DB::select('select * from bookings where customer_id = ? ORDER BY created_at DESC LIMIT 1', [$parent_id2]);
            					if($users_order2)
            					{
                                    foreach ($users_order2 as $key22)
            						{
            							$timestamp2       =  $key22->timestamp;
            						    $bk_id2       =  $key22->bk_id;
            							$initial_hours2       =  $key22->initial_hours;
            							$added_hours2      =  $key22->added_hours;
            							$price_per_hour2       =  $key22->price_per_hour;
            							$end_time2       =  $key22->end_time;
            							$add_price_per_hour2       =  $key22->add_price_per_hour;
            						}
            						
                                    $key21->order_time = $timestamp2;
                                    $key21->initial_hours = $initial_hours2;
                                    $key21->added_hours = $added_hours2;
                                    $key21->price_per_hour = $price_per_hour2;
                                    $key21->bk_id2 = $bk_id2;
                                    $key21->end_time =  $end_time2;
                                    $key21->add_price_per_hour = $add_price_per_hour2;
            					}
            					else
            					{
                                    $key21->order_time = null;
                                    $key21->initial_hours = null;
                                    $key21->added_hours = null;
                                    $key21->price_per_hour = null;
                                    $key21->bk_id2 = null;
                                    $key21->end_time =  null;
                                    $key21->add_price_per_hour = null;
            					}
        					}
    					    $key->children = $userschild;
    					}
    					else
    					{
    				    	$key->children = null;
    					}
					}
				    return response()->json(['status'=>'success','data'=>$users]);
				}
				else
				{
					return response()->json(['status'=>'failed','error'=>'Wrong phone number']);
				}	
				  
			} 
			catch(\Illuminate\Database\QueryException $ex)
			{ 		
				return response()->json(['status'=>'failed','error'=>'Sql Error']);
			}
		}
	    else 
		{
			return response()->json(['status'=>'failed','error'=>'Incomplete Parameters']);
		}
    }*/
    
    public function CustomerSearch (Request $request)
    { 
		if(isset($request['phone']) && !empty($request['phone'])) 
		{
			$phone=$request['phone'];
			//$register_id = $request['register_id'];
			$childtype2 = "child";
			try 
			{ 
                $users = DB::select('select * from customer where phone = ? AND type != ?', [$phone,$childtype2]);
				if($users)
				{
				    foreach ($users as $key)
					{
					    $cusphone       =  $key->phone;
						$parent_id       =  $key->customer_id;
						
						$users_order = DB::select('select * from bookings where customer_id = ? ORDER BY created_at DESC LIMIT 1', [$parent_id]);
    					if($users_order)
    					{
                            foreach ($users_order as $key2)
    						{
    							$timestamp       =  $key2->timestamp;
    							$bk_id       =  $key2->bk_id;
    							$initial_hours       =  $key2->initial_hours;
    							$added_hours       =  $key2->added_hours;
    							$price_per_hour       =  $key2->price_per_hour;
    							$end_time       =  $key2->end_time;
    							$add_price_per_hour       =  $key2->add_price_per_hour;
    						}
    						
    						$users_order30 = DB::select('select * from booking_addedhours where bk_id = ?  ORDER BY created_at ASC', [$bk_id]);
        					if($users_order30)
        					{
                                foreach ($users_order30 as $key30)
        						{
        							//$timestamp       =  $key30->timestamp;
        							//$bk_id       =  $key30->bk_id;
        							//$initial_hours       =  $key30->initial_hours;
        							$added_hours       =  $added_hours + $key30->added_hours;
        							//$price_per_hour       =  $price_per_hour + $key30->price_per_hour;
        							$end_time       =  $key30->end_time;
        							$add_price_per_hour       =  $add_price_per_hour + $key30->add_price_per_hour;
        						}
        					}
        						
                            $key->order_time = $timestamp;
                            $key->bk_id = $bk_id;
                            $key->initial_hours = $initial_hours;
                            $key->added_hours = $added_hours;
                            $key->price_per_hour = $price_per_hour;
                            $key->end_time =  $end_time;
                            $key->add_price_per_hour =  $add_price_per_hour;
    					}
    					else
    					{
                            $key->order_time = null;
                            $key->bk_id = null;
                            $key->initial_hours = null;
                            $key->added_hours = null;
                            $key->price_per_hour = null;
                            $key->end_time =  null;
                            $key->add_price_per_hour = null;
    					}
						
						$childtype ="child";
						$userschild = DB::select('select * from customer where phone = ? AND type = ? ', [$cusphone, $childtype]);
    					if($userschild)
    					{
    			            foreach ($userschild as $key21)
        					{
        						$cusphone       =  $key21->phone;
        						$parent_id2       =  $key21->customer_id;
        						
        						$users_order2 = DB::select('select * from bookings where customer_id = ? ORDER BY created_at DESC LIMIT 1', [$parent_id2]);
            					if($users_order2)
            					{
                                    foreach ($users_order2 as $key22)
            						{
            							$timestamp2       =  $key22->timestamp;
            						    $bk_id2       =  $key22->bk_id;
            							$initial_hours2       =  $key22->initial_hours;
            							$added_hours2      =  $key22->added_hours;
            							$price_per_hour2       =  $key22->price_per_hour;
            							$end_time2       =  $key22->end_time;
            							$add_price_per_hour2       =  $key22->add_price_per_hour;
            						}
            						
            						$users_order40 = DB::select('select * from booking_addedhours where bk_id = ?  ORDER BY created_at ASC', [$bk_id2]);
                					if($users_order40)
                					{
                                        foreach ($users_order40 as $key40)
                						{
                							//$timestamp2       =  $key40->timestamp;
                							//$bk_id2       =  $key40->bk_id;
                							//$initial_hours2       =  $key40$key40$key40->initial_hours;
                							$added_hours2       =  $added_hours2 + $key40->added_hours;
                							//$price_per_hour2       =  $price_per_hour2 + $key40->price_per_hour;
                							$end_time2       =  $key40->end_time;
                							$add_price_per_hour2       =  $add_price_per_hour2 + $key40->add_price_per_hour;
                						}
                					}
                						
                                    $key21->order_time = $timestamp2;
                                    $key21->initial_hours = $initial_hours2;
                                    $key21->added_hours = $added_hours2;
                                    $key21->price_per_hour = $price_per_hour2;
                                    $key21->bk_id2 = $bk_id2;
                                    $key21->end_time =  $end_time2;
                                    $key21->add_price_per_hour = $add_price_per_hour2;
            					}
            					else
            					{
                                    $key21->order_time = null;
                                    $key21->initial_hours = null;
                                    $key21->added_hours = null;
                                    $key21->price_per_hour = null;
                                    $key21->bk_id2 = null;
                                    $key21->end_time =  null;
                                    $key21->add_price_per_hour = null;
            					}
        					}
    					    $key->children = $userschild;
    					}
    					else
    					{
    				    	$key->children = null;
    					}
					}
				    return response()->json(['status'=>'success','data'=>$users]);
				    
				}
				else
				{
					return response()->json(['status'=>'failed','error'=>'Wrong phone number']);
				}	
				  
			} 
			catch(\Illuminate\Database\QueryException $ex)
			{ 		
				return response()->json(['status'=>'failed','error'=>'Sql Error']);
			}
		
		}
		elseif(isset($request['email']) && !empty($request['email'])) 
		{
			$email=$request['email'];
			$childtype2 = "parent";
			try 
			{ 
                $users = DB::select('select * from customer where email = ? AND type = ?', [$email,$childtype2]);
				if($users)
				{
				    foreach ($users as $key)
					{
						$cusphone       =  $key->phone;
						$cusemail       =  $key->email;
						$parent_id       =  $key->customer_id;
						
						$users_order = DB::select('select * from bookings where customer_id = ? ORDER BY created_at DESC LIMIT 1', [$parent_id]);
    					if($users_order)
    					{
    					    foreach ($users_order as $key2)
    						{
    							$timestamp       =  $key2->timestamp;
    							$bk_id       =  $key2->bk_id;
    							$initial_hours       =  $key2->initial_hours;
    							$added_hours       =  $key2->added_hours;
    							$price_per_hour       =  $key2->price_per_hour;
    							$end_time       =  $key2->end_time;
    						    $add_price_per_hour       =  $key2->add_price_per_hour;
    						}
    						
    						$users_order30 = DB::select('select * from booking_addedhours where bk_id = ?  ORDER BY created_at ASC', [$bk_id]);
        					if($users_order30)
        					{
                                foreach ($users_order30 as $key30)
        						{
        							//$timestamp       =  $key30->timestamp;
        							//$bk_id       =  $key30->bk_id;
        							//$initial_hours       =  $key30->initial_hours;
        							$added_hours       =  $added_hours + $key30->added_hours;
        							//$price_per_hour       =  $price_per_hour + $key30->price_per_hour;
        							$end_time       =  $key30->end_time;
        							$add_price_per_hour       =  $add_price_per_hour + $key30->add_price_per_hour;
        						}
        					}
    						
    					    $key->order_time = $timestamp;
    					    $key->bk_id = $bk_id;
    					    $key->initial_hours = $initial_hours;
    					    $key->added_hours = $added_hours;
    					    $key->price_per_hour = $price_per_hour;
    					    $key->end_time =  $end_time;
    					    $key->add_price_per_hour = $add_price_per_hour;
    					}
    					else
    					{
    				    	$key->order_time = null;
    				    	$key->bk_id = null;
        				    $key->initial_hours = null;
        					$key->added_hours = null;
        					$key->price_per_hour = null;
        					$key->end_time =  null;
        					$key->add_price_per_hour = null;
    					}
						
						$childtype ="child";
						$userschild = DB::select('select * from customer where email = ? AND type = ? ', [$cusemail, $childtype]);
						if($userschild)
        				{
    					    foreach ($userschild as $key21)
        					{
        						$cusphone       =  $key21->phone;
        						$parent_id2       =  $key21->customer_id;
        						
        						$users_order2 = DB::select('select * from bookings where customer_id = ? ORDER BY created_at DESC LIMIT 1', [$parent_id2]);
            					if($users_order2)
            					{
                                    foreach ($users_order2 as $key22)
            						{
            							$timestamp2       =  $key22->timestamp;
            						    $bk_id2       =  $key22->bk_id;
            							$initial_hours2       =  $key22->initial_hours;
            							$added_hours2      =  $key22->added_hours;
            							$price_per_hour2       =  $key22->price_per_hour;
            							$end_time2       =  $key22->end_time;
            							$add_price_per_hour2       =  $key22->add_price_per_hour;
            						}
            						
            						$users_order40 = DB::select('select * from booking_addedhours where bk_id = ?  ORDER BY created_at ASC', [$bk_id2]);
                					if($users_order40)
                					{
                                        foreach ($users_order40 as $key40)
                						{
                							//$timestamp2       =  $key40->timestamp;
                							//$bk_id2       =  $key40->bk_id;
                							//$initial_hours2       =  $key40$key40$key40->initial_hours;
                							$added_hours2       =  $added_hours2 + $key40->added_hours;
                							//$price_per_hour2       =  $price_per_hour2 + $key40->price_per_hour;
                							$end_time2       =  $key40->end_time;
                							$add_price_per_hour2       =  $add_price_per_hour2 + $key40->add_price_per_hour;
                						}
                					}
            						
                                    $key21->order_time = $timestamp2;
                                    $key21->initial_hours = $initial_hours2;
                                    $key21->added_hours = $added_hours2;
                                    $key21->price_per_hour = $price_per_hour2;
                                    $key21->bk_id2 = $bk_id2;
                                    $key21->end_time =  $end_time2;
                                    $key21->add_price_per_hour = $add_price_per_hour2;
            					}
            					else
            					{
                                    $key21->order_time = null;
                                    $key21->initial_hours = null;
                                    $key21->added_hours = null;
                                    $key21->price_per_hour = null;
                                    $key21->bk_id2 = null;
                                    $key21->end_time =  null;
                                    $key21->add_price_per_hour = null;
            					}
        					}
    					    $key->children = $userschild;
    					}
    					else
    					{
    				    	$key->children = null;
    					}
					}
				    return response()->json(['status'=>'success','data'=>$users]);
				    
				}
				else
				{
					return response()->json(['status'=>'failed','error'=>'Wrong phone number']);
				}	
				  
			} 
			catch(\Illuminate\Database\QueryException $ex)
			{ 		
				return response()->json(['status'=>'failed','error'=>'Sql Error']);
			}
		
		}
		elseif(isset($request['fname']) && !empty($request['fname'])) 
		{
			$fname=$request['fname'];
			$childtype2 = "child";
			try 
			{ 
                $users = DB::select('select * from customer where fname = ? AND type != ?', [$fname,$childtype2]);
				if($users)
				{
				    foreach ($users as $key)
					{
						$cusphone       =  $key->phone;
						$parent_id       =  $key->customer_id;
						
						$users_order = DB::select('select * from bookings where customer_id = ? ORDER BY created_at DESC LIMIT 1', [$parent_id]);
        				if($users_order)
        				{
            				foreach ($users_order as $key2)
    						{
    							$timestamp       =  $key2->timestamp;
    							$bk_id       =  $key2->bk_id;
    							$initial_hours       =  $key2->initial_hours;
    							$added_hours       =  $key2->added_hours;
    							$price_per_hour       =  $key2->price_per_hour;
    							$end_time       =  $key2->end_time;
    							$add_price_per_hour       =  $key2->add_price_per_hour;
    						}
    						
    						$users_order30 = DB::select('select * from booking_addedhours where bk_id = ?  ORDER BY created_at ASC', [$bk_id]);
        					if($users_order30)
        					{
                                foreach ($users_order30 as $key30)
        						{
        							//$timestamp       =  $key30->timestamp;
        							//$bk_id       =  $key30->bk_id;
        							//$initial_hours       =  $key30->initial_hours;
        							$added_hours       =  $added_hours + $key30->added_hours;
        							//$price_per_hour       =  $price_per_hour + $key30->price_per_hour;
        							$end_time       =  $key30->end_time;
        							$add_price_per_hour       =  $add_price_per_hour + $key30->add_price_per_hour;
        						}
        					}
            						
                            $key->order_time = $timestamp;
                            $key->bk_id = $bk_id;
                            $key->initial_hours = $initial_hours;
                            $key->added_hours = $added_hours;
                            $key->price_per_hour = $price_per_hour;
                            $key->end_time =  $end_time;
                            $key->add_price_per_hour = $add_price_per_hour;
        				}
        				else
        				{
        				    $key->order_time = null;
        				    $key->bk_id = null;
            				$key->initial_hours = null;
            				$key->added_hours = null;
            				$key->price_per_hour = null;
            				$key->end_time =  null;
            				$key->add_price_per_hour = null;
        				}
						
						$childtype ="child";
						$userschild = DB::select('select * from customer where phone = ? AND type = ? ', [$cusphone, $childtype]);
    					if($userschild)
    					{
    					   $key->children = $userschild;
    					}
    					else
    					{
    				    	$key->children = null;
    					}
					}
				    return response()->json(['status'=>'success','data'=>$users]);
				}
				else
				{
					return response()->json(['status'=>'failed','error'=>'Wrong phone number']);
				}	
				  
			} 
			catch(\Illuminate\Database\QueryException $ex)
			{ 		
				return response()->json(['status'=>'failed','error'=>'Sql Error']);
			}
		}
		elseif(isset($request['customer_id']) && !empty($request['customer_id'])) 
		{
			$customer_id=$request['customer_id'];
			
			try 
			{ 
                $users = DB::select('select * from customer where customer_id = ? ', [$customer_id]);
				if($users)
				{
				     foreach ($users as $key)
					{
					    
						$cusphone       =  $key->phone;
						$cusemail       =  $key->email;
						$parent_id       =  $key->customer_id;
						
						$users_order = DB::select('select * from bookings where customer_id = ? ORDER BY created_at DESC LIMIT 1', [$parent_id]);
    					if($users_order)
    					{
    					    foreach ($users_order as $key2)
    						{
    							$timestamp       =  $key2->timestamp;
    							$bk_id       =  $key2->bk_id;
    							//return "this".$timestamp;
    							$initial_hours       =  $key2->initial_hours;
    							$added_hours       =  $key2->added_hours;
    							$price_per_hour       =  $key2->price_per_hour;
    							$end_time       =  $key2->end_time;
    							$add_price_per_hour       =  $key2->add_price_per_hour;
    						}
    						
    						$users_order30 = DB::select('select * from booking_addedhours where bk_id = ?  ORDER BY created_at ASC', [$bk_id]);
        					if($users_order30)
        					{
                                foreach ($users_order30 as $key30)
        						{
        							//$timestamp       =  $key30->timestamp;
        							//$bk_id       =  $key30->bk_id;
        							//$initial_hours       =  $key30->initial_hours;
        							$added_hours       =  $added_hours + $key30->added_hours;
        							//$price_per_hour       =  $price_per_hour + $key30->price_per_hour;
        							$end_time       =  $key30->end_time;
        							$add_price_per_hour       =  $add_price_per_hour + $key30->add_price_per_hour;
        						}
        					}
        					
    					    $key->order_time = $timestamp;
    					    $key->bk_id = $bk_id;
    					    $key->initial_hours = $initial_hours;
    					    $key->added_hours = $added_hours;
    					    $key->price_per_hour = $price_per_hour;
    					    $key->end_time =  $end_time;
    					    $key->add_price_per_hour = $add_price_per_hour;
    					}
    					else
    					{
    				    	$key->order_time = null;
    				    	$key->bk_id = null;
        				    $key->initial_hours = null;
        					$key->added_hours = null;
        					$key->price_per_hour = null;
        					$key->end_time =  null;
        					$key->add_price_per_hour = null;
    					}
						
						$childtype ="child";
						$userschild = DB::select('select * from customer where email = ? AND type = ? ', [$cusemail, $childtype]);
						if($userschild)
        				{
    					    foreach ($userschild as $key21)
        					{
        						$cusphone       =  $key21->phone;
        						$parent_id2       =  $key21->customer_id;
        						
        						$users_order2 = DB::select('select * from bookings where customer_id = ? ORDER BY created_at DESC LIMIT 1', [$parent_id2]);
            					if($users_order2)
            					{
                                    foreach ($users_order2 as $key22)
            						{
            							$timestamp2       =  $key22->timestamp;
            						    $bk_id2       =  $key22->bk_id;
            							$initial_hours2       =  $key22->initial_hours;
            							$added_hours2      =  $key22->added_hours;
            							$price_per_hour2       =  $key22->price_per_hour;
            							$end_time2       =  $key22->end_time;
            							$add_price_per_hour2       =  $key22->add_price_per_hour;
            						}
            						
            						$users_order40 = DB::select('select * from booking_addedhours where bk_id = ?  ORDER BY created_at ASC', [$bk_id2]);
                					if($users_order40)
                					{
                                        foreach ($users_order40 as $key40)
                						{
                							//$timestamp2       =  $key40->timestamp;
                							//$bk_id2       =  $key40->bk_id;
                							//$initial_hours2       =  $key40$key40$key40->initial_hours;
                							$added_hours2       =  $added_hours2 + $key40->added_hours;
                							//$price_per_hour2       =  $price_per_hour2 + $key40->price_per_hour;
                							$end_time2       =  $key40->end_time;
                							$add_price_per_hour2       =  $add_price_per_hour2 + $key40->add_price_per_hour;
                						}
                					}
            						
                                    $key21->order_time = $timestamp2;
                                    $key21->initial_hours = $initial_hours2;
                                    $key21->added_hours = $added_hours2;
                                    $key21->price_per_hour = $price_per_hour2;
                                    $key21->bk_id2 = $bk_id2;
                                    $key21->end_time =  $end_time2;
                                    $key21->add_price_per_hour = $add_price_per_hour2;
            					}
            					else
            					{
                                    $key21->order_time = null;
                                    $key21->initial_hours = null;
                                    $key21->added_hours = null;
                                    $key21->price_per_hour = null;
                                    $key21->bk_id2 = null;
                                    $key21->end_time =  null;
                                    $key21->add_price_per_hour = null;
            					}
        					}
    					    $key->children = $userschild;
    					}
    					else
    					{
    				    	$key->children = null;
    					}
					}
				    return response()->json(['status'=>'success','data'=>$users]);
				}
				else
				{
					return response()->json(['status'=>'failed','error'=>'Wrong phone number']);
				}	
				  
			} 
			catch(\Illuminate\Database\QueryException $ex)
			{ 		
				return response()->json(['status'=>'failed','error'=>'Sql Error']);
			}
		}
	    else 
		{
			return response()->json(['status'=>'failed','error'=>'Incomplete Parameters']);
		}
    }
      
	public function ForgetPasswords (Request $request)
	{
		
	}
    
    public function MultipleBookings (Request $request)
    { 
	    if(isset($request['booking_details']) && !empty($request['booking_details']) )
		{
    	    
	        $booking_details =$request['booking_details'];
	       
		    function addItems($option_details11)
			{
				$data = json_decode($option_details11);
				foreach ($data as $key)
				{
	                //$added_hours ="nil";
	                $bk_id = mt_rand(100000, 999999);
	               
					$customer_id      =  $key->customer_id;
					$employee_id      =  $key->employee_id;
					$payment_method   =  $key->payment_method;
					$timestamp        =  $key->timestamp;
					$no_of_bands      =  $key->no_of_bands;
					$price_per_hour   =  $key->price_per_hour;
					$order_total      =  $key->order_total;
					$balance          =  $key->balance;
					$initial_hours    =  $key->initial_hours;
					$end_time         =  $key->end_time;
					$register_id      =  $key->register_id;
							
					try 
    				{ 
    					$inserteed = DB::insert('insert into bookings (register_id,bk_id,customer_id,employee_id,payment_method,no_of_bands,timestamp,price_per_hour,order_total,balance,initial_hours,end_time) 
    					values (?,?,?,?,?,?,?,?,?,?,?,?)',[$register_id,$bk_id,$customer_id,$employee_id,$payment_method,$no_of_bands,$timestamp,$price_per_hour,$order_total,$balance,$initial_hours,$end_time]);
    					
    		            if($inserteed)
                        {
                            $ff =1;
                        }
                        else 
     					{
     					    $ff =0;
     					}  
    				} 
    				catch(\Illuminate\Database\QueryException $ex)
    				{ 		
    					$ff = 0;
    				}												
				}
				return $ff;
			}
		      
		    if(addItems($booking_details)==1)
			{
			    return response()->json(['status'=>'success']);  
			}
			else 
			{
				return response()->json(['status'=>'failed','error'=>'Sql Error 1']);
			}
    	}
    	else
    	{
    	    return response()->json(['status'=>'failed','error'=>'Incomplete Parameters']);
    	}
    }
    
    public function AddBooking (Request $request)
    { 
        
	 if(isset($request['customer_id']) && !empty($request['customer_id']) 
		AND isset($request['employee_id']) && !empty($request['employee_id'])
		AND isset($request['payment_method']) && !empty($request['payment_method'])
		AND isset($request['timestamp']) && !empty($request['timestamp'])
		AND isset($request['no_of_bands']) && !empty($request['no_of_bands'])
		AND isset($request['price_per_hour']) && !empty($request['price_per_hour'])
		AND isset($request['order_total']) && !empty($request['order_total'])
		AND isset($request['initial_hours']) && !empty($request['initial_hours'])
		)
		{
    	    
    	       $customer_id =$request['customer_id'];
    	       $employee_id =$request['employee_id'];
    	       
    	        $payment_method =$request['payment_method'];
    	         $timestamp =$request['timestamp'];
    	          $no_of_bands =$request['no_of_bands'];
    	           $price_per_hour =$request['price_per_hour'];
    	            $order_total =$request['order_total'];
    	             $balance =$request['balance'];
    	              $initial_hours =$request['initial_hours'];
    	              $added_hours ="nil";
    	                $bk_id = mt_rand(100000, 999999);
    	                $register_id =$request['register_id'];
    	       
			   
			   try 
				{ 
				
					$inserteed = DB::insert('insert into bookings (register_id,bk_id,customer_id,employee_id,payment_method,no_of_bands,timestamp,price_per_hour,order_total,balance,initial_hours,added_hours) 
					values (?,?,?,?,?,?,?,?,?,?,?,?)',[$register_id,$bk_id,$customer_id,$employee_id,$payment_method,$no_of_bands,$timestamp,$price_per_hour,$order_total,$balance,$initial_hours,$added_hours]);
					
					
		           if($inserteed)
                      {
                        return response()->json(['status'=>'success']);
                      }
                    else 
 					{
 					return response()->json(['status'=>'failed','error'=>'Sql Error']);
 					}  
 					
 					
				} 
				catch(\Illuminate\Database\QueryException $ex)
				{ 		
					return response()->json(['status'=>'failed','error'=>'try again']);
				}
			    
    	}
    	else
    	{
    	    return response()->json(['status'=>'failed','error'=>'Incomplete Parameters']);
    	}
    }
    
    public function UpdateBooking (Request $request)
    { 
	 if(isset($request['bk_id']) && !empty($request['bk_id']) 
		AND isset($request['added_hours']) && !empty($request['added_hours']) )
		{
    	    
    	      $bk_id =$request['bk_id'];
    	      $added_hours =$request['added_hours'];
    	      $add_payment_method =$request['add_payment_method'];
    	      $add_timestamp =$request['add_timestamp'];
    	      $add_price_per_hour =$request['add_price_per_hour'];
    	      $add_order_total =$request['add_order_total'];
    	      $end_time =$request['end_time'];
    	      
                $data2 = DB::select("select * from bookings where  bk_id = '$bk_id'");	   
    		    if($data2)
    		    {
    		       	foreach($data2 as $u2)
    		       	{
    					$added_hours = $added_hours + $u2->added_hours;
    					$add_price_per_hour = $add_price_per_hour + $u2->add_price_per_hour;
    					$add_order_total = $add_order_total + $u2->add_order_total;
    		       	}
    		    }
    		    else
    		    {
    			    $opening_balance = 0;
    		    }
    	 
			   try 
				{
				    $inserted = DB::update("update  bookings SET  end_time='$end_time' , added_hours='$added_hours', add_payment_method='$add_payment_method', add_timestamp='$add_timestamp', add_price_per_hour='$add_price_per_hour', add_order_total='$add_order_total' where bk_id='$bk_id'");
					
		            if($inserted)
                    {
                        return response()->json(['status'=>'success']);
                    }
                    else 
 					{
 					    return response()->json(['status'=>'failed','error'=>'Sql Error']);
 					}  
				} 
				catch(\Illuminate\Database\QueryException $ex)
				{ 		
					return response()->json(['status'=>'failed','error'=>'try again']);
				}
    	}
    	else
    	{
    	    return response()->json(['status'=>'failed','error'=>'Incomplete Parameters']);
    	}
    }
    
    /*public function AddAddedHours (Request $request)
    { 
	 if(isset($request['bk_id']) && !empty($request['bk_id']) 
		AND isset($request['added_hours']) && !empty($request['added_hours']) )
		{
    	      $bk_id =$request['bk_id'];
    	      $added_hours =$request['added_hours'];
    	      $add_payment_method =$request['add_payment_method'];
    	      $add_timestamp =$request['add_timestamp'];
    	      $add_price_per_hour =$request['add_price_per_hour'];
    	      $add_order_total =$request['add_order_total'];
    	      $register_id =$request['register_id'];
    	       $register_id =$request['register_id'];
    	      $end_time =$request['end_time'];
    	        
			   try 
				{ 
				
					$inserteed = DB::insert('insert into booking_addedhours (bk_id,added_hours,add_payment_method,add_timestamp,add_price_per_hour,add_order_total,register_id,end_time) 
					values (?,?,?,?,?,?,?,?)',[$bk_id,$added_hours,$add_payment_method,$add_timestamp,$add_price_per_hour,$add_order_total,$register_id,$end_time]);
					
					
		           if($inserteed)
                      {
                        return response()->json(['status'=>'success']);
                      }
                    else 
 					{
 					return response()->json(['status'=>'failed','error'=>'Sql Error']);
 					}  
 					
 					
				} 
				catch(\Illuminate\Database\QueryException $ex)
				{ 		
					return response()->json(['status'=>'failed','error'=>'try again']);
				}
				
                $data2 = DB::select("select * from bookings where  bk_id = '$bk_id'");	   
    		    if($data2)
    		    {
    		       	foreach($data2 as $u2)
    		       	{
    					$added_hours = $added_hours + $u2->added_hours;
    					$add_price_per_hour = $add_price_per_hour + $u2->add_price_per_hour;
    					$add_order_total = $add_order_total + $u2->add_order_total;
    		       	}
    		    }
    		    else
    		    {
    			    $opening_balance = 0;
    		    }
    	 
			   try 
				{
				    $inserted = DB::update("update  bookings SET  end_time='$end_time' , added_hours='$added_hours', add_payment_method='$add_payment_method', add_timestamp='$add_timestamp', add_price_per_hour='$add_price_per_hour', add_order_total='$add_order_total' where bk_id='$bk_id'");
					
		            if($inserted)
                    {
                        return response()->json(['status'=>'success']);
                    }
                    else 
 					{
 					    return response()->json(['status'=>'failed','error'=>'Sql Error']);
 					}  
				} 
				catch(\Illuminate\Database\QueryException $ex)
				{ 		
					return response()->json(['status'=>'failed','error'=>'try again']);
				}
    	}
    	else
    	{
    	    return response()->json(['status'=>'failed','error'=>'Incomplete Parameters']);
    	}
    }*/
    
    public function AddAddedHours (Request $request)
    { 
	 if(isset($request['bk_id']) && !empty($request['bk_id']) 
		AND isset($request['added_hours']) && !empty($request['added_hours']) )
		{
    	      $bk_id =$request['bk_id'];
    	      $added_hours =$request['added_hours'];
    	      $add_payment_method =$request['add_payment_method'];
    	      $add_timestamp =$request['add_timestamp'];
    	      $add_price_per_hour =$request['add_price_per_hour'];
    	      $add_order_total =$request['add_order_total'];
    	      $register_id =$request['register_id'];
    	      $end_time =$request['end_time'];
    	      
    	      $data2 = DB::select("select * from booking_addedhours where  bk_id = '$bk_id' AND register_id = '$register_id'");	   
    		  if($data2)
    		  {
    		   	foreach($data2 as $u2)
    		   	{
    				$added_hours = $added_hours + $u2->added_hours;
    				$add_price_per_hour = $add_price_per_hour + $u2->add_price_per_hour;
    				$add_order_total = $add_order_total + $u2->add_order_total;
    		   	}
    		   	
    		   	try 
				{
				    $inserted = DB::update("update  booking_addedhours SET  end_time='$end_time' , added_hours='$added_hours', add_payment_method='$add_payment_method', add_timestamp='$add_timestamp', add_price_per_hour='$add_price_per_hour', add_order_total='$add_order_total' where bk_id='$bk_id'");
					
		            if($inserted)
                    {
                        return response()->json(['status'=>'success']);
                    }
                    else 
 					{
 					    return response()->json(['status'=>'failed','error'=>'Sql Error']);
 					}  
				} 
				catch(\Illuminate\Database\QueryException $ex)
				{ 		
					return response()->json(['status'=>'failed','error'=>'try again']);
				}
    		  }
    		  else
    		  {
			    try 
				{ 
					$inserteed = DB::insert('insert into booking_addedhours (bk_id,added_hours,add_payment_method,add_timestamp,add_price_per_hour,add_order_total,register_id,end_time) 
					values (?,?,?,?,?,?,?,?)',[$bk_id,$added_hours,$add_payment_method,$add_timestamp,$add_price_per_hour,$add_order_total,$register_id,$end_time]);
		            if($inserteed)
                    {
                        return response()->json(['status'=>'success']);
                    }
                    else 
 					{
 					    return response()->json(['status'=>'failed','error'=>'Sql Error']);
 					}  
				} 
				catch(\Illuminate\Database\QueryException $ex)
				{ 		
					return response()->json(['status'=>'failed','error'=>'try again']);
				}
    		  }
    	}
    	else
    	{
    	    return response()->json(['status'=>'failed','error'=>'Incomplete Parameters']);
    	}
    }

    public function DeleteChild (Request $request)
	{ 

		if(isset($request['customer_id']) && !empty($request['customer_id'])) 
			{
				
				$customer_id=$request['customer_id'];

				$users_posts = DB::select('select * from customer where customer_id = ?', [$customer_id]);
				if($users_posts)
				{
					
					try 
					{ 
						$users_d = DB::delete('DELETE  from customer where customer_id = ?', [$customer_id]);
					
						if($users_d)
						{
					        return response()->json(['status'=>'success']);
							
						}
						else 
						{
							return response()->json(['status'=>'failed','error'=>'Sql Error']);
						}
					
					}
					
					catch(\Illuminate\Database\QueryException $ex)
					{ 		
						return response()->json(['status'=>'failed','error'=>'Sql Error']);
					}
			
				}
				else
				{
					return response()->json(['status'=>'failed','error'=>'Customer Does not exist']);
				}
			
					
						
			}

		else 
			{
				return response()->json(['status'=>'failed','error'=>'Incomplete Parameters']);
			}
	  
	}   
	
	public function CustomerSignin (Request $request)
    { 
		if(isset($request['email']) && !empty($request['email']) AND isset($request['password']) && !empty($request['password'])) 
			{
				$email=$request['email'];
				$Password=$request['password'];
				$new_pass =md5($Password);
				
				try 
				{ 
                    $users = DB::select('select * from customer where email = ? AND password = ? ', [$email, $new_pass]);
					if($users)
					{
					    foreach ($users as $key)
						{
							$cusphone  =  $key->phone;
							$cusemail  =  $key->email;
							$childtype =  "child";
							
							$userschild = DB::select('select * from customer where email = ? AND type = ? ', [$cusemail, $childtype]);
        					if($userschild)
        					{
        					   $key->children = $userschild;
        					}
        					else
        					{
        				    	$key->children = null;
        					}
						
						}
					    	return response()->json(['status'=>'success','data'=>$users]);
					}
					else
					{
						return response()->json(['status'=>'failed','error'=>'Wrong Email or Password']);
					}	
					  
				} 
				catch(\Illuminate\Database\QueryException $ex)
				{ 		
					return response()->json(['status'=>'failed','error'=>'Sql Error']);
				}
			
			}
			
		else 
			{
				return response()->json(['status'=>'failed','error'=>'Incomplete Parameters']);
			}
      
    }
    
    public function CustomerPwdChange (Request $request)
	{ 
		if(isset($request['customer_id']) && !empty($request['customer_id']) AND isset($request['old_password']) && !empty($request['old_password']) AND isset($request['new_password']) && !empty($request['new_password'])) 
		{
			
			$customer_id=$request['customer_id'];
			$New_Password=$request['new_password'];
			$New_Password1=md5($New_Password);
			$Old_Password=$request['old_password'];
			$Old_Password1 =md5($Old_Password);
			


					   
			$users = DB::select('select * from customer where customer_id = ? AND password = ? ', [$customer_id , $Old_Password1]);
			if($users)
			{
			    
				$user_new = DB::update('update customer SET password = ?  where customer_id = ?', [$New_Password1,$customer_id]);
				if ( $user_new)
				{
					return response()->json(['status'=>'success']);
				}
				else 
				{
					return response()->json(['status'=>'failed','error'=>'Sql Error1']);
				}
				
						
			}
			else
			{
				return response()->json(['status'=>'failed','error'=>'Old password does not match!']);
			}	
				  
			
		
		}
		else 
		{
			return response()->json(['status'=>'failed','error'=>'Incomplete Parameters']);
		}
	}
		
	public function CustomerPhoneEdit (Request $request)
	{ 
		if(isset($request['customer_id']) && !empty($request['customer_id']) AND isset($request['phone']) && !empty($request['phone']) ) 
		{
			
			$customer_id=$request['customer_id'];
			$phone=$request['phone'];
					   
			$users = DB::select('select * from customer where customer_id = ?', [$customer_id]);
			if($users)
			{
			    foreach ($users as $key)
				{
				    $cusemail     =  $key->email;
				}
			    
				$user_new = DB::update('update customer SET phone = ?  where email = ?', [$phone,$cusemail]);
				if ( $user_new)
				{
					return response()->json(['status'=>'success']);
				}
				else 
				{
					return response()->json(['status'=>'failed','error'=>'Sql Error1']);
				}
			}
			else
			{
				return response()->json(['status'=>'failed','error'=>'Customer not exist']);
			}	
				  
			
		
		}
		else 
		{
			return response()->json(['status'=>'failed','error'=>'Incomplete Parameters']);
		}
	}
		
	public function EditCustomerProfile2 (Request $request)
    { 
	 if(isset($request['dob']) && !empty($request['dob']) 
		AND isset($request['fname']) && !empty($request['fname'])
		AND isset($request['lname']) && !empty($request['lname'])
		AND isset($request['phone']) && !empty($request['phone'])
	
		AND isset($request['customer_id']) && !empty($request['customer_id']))
		{
    	    
    	       $dob =$request['dob'];
    	       $fname =$request['fname'];
    	       $lname = $request['lname'];
    	       $phone = $request['phone'];
			   $customer_id = $request['customer_id'];
			   $children=$request['children'];
			   $gender = $request['gender'];
			   $age = $request['age'];
			   $add1 = $request['add1'];
			   $add2 = $request['add2'];
			   $country = $request['country'];
			   $state = $request['state'];
			   $city = $request['city'];
			   $zipcode = $request['zipcode'];
			   $type = $request['type'];
			   
			   
			   $users2 = DB::select('select * from customer where customer_id = ?', [$customer_id ]);						
			   if($users2)
				{
					 
					try 
					{ 
						$user_new = DB::update('update customer SET dob = ? , fname = ? ,lname = ? ,phone = ? ,gender = ? ,age = ? , add1 = ? ,add2 = ?, country = ? ,state = ?, city = ? ,zipcode = ?   where customer_id= ?', [$dob,$fname,$lname,$phone,$gender,$age,$add1,$add2,$country,$state,$city,$zipcode,$customer_id]);
						if ( $user_new)
						{		
							return response()->json(['status'=>'success']);
						}
						else 
						{
							return response()->json(['status'=>'failed','error'=>'Sql Error1']);
						}
									
						
					} 
					catch(\Illuminate\Database\QueryException $ex)
					{ 		
						return response()->json(['status'=>'failed','error'=>'This account already exists']);
					}
					
				}
				else 
				{
					return response()->json(['status'=>'failed','error'=>'Email Not Exists']);
					
				}
											
			}
			
		else 
			{
				return response()->json(['status'=>'failed','error'=>'Incomplete Parameters']);
			}
		
	}
	
	public function AddBalance (Request $request)
    { 
	 if(isset($request['opening_date']) && !empty($request['opening_date']) 
		AND isset($request['opening_balance']) && !empty($request['opening_balance'])
		AND isset($request['opening_employee']) && !empty($request['opening_employee']) AND isset($request['register_id']) && !empty($request['register_id']))
		{
    	    
    	       $opening_date =$request['opening_date'];
    	       $opening_balance =$request['opening_balance'];
    	       $opening_employee = $request['opening_employee'];
    	       $closing_employee = $request['closing_employee'];
    	       $register_id = $request['register_id'];
    	       $location_id = $request['location_id'];
    	       $bm_id = mt_rand(1000, 9999);
    	       
    	       
    	      
			  try 
        				{ 
        				
        					$inserteed = DB::insert('insert into balance_managing (bm_id,opening_date,opening_balance,opening_employee,register_id,location_id) 
        					values (?,?,?,?,?,?)',[$bm_id,$opening_date,$opening_balance,$opening_employee,$register_id,$location_id]);
        					
        					
        		           if($inserteed)
                              {
                                return response()->json(['status'=>'success','bm_id'=>$bm_id]);
                              }
                            else 
         					{
         					return response()->json(['status'=>'failed','error'=>'Sql Error']);
         					}  
         					
         					
        				} 
        				catch(\Illuminate\Database\QueryException $ex)
        				{ 		
        					return response()->json(['status'=>'failed','error'=>'Try Again']);
        				}
			 
			    
    	}
    	else
    	{
    	    return response()->json(['status'=>'failed','error'=>'Incomplete Parameters']);
    	}
    }
    
    public function CloseBalance (Request $request)
    { 
	 if(isset($request['bm_id']) && !empty($request['bm_id']) 
		AND isset($request['closing_date']) && !empty($request['closing_date'])
		AND isset($request['closing_balance']) && !empty($request['closing_balance']))
		{
    	    
    	       $bm_id =$request['bm_id'];
    	       $closing_date =$request['closing_date'];
    	       $closing_balance = $request['closing_balance'];
    	       $closing_employee = $request['closing_employee'];
    	      
			  try 
        				{ 
        				
        					$inserteed = DB::update('update balance_managing SET  closing_employee = ? , closing_date = ? , closing_balance = ?  where bm_id= ?', [$closing_employee, $closing_date,$closing_balance,$bm_id]);
        		           if($inserteed)
                              {
                                return response()->json(['status'=>'success']);
                              }
                            else 
         					{
         					return response()->json(['status'=>'failed','error'=>'Sql Error']);
         					}  
         					
         					
        				} 
        				catch(\Illuminate\Database\QueryException $ex)
        				{ 		
        					return response()->json(['status'=>'failed','error'=>'Try Again']);
        				}
			    
    	}
    	else
    	{
    	    return response()->json(['status'=>'failed','error'=>'Incomplete Parameters']);
    	}
    }
    
	/*public function GetClosingBalance (Request $request)
	{ 
        if(isset($request['opening_date']) && !empty($request['opening_date']) AND isset($request['closing_date']) && !empty($request['closing_date']) )
        {
	   try{
	        
	       $opening_date =$request['opening_date'];
	       $closing_date =$request['closing_date'];
	       $bm_id =$request['bm_id'];
	       $order_total_new =0;
	       
	       $data2 = DB::select("select * from balance_managing where  bm_id = '$bm_id'");	   
		   if($data2)
		   {
		       	foreach($data2 as $u2)
		       	{
					$opening_balance = $u2->opening_balance;
		       	}
		   }
		   else
		   {
			   $opening_balance = 0;
		   }
		   
	       $data = DB::select("select * from bookings where  timestamp >= '$opening_date' AND timestamp <= '$closing_date' ");	   
		   if($data)
		   {
		       //return $data;
		       	foreach($data as $u)
		       	{
					$order_total = $u->order_total;
					
					$order_total_new = $order_total_new+$order_total;
		       	}
		       	
		       	$closing = $order_total_new + $opening_balance;
		       	
			   return response()->json(['status'=>'success','closing_balance'=>$closing]);
		   }
		   else
		   {
			   return response()->json(['status'=>'failed','error'=>'Update again.']);
		   }
	    }
	    catch(\Illuminate\Database\QueryException $ex)
	    { 		
            return response()->json(['status'=>'failed','error'=>'SQL Error.']);
	    }
	}
    	else
    	{
    	    return response()->json(['status'=>'failed','error'=>'Incomplete Parameters']);
    	}
    }*/
    
    public function GetClosingBalance (Request $request)
	{ 
        if(isset($request['opening_date']) && !empty($request['opening_date']) AND isset($request['closing_date']) && !empty($request['closing_date']) )
        {
	        try
	        {
	        
	            $opening_date =$request['opening_date'];
	            $closing_date =$request['closing_date'];
	            $bm_id =$request['bm_id'];
	            $order_total_new =0;
	            $justopened = 0;
	       
	            $data2 = DB::select("select * from balance_managing where  bm_id = '$bm_id'");	   
		        if($data2)
		        {
		       	    foreach($data2 as $u2)
		       	    {
					    $opening_balance = $u2->opening_balance;
					    $register_id = $u2->register_id;
					    $justopened = 1;
		       	    }
		        }
		        else
		        {
			        $opening_balance = 0;
		        }
		   
    	        $data = DB::select("select * from bookings where register_id = '$register_id' AND timestamp >= '$opening_date' AND timestamp <= '$closing_date' ");	   
    		    if($data)
    		    {
    	            return $data;
    		       	foreach($data as $u)
    		       	{
    					$order_total = $u->order_total;
    					
    					$order_total_new = $order_total_new + $order_total;
    		       	}
    		       	
    		        $data2 = DB::select("select * from booking_addedhours where register_id = '$register_id' AND add_timestamp >= '$opening_date' AND add_timestamp <= '$closing_date' ");	   
        		    if($data2)
        		    {
        		        //return $data;
        		       	foreach($data2 as $u2)
        		       	{
        					$order_total = $u2->add_order_total;
        				    $order_total_new = $order_total_new + $order_total;
        		        }
        		    }
    		       	
    		       	$closing = $order_total_new + $opening_balance;
    			    return response()->json(['status'=>'success','closing_balance'=>$closing]);
    		    }
    		    else
    		    {
    		        if( $justopened == 1 )
    		        {
    		            return response()->json(['status'=>'success','closing_balance'=>$opening_balance]);
    		        }
    		        else
    		        {
    			        return response()->json(['status'=>'failed','error'=>'Update again.']);
    		        }
    		    }
    	    }
    	    catch(\Illuminate\Database\QueryException $ex)
    	    { 		
                return response()->json(['status'=>'failed','error'=>'SQL Error.']);
    	    }
    	}
    	else
    	{
    	    return response()->json(['status'=>'failed','error'=>'Incomplete Parameters']);
    	}
    }
    
    
    // QR CODE APIS
    public function AddQrCode (Request $request)
    { 
	    if( isset($request['qr_code']) && !empty($request['qr_code']) AND isset($request['qr_id']) && !empty($request['qr_id']) )
		{
    	    $qr_code = $request['qr_code'];
    	    $qr_id   = $request['qr_id'];
    	    
			try 
            { 
    			$inserteed = DB::insert('insert into qr_code (qr_id,qr_code) values (?,?)',[$qr_id, $qr_code]);
    			
                if($inserteed)
                {
                    return response()->json(['status'=>'success','qr_id'=>$qr_id]);
                }
                else 
     			{
     			    return response()->json(['status'=>'failed','error'=>'Sql Error']);
     			}  
    		} 
    		catch(\Illuminate\Database\QueryException $ex)
    		{ 		
    			return response()->json(['status'=>'failed','error'=>'Try Again']);
    		}
    	}
    	else
    	{
    	    return response()->json(['status'=>'failed','error'=>'Incomplete Parameters']);
    	}
    }
    
    public function EditQrStatus (Request $request)
    { 
	    if( isset($request['qr_id']) && !empty($request['qr_id']) )
		{
    	    $qr_id =$request['qr_id'];
    	    $qr_status = 0;
			   
			   
			$users2 = DB::select('select * from qr_code where qr_id = ?', [$qr_id ]);						
			if($users2)
			{
    			try 
    			{ 
    			    $user_new = DB::update('update qr_code SET qr_status = ? where qr_id= ?', [$qr_status,$qr_id]);
    				if ( $user_new)
    				{		
    					return response()->json(['status'=>'success']);
    				}
    				else 
    				{
    					return response()->json(['status'=>'failed','error'=>'Sql Error1']);
    				}
    			} 
    			catch(\Illuminate\Database\QueryException $ex)
    			{ 		
    				return response()->json(['status'=>'failed','error'=>'This account already exists']);
    			}
    		}
    		else 
    		{
    			return response()->json(['status'=>'failed','error'=>'Qr Doesnt exists']);
    		}
    	}
    	else 
    	{
    		return response()->json(['status'=>'failed','error'=>'Incomplete Parameters']);
    	}
		
	}
	
	public function GetQrStatus (Request $request)
	{ 
        if( isset($request['qr_id']) && !empty($request['qr_id']) )
        {
	        try
	        {
	            $qr_id = $request['qr_id'];
	            
	            $data2 = DB::select("select * from qr_code where qr_id = '$qr_id'");	   
		        if($data2)
		        {
		       	    foreach($data2 as $u2)
		       	    {
					    $qr_status = $u2->qr_status;
		       	    }
		        
		            return response()->json(['status'=>'success','qr_status'=>$qr_status]);
    		    }
    		    else
    		    {
    		        return response()->json(['status'=>'failed','error'=>'Qr Doesnt exists.']);
    		    }
	        }
    	    catch(\Illuminate\Database\QueryException $ex)
    	    { 		
                return response()->json(['status'=>'failed','error'=>'SQL Error.']);
    	    }
    	}
    	else
    	{
    	    return response()->json(['status'=>'failed','error'=>'Incomplete Parameters']);
    	}
    }
    
    //VR Location Functions
    public function AddLocations (Request $request)
    { 
	    if( isset($request['location_name']) && !empty($request['location_name']) AND isset($request['location_active']) && !empty($request['location_active']) 
	    AND isset($request['location_pass']) && !empty($request['location_pass'])
	    AND isset($request['location_type']) && !empty($request['location_type']) AND isset($request['address']) && !empty($request['address']))
		{
    	    $location_name = $request['location_name'];
    	    $location_active   = $request['location_active'];
    	    $location_pass = $request['location_pass'];
    	    $location_type   = $request['location_type'];
    	    $address = $request['address'];
    	   
    	    
			try 
            { 
    			$inserteed = DB::insert('insert into KOS_Locations (location_name,location_active,location_pass,location_type,address) values (?,?,?,?,?)',[$location_name, $location_active,$location_pass,$location_type,$address]);
    			
                if($inserteed)
                {
                    return response()->json(['status'=>'success']);
                }
                else 
     			{
     			    return response()->json(['status'=>'failed','error'=>'Sql Error']);
     			}  
    		} 
    		catch(\Illuminate\Database\QueryException $ex)
    		{ 		
    			return response()->json(['status'=>'failed','error'=>'Try Again']);
    		}
    	}
    	else
    	{
    	    return response()->json(['status'=>'failed','error'=>'Incomplete Parameters']);
    	}
    }
    
    public function EditLocations (Request $request)
    { 
	     if( isset($request['location_id']) && !empty($request['location_id']) AND  isset($request['location_name']) && !empty($request['location_name']) AND isset($request['location_active']) && !empty($request['location_active']) 
	    AND isset($request['location_pass']) && !empty($request['location_pass'])
	    AND isset($request['location_type']) && !empty($request['location_type']) AND isset($request['address']) && !empty($request['address']))
		{
    	    $location_id = $request['location_id'];
    	    $location_name = $request['location_name'];
    	    $location_active   = $request['location_active'];
    	    $location_pass = $request['location_pass'];
    	    $location_type   = $request['location_type'];
    	    $address = $request['address'];
			   
			   
			$users2 = DB::select('select * from KOS_Locations where location_id = ?', [$location_id ]);						
			if($users2)
			{
    			try 
    			{ 
    			    $user_new = DB::update('update KOS_Locations SET location_name = ? , location_active =?, location_pass=?, location_type=?, address=?  where location_id= ?', [$location_name,$location_active,$location_pass,$location_type,$address,$location_id]);
    				if ( $user_new)
    				{		
    					return response()->json(['status'=>'success']);
    				}
    				else 
    				{
    					return response()->json(['status'=>'failed','error'=>'Sql Error1']);
    				}
    			} 
    			catch(\Illuminate\Database\QueryException $ex)
    			{ 		
    				return response()->json(['status'=>'failed','error'=>'SQL Error']);
    			}
    		}
    		else 
    		{
    			return response()->json(['status'=>'failed','error'=>'Location Doesnt exists']);
    		}
    	}
    	else 
    	{
    		return response()->json(['status'=>'failed','error'=>'Incomplete Parameters']);
    	}
		
	}
	
	public function GetLocation (Request $request)
	{ 
        try
        {
        
            $data2 = DB::select("select * from KOS_Locations");	   
	        if($data2)
	        {
	       	   
	            return response()->json(['status'=>'success','data'=>$data2]);
		    }
		    else
		    {
		        return response()->json(['status'=>'failed','error'=>'Data Doesnt exists.']);
		    }
        }
	    catch(\Illuminate\Database\QueryException $ex)
	    { 		
            return response()->json(['status'=>'failed','error'=>'SQL Error.']);
	    }
    	
    }
    
    public function DeleteLocation (Request $request)
    { 
	    if(isset($request['location_id']) && !empty($request['location_id']))
		{
		    $location_id = $request['location_id'];
		    
		    try 
			{
			    $deleted = DB::delete ("delete from KOS_Locations where location_id='$location_id'");
			    
	            if($deleted)
                {
                    return response()->json(['status'=>'success']);
                }
                else 
 				{
 				    return response()->json(['status'=>'failed','error'=>'Sql Error']);
 				}  
			} 
			catch(\Illuminate\Database\QueryException $ex)
			{ 		
			    return response()->json(['status'=>'failed','error'=>'try again']);
			}
    	}
    	else
    	{
    	    return response()->json(['status'=>'failed','error'=>'Incomplete Parameters']);
    	}
    }
    
    //VR BATCH FUNCTIONS
    public function AddBatch (Request $request)
    { 
	    if( isset($request['employee_id']) && !empty($request['employee_id']) AND isset($request['location']) && !empty($request['location']) )
		{
    	    $location = $request['location'];
    	    $employee_id = $request['employee_id'];
    	    
    	    $users2 = DB::select('select * from VR_batch where location = ? ORDER BY created_at DESC LIMIT 1 ', [$location ]);						
			if($users2)
			{
			    foreach($users2 as $u2)
		       	    {
					    $name = $u2->name;
					    $batchnumber =  $name +1;
		       	    }
		       	    
        		  try 
                    { 
            			$inserteed = DB::insert('insert into VR_batch (name,location,employee_id) values (?,?,?)',[$batchnumber, $location,$employee_id]);
            			
                        if($inserteed)
                        {
                            return response()->json(['status'=>'success','batch_no'=>$batchnumber]);
                        }
                        else 
             			{
             			    return response()->json(['status'=>'failed','error'=>'Sql Error']);
             			}  
            		} 
            		catch(\Illuminate\Database\QueryException $ex)
            		{ 		
            			return response()->json(['status'=>'failed','error'=>'Try Again']);
            		}
		        
			}
			else 
			{
			    $batchnumber =1;
			    
			    try 
                    { 
            		$inserteed = DB::insert('insert into VR_batch (name,location,employee_id) values (?,?,?)',[$batchnumber, $location,$employee_id]);
            			
                        if($inserteed)
                        {
                            return response()->json(['status'=>'success','batch_no'=>$batchnumber]);
                        }
                        else 
             			{
             			    return response()->json(['status'=>'failed','error'=>'Sql Error']);
             			}  
            		} 
            		catch(\Illuminate\Database\QueryException $ex)
            		{ 		
            			return response()->json(['status'=>'failed','error'=>'Try Again']);
            		}
			}
			
		
    	}
    	else
    	{
    	    return response()->json(['status'=>'failed','error'=>'Incomplete Parameters']);
    	}
    }
    
    public function GetBatchNumber (Request $request)
	{
	    if( isset($request['location']) && !empty($request['location']) )
        {
	        try
	        {
	            $location = $request['location'];
	            
	            $data2 = DB::select("select * from VR_batch where location = '$location' ORDER BY created_at DESC LIMIT 1 ");	   
		        if($data2)
		        {
		            return response()->json(['status'=>'success','data'=>$data2]);
    		    }
    		    else
    		    {
    		        return response()->json(['status'=>'failed','error'=>'Batch No Doesnt exists.']);
    		    }
	        }
    	    catch(\Illuminate\Database\QueryException $ex)
    	    { 		
                return response()->json(['status'=>'failed','error'=>'SQL Error.']);
    	    }
    	}
    	else
    	{
    	    return response()->json(['status'=>'failed','error'=>'Incomplete Parameters']);
    	}
    }
    
    //VR REGISTER FUNCTIONS
    public function Addregisters (Request $request)
    { 
	    if( isset($request['location']) && !empty($request['location']) AND isset($request['name']) && !empty($request['name']) )
		{
    	    $location = $request['location'];
    	    $name = $request['name'];
    	    $status = "close";
    	   
    	   try 
            { 
    			$inserteed = DB::insert('insert into VR_registers (name,location,status) values (?,?,?)',[$name, $location, $status]);
    			
                if($inserteed)
                {
                    return response()->json(['status'=>'success']);
                }
                else 
     			{
     			    return response()->json(['status'=>'failed','error'=>'Sql Error']);
     			}  
    		} 
    		catch(\Illuminate\Database\QueryException $ex)
    		{ 		
    			return response()->json(['status'=>'failed','error'=>'Try Again']);
    		}
			
		
    	}
    	else
    	{
    	    return response()->json(['status'=>'failed','error'=>'Incomplete Parameters']);
    	}
    }
    
    public function ViewRegisters (Request $request)
	{ 
        if( isset($request['location']) && !empty($request['location']) )
        {
	        try
	        {
	            $location = $request['location'];
	            
	            $data2 = DB::select("select * from VR_registers where location = '$location'");	   
		        if($data2)
		        {
		       	    foreach($data2 as $u2)
		       	    {
					    $register_id = $u2->register_id;
					    $data23 = DB::select("select * from balance_managing where register_id = '$register_id' ORDER BY creataed_at DESC LIMIT 1");	   
            		    if($data23)
            		    {
            		        $u2->balance_details = $data23;
                	    }
                		else
                		{
                		    //Do Nothing
                		}
		       	    }
		            return response()->json(['status'=>'success','data'=>$data2]);
    		    }
    		    else
    		    {
    		        return response()->json(['status'=>'failed','error'=>'No Register exists for this Location.']);
    		    }
	        }
    	    catch(\Illuminate\Database\QueryException $ex)
    	    { 		
                return response()->json(['status'=>'failed','error'=>'SQL Error.']);
    	    }
    	}
    	else
    	{
    	    return response()->json(['status'=>'failed','error'=>'Incomplete Parameters']);
    	}
    }
    
    public function UpdateStatusRegister (Request $request)
    { 
	     if( isset($request['register_id']) && !empty($request['register_id']) AND  isset($request['status']) && !empty($request['status']))
		{
    	    $register_id = $request['register_id'];
    	    $status = $request['status'];
    	   
			try 
			{ 
			    $user_new = DB::update('update VR_registers SET status = ?  where register_id= ?', [$status,$register_id]);
				if ( $user_new)
				{		
					return response()->json(['status'=>'success']);
				}
				else 
				{
					return response()->json(['status'=>'failed','error'=>'Sql Error1']);
				}
			} 
			catch(\Illuminate\Database\QueryException $ex)
			{ 		
				return response()->json(['status'=>'failed','error'=>'SQL Error']);
			}
    		
    	}
    	else 
    	{
    		return response()->json(['status'=>'failed','error'=>'Incomplete Parameters']);
    	}
		
	}
	
	public function ViewPhoneRequirement (Request $request)
	{ 
	    
	    $rt =1;
        $data23 = DB::select("select * from phone_requirement where pr_id = '$rt'");	   
        if($data23)
        {
            return response()->json(['status'=>'success','data'=>$data23]);
	    }
	    else
	    {
	        return response()->json(['status'=>'failed','error'=>'Data Doesnt exists.']);
	    }
    }
    
}
