<?php

namespace App\Http\Controllers;

use Illuminate\Foundation\Bus\DispatchesJobs;
use Illuminate\Routing\Controller as BaseController;
use Illuminate\Foundation\Validation\ValidatesRequests;
use Illuminate\Foundation\Auth\Access\AuthorizesRequests;
use Illuminate\http\Request;
use Illuminate\http\Response;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\File;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Facades\Input;
use Hash;


use DB;


class LockerController extends BaseController
{
    use AuthorizesRequests, DispatchesJobs, ValidatesRequests;
	
    public function AddLocker (Request $request)
    { 
		if(isset($request['LocationID']) && !empty($request['LocationID']) AND isset($request['LockerNumber']) && !empty($request['LockerNumber'])) 
			{
				$LocationID=$request['LocationID'];
				$LockerNumber=$request['LockerNumber'];
				$LockerStatus= "E";
				try 
				{ 
					$inserteed = DB::insert('insert into Locker (LocationID,LockerNumber,LockerStatus) values (?,?,?)',[$LocationID,$LockerNumber,$LockerStatus]);											  
					return response()->json(['status'=>'success']);   
				} 
				catch(\Illuminate\Database\QueryException $ex)
				{ 		
					return response()->json(['status'=>'failed','error'=>'Locker Number Exist']);
				}

			}

		else 
			{
				return response()->json(['status'=>'failed','error'=>'Incomplete Parameters']);
			}
      
    }
	
	
	
	
	public function LockerEdit (Request $request)
    { 
				if(isset($request['LockerID']) && !empty($request['LockerID']) AND isset($request['LocationID']) && !empty($request['LocationID']) AND isset($request['LockerNumber']) && !empty($request['LockerNumber'])) 
			{
				$LocationID=$request['LocationID'];
				$LockerNumber=$request['LockerNumber'];
				$LockerID=$request['LockerID'];

				$users = DB::select('select * from Locker where LockerID = ?', [$LockerID]);
				if($users)
				{
					try 
					{ 
						$user_new = DB::update('update Locker SET LocationID = ? , LockerNumber = ? where LockerID = ?', [$LocationID,$LockerNumber,$LockerID]);
						if ( $user_new)                             
						{
							return response()->json(['status'=>'success']);
						}
						else 
						{
							return response()->json(['status'=>'failed','error'=>'Locker Number Exist']);
						}
					
					}
					
					catch(\Illuminate\Database\QueryException $ex)
					{ 		
						return response()->json(['status'=>'failed','error'=>'Locker Number Exist']);
					}
					
									  
					//return response()->json(['status'=>'success','data'=>$users ]);
				}
				else
				{
					return response()->json(['status'=>'failed','error'=>'Wrong Locker Id']);
				}	
					  
				
			
			}

		else 
			{
				return response()->json(['status'=>'failed','error'=>'Incomplete Parameters']);
			}
      
    }

public function LockerView (Request $request)
    {

		if(isset($request['LockerID']) && !empty($request['LockerID'])) 
			{
				$LockerID=$request['LockerID'];
				$DeletedFlag =0;
			$users = DB::select('select * from Locker where DeletedFlag = ? AND LockerID = ?', [$DeletedFlag , $LockerID]);
				if($users)
				{
					return response()->json(['status'=>'success','data'=>$users]);
				}
				else 
				{
					return response()->json(['status'=>'failed','error'=>'No Information Found']);
				}
			
		}
		else 
		{
			
			$DeletedFlag =0;
			$users = DB::select('select * from Locker where DeletedFlag = ? ', [$DeletedFlag ]);
			
				if($users)
				{
					return response()->json(['status'=>'success','data'=>$users]);
				}
				else 
				{
					return response()->json(['status'=>'failed','error'=>'No Information Found']);
				}
			
		}
        
    }

public function LockerByLocation (Request $request)
    {

		if(isset($request['LocationID']) && !empty($request['LocationID'])) 
			{
				$LocationID=$request['LocationID'];
				$DeletedFlag =0;
			$users = DB::select('select * from Locker where DeletedFlag = ? AND LocationID= ?', [$DeletedFlag , $LocationID]);
				if($users)
				{
					return response()->json(['status'=>'success','data'=>$users]);
				}
				else 
				{
					return response()->json(['status'=>'failed','error'=>'No Information Found']);
				}
			
		}
		else 
		{
			
			return response()->json(['status'=>'failed','error'=>'No Information Found']);
			
		}
        
    }

public function LockerBynumber (Request $request)
    {

		if(isset($request['LockerNumber']) && !empty($request['LockerNumber'])) 
			{
				$LockerNumber=$request['LockerNumber'];
				$DeletedFlag =0;
			$users = DB::select('select * from Locker where DeletedFlag = ? AND LockerNumber= ?', [$DeletedFlag , $LockerNumber]);
				if($users)
				{
					return response()->json(['status'=>'success','data'=>$users]);
				}
				else 
				{
					return response()->json(['status'=>'failed','error'=>'No Information Found']);
				}
			
		}
		else 
		{
			
			return response()->json(['status'=>'failed','error'=>'No Information Found']);
			
		}
        
    }
	
	
	public function LockerDelete(Request $request)
    {
		if(isset($request['LockerID']) && !empty($request['LockerID'])) 
			{
				$LockerID=$request['LockerID'];
			
			
			$users = DB::select('select * from Locker where LockerID = ? ', [$LockerID]);
			
				if($users)
				{
					try 
					{ 
						$DeletedFlag  =1;
						$user_new = DB::update('update Locker SET DeletedFlag= ?   where LockerID = ?', [$DeletedFlag,$LockerID]);
						if ( $user_new)
						{
							return response()->json(['status'=>'success']);
						}
						else 
						{
							return response()->json(['status'=>'failed','error'=>'Sql Error']);
						}
					
					}
					
					catch(\Illuminate\Database\QueryException $ex)
					{ 		
						return response()->json(['status'=>'failed','error'=>'Sql Error']);
					}
				}
				else 
				{
					return response()->json(['status'=>'failed','error'=>'Wrong Location Id']);
				}
			
		}
		else 
		{
			return response()->json(['status'=>'failed','error'=>'Incomplete Parameters']);
			
		}
        
    }

}

