<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Controller;
use App\Http\Controllers\TestController;
/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "api" middleware group. Make something great!
|
*/
Route::middleware(['cors'])->group(function () {
    Route::post('EmployeeSigninEmail',[Controller::class,'EmployeeSigninEmail'])->name('login_api');
    Route::post('SyncAddClockout',[TestController::class,'SyncAddClockout'])->name('SyncAddClockout');
   Route::get('/ViewOnClockEmployees',[Controller::class,'ViewOnClockEmployees'])->name('ViewOnClockEmployees');
   Route::get('/ViewClockedInEmployees',[Controller::class,'ViewClockedInEmployees']);
   Route::get('/AdvanceLoanTotal',[Controller::class,'AdvanceLoanTotal']);
   Route::post('/AddPaymentAdvance',[Controller::class,'AddPaymentAdvanceWeb'])->name('AddPaymentAdvance');
   Route::post('/AddClockoutTime',[Controller::class,'AddClockoutTime']);
   Route::post('/AddClockinTime',[Controller::class,'AddClockinTime']);
   Route::get('/ViewAllPositions',[Controller::class,'ViewAllPositions']);
   Route::post('/BreaksClockinTime',[Controller::class,'AddClockinTime']);
   Route::post('/SyncAddBreaks',[TestController::class,'SyncAddBreaks']);
   Route::post('/BackToWork',[Controller::class,'BackToWork']); 
   Route::get('/ViewOnClockWebEmployees',[Controller::class,'ViewOnClockWebEmployees']);
   Route::post('/SendHoursMail',[Controller::class,'SendHoursMail'])->name('SendHoursMail');

});
// Route::get('/adsd',[Controller::class,'ViewOnClockEmployees']);


Route::middleware('auth:sanctum')->get('/user', function (Request $request) {
    return $request->user();
});
