<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">

    <title>Timeclock Admin Panel | Day Details</title>

    <?php echo $__env->make('partials.headerLinks', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <style type="text/css">
        .activeSM
        {
            background-color: white !important; /* #38283c !important;*/
        }
        
        .detailsBtn
        {
            background-color: #224ea6;
            color: white;
            border-color: #224ea6;
        }
        .btn-success 
        {
            width: 100%;
            margin: 20px 0px;
            color: #fff;
            background-color: green;
            border-color: green;
        }
        .btn-success:hover
        {
            color: #fff;
            background-color: green;
            border-color: green;
        }
        .btn-success:focus
        {
            color: #fff;
            background-color: green;
            border-color: green;
        }
        .btn-danger 
        {
            width: 100%;
            color: #fff;
            background-color: #d9534f;
            border-color: #d43f3a;
        }
        .btn-primary 
        {
            width: 100%;
            color: #fff;
            background-color: #224ea6;
            border-color: #224ea6;
        }
        .btn-primary:hover
        {
            color: #fff;
            background-color: #224ea6;
            border-color: #224ea6;
        }
        .btn-primary:focus
        {
            color: #fff;
            background-color: #224ea6;
            border-color: #224ea6;
        }
    </style>
    <script>
        if (!localStorage.login_timeclock_admin)
        {
            window.stop();
            window.location.replace("index.php");
        }
    </script>
</head>
<body>

    <div id="wrapper">
        <?php echo $__env->make('partials.navbar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>


        <div id="page-wrapper" class="gray-bg">
            <div class="row border-bottom">
                <?php echo $__env->make('partials.top-bar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

            </div>
            <div class="row wrapper border-bottom white-bg page-heading">
                <div class="row" style="font-size:24px;margin:20px 0px 0px 40px;">
                    <center>
                        <font style="font-weight:800">Daily Shift Details</font><br>
                        <font id="selectedWeek" style="font-weight:800;color:#224ea6"></font>
                    </center>
                </div>
            </div>

            <div class="wrapper wrapper-content animated fadeInRight ecommerce">
                <div class="row">
                    <div class="col-lg-12">
                        <div class="ibox">
                            <div id="payroll_list" class="ibox-content table-responsive">
                                <!-- Dynamically Appending Data -->
                            </div>
                            <button onclick="goBack()" class="btn btn-primary">Back</button>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Empty List -->
            <button id="swal_btn" type="button" style="display:none"></button>
            <!-- Delete Row -->
            <button id="swal_btn2" type="button" style="display:none"></button>
            <!-- Active/Inactive row -->
            <button id="swal_btn3" type="button" style="display:none"></button>
        </div>
    </div>
    
    <!-- Modal -->
    <div class="modal fade" id="timeEditModal" role="dialog">
        <div class="modal-dialog">
          <!-- Modal content-->
            <div class="modal-content">
                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal">&times;</button>
                    <h4 class="modal-title"> Edit Date/Time</h4>
                </div>
                <div class="modal-body">
                    <form id="edit_time_form">
                        <div class="form-group">
    						<label for="date"><strong><span style="color:red">* </span>Date:</strong></label>
    						<input type="date" class="form-control" id="edit_date" placeholder="Enter date" name="edit_date">
    					</div>	
    					<div class="form-group">
    						<label for="password"><strong><span style="color:red">* </span>Time:</strong></label>
    						<input type="time" class="form-control" id="edit_time" placeholder="Enter time" name="edit_time">
    					</div>	
    					<button class="ladda-button ladda-button-demo btn btn-success" type="submit" data-style="zoom-in">
    		                <span class="ladda-label">Save</span><span class="ladda-spinner"></span>
    		            </button>
                    </form>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-default" style="background-color: #ed5565; color: white" data-dismiss="modal">Cancel</button>
                </div>
            </div>
        </div>
    </div>
    <!-- Modal Close -->

    <?php echo $__env->make('partials.scriptLinks', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>;
    <script src="<?php echo e(asset('js/jquery-3.1.1.min.js')); ?>"></script>
    <script src="<?php echo e(asset('js/bootstrap.min.js')); ?>"></script>
    <script src="<?php echo e(asset('js/jquery.metisMenu.js')); ?>"></script>
    <script src="<?php echo e(asset('js/jquery.slimscroll.min.js')); ?>"></script>
    <script src="<?php echo e(asset('js/dates.js')); ?>"></script>
    <!-- Page-Level Scripts -->
    <script>
        var advance_total;
        var EmployeesObject = JSON.parse(localStorage.EmployeesObject);
        var choosenEmployee = localStorage.choosenEmployee;
        var startDateRange  = localStorage.From_Date;
        var endDateRange    = localStorage.To_Date;
        var perHourPay;
        var TotalHours = 0;
        var edit_tc_id;
        var edit_tcb_id;
        var edit_clockout_id;
        var edit_type;
        var edit_time_previous;
        var edit_time_next;
    
        $(document).ready(function() 
        {
            $('#emp_name').html(localStorage.Employee_Name);
            $('#selectedWeek').html(localStorage.selectedweek);
            
            $("#side1").addClass("activeSM");
            $("#side1 a").css("color","#224ea6");
    
            viewPayrollList();
            
            $("#edit_time_form").validate({
	            rules: 
	            {       
	           		edit_date: {
	                    required: true,
	                },
	                edit_time: {
	                    required: true,
	                },
	            },
	            messages: 
	            {
	            },
	            submitHandler: function(form) 
	            {
	                var l = $( '.ladda-button-demo' ).ladda();
    			    //l.ladda( 'start' );		
    			    
	                var date = $('#edit_date').val();
	                var time = $('#edit_time').val();
	                
	                var tempDate = date.split('-');
                    date = tempDate[1] + "/" + tempDate[2] + "/" + tempDate[0];
	                
	                employeeEditedSuccessfully(date,time);
	            }
	        });
            
            //Empty List
            $('#swal_btn').click(function(){
                swal({
                    title: "No Data",
                    text: "Employee has no Working hours During the Selected Week.",
                    type: "warning",
                    confirmButtonColor: "#DD6B55",
                });
            });
            
            $('#swal_btn2').click(function(){
                swal({
                    title: "No Details",
                    text: "Employee has no Working hours During the Selected Day.",
                    type: "warning",
                    confirmButtonColor: "#DD6B55",
                });
            });
        });
    
        function viewPayrollList()
        {
            var $list = $("#payroll_list");
            $list.empty();
            
            $.each(EmployeesObject, function(index,obj) 
            {
                if( choosenEmployee == obj.employee_id )
                {
                    if( dates.inRange(obj.date,startDateRange,endDateRange) )
                    {
                        printEmployeeDetails($list,obj);
                        
                        printTable($list,obj,index);
                        
                        var id = "table_" + index;
                        var $list2 = $("#"+id);
                        
                        printClockIn($list2,obj);
                        
                        printBreaks($list2,obj);
                        
                        printClockOut($list2,obj);
                        
                        showRemainingDetails(obj,index);
                    }
                }
            });
        }
        
        function printEmployeeDetails($list,object)
        {
            var fullName;
            
            $.each(object.employee_details, function(index,obj)
            {
                fullName = obj.emp_fname + " " + obj.emp_lname;
            });
            
            $list.append('<div style="font-size: 15px;font-weight: 800;margin-left: 8px;">'+
                            '<font>Name : </font><font style="font-weight:800;color:#224ea6">'+fullName+'</font><br>'+
                            '<font>Location : </font> <font style="font-weight:800;color:#224ea6">'+object.location+'</font><br>'+
                            '<font>Position : </font> <font style="font-weight:800;color:#224ea6">'+object.position+'</font><br>'+
                        '</div>');
        }
        
        function printTable($list,object,index)
        {
            $list.append('<table class="footable table table-stripped toggle-arrow-tiny" data-page-size="15">'+
                            '<thead>'+
                                '<tr>'+
                                    '<th>Type</th>'+
                                    '<th>Date</th>'+
                                    '<th>Time</th>'+
                                '</tr>'+
                            '</thead>'+
                            '<tbody id="table_'+index+'">'+
                            '</tbody>'+
                        '</table>'+
                        '<div class="row" style="font-size:15px;margin-left: 5px;">'+
                            '<font style="font-weight:800">Total Time for Today : </font> <font id="total_hours_'+index+'"></font><br>'+
                            '<font style="font-weight:800">Rate per Hour : $</font> <font id="emp_rate_'+index+'"></font><br>'+
                            '<font style="font-weight:800">Total Payroll for Today : $</font> <font id="total_pay_'+index+'"></font><br>'+
                            '<font style="font-weight:800;color:red">Advance: </font> <font id="total_advance_'+index+'" style="color:red"></font><br>'+
                            '<font style="font-weight:800">Confirmed By : </font> <font id="confirm_by_'+index+'"></font><br>'+
                            '<font style="font-weight:800">Confirmed Date : </font> <font id="confirm_date_'+index+'"></font><br>'+
                            '<font style="font-weight:800">Confirmed Time : </font> <font id="confirm_time_'+index+'"></font><br>'+
                            '<font style="font-weight:800">Confirmed Note : </font> <font id="confirm_note_'+index+'"></font><br>'+
                        '</div>'+
                        '<hr style="border-top: 2px solid black">');
        }
        
        function printClockIn($list,object)
        {
            $list.empty();
            
            var tempTime = convertTime(object.time);
            var temp_ID = "clockin_" + object.tc_id + "_" + object.date + "_" + object.time ;
            
            $list.append('<tr style="color:green">'+
                            '<td ><strong>Clock In</strong></td>'+
                            '<td>'+object.date+'</td>'+
                            '<td>'+tempTime+'</td>'+
                            '<td>'+
                                '<div class="btn-group">'+
                                    '<button id="'+temp_ID+'" onclick ="editEmployeeDetails(this.id);" class="btn-primary btn btn-xs">Edit</button>'+
                                '</div>'+
                            '</td>'+
                        '</tr>');
        }
        
        function printBreaks($list,object)
        {
            if( object.breaks )
            {
                $.each(object.breaks, function(index,obj)
                {
                    var tempTime   = convertTime(obj.time);
                    var tempCamelCase = capitalizeFirstLetter(obj.action);
                    var temp_ID_Break = "break_" + obj.tcb_id + "_" + obj.date + "_" + obj.time ;
                    
                    $list.append('<tr style="color:red">'+
                                    '<td ><strong>'+tempCamelCase+'</strong></td>'+
                                    '<td>'+obj.date+'</td>'+
                                    '<td>'+tempTime+'</td>'+
                                    '<td>'+
                                        '<div class="btn-group">'+
                                            //'<button id="'+temp_ID_Break+'" onclick ="editEmployeeDetails(this.id);" class="btn-primary btn btn-xs">Edit</button>'+
                                        '</div>'+
                                    '</td>'+
                                '</tr>');
                                
                    if(obj.back_to_work_date)
                    {
                        var tempTimeBTW = convertTime(obj.back_to_work_time);
                        var temp_ID_BackToWork = "backToWork_" + obj.tcb_id + "_" + obj.back_to_work_date + "_" + obj.back_to_work_time ;
                        
                        $list.append('<tr style="color:green">'+
                                        '<td ><strong>Back to Work</strong></td>'+
                                        '<td>'+obj.back_to_work_date+'</td>'+
                                        '<td>'+tempTimeBTW+'</td>'+
                                        '<td>'+
                                            '<div class="btn-group">'+
                                                //'<button id="'+temp_ID_BackToWork+'" onclick ="editEmployeeDetails(this.id);" class="btn-primary btn btn-xs">Edit</button>'+
                                            '</div>'+
                                        '</td>'+
                                    '</tr>');
                    }
                });
            }
        }
        
        function printClockOut($list,object)
        {
            $.each(object.clockouts, function(index,obj)
            {
                var tempTime = convertTime(obj.time);
                var temp_ID = "clockout_" + obj.clockout_id + "_" + obj.date + "_" + obj.time ;
                
                $list.append('<tr style="color:red">'+
                                '<td ><strong>Clock Out</strong></td>'+
                                '<td>'+obj.date+'</td>'+
                                '<td>'+tempTime+'</td>'+
                                '<td>'+
                                    '<div class="btn-group">'+
                                        //'<button id="'+temp_ID+'" onclick ="editEmployeeDetails(this.id);" class="btn-primary btn btn-xs">Edit</button>'+
                                    '</div>'+
                                '</td>'+
                            '</tr>');
            });
        }
        
        function showRemainingDetails(object,index)
        {
            var hours = calculateHours(object);
            
            var TotalHours = (parseFloat(hours) / 3600).toFixed(2);
            
            var displayTime = secondsToHms(hours);
            
            var total_pay   = ( parseFloat(TotalHours) * parseFloat(object.payroll_perhr)).toFixed(2);
            
            $('#total_hours_'+index).html(displayTime);
            $('#emp_rate_'+index).html(object.payroll_perhr);
            $('#total_pay_'+index).html(total_pay);
            
            calculateAdvance(object,index);
            showConfirmManagerDetails(object,index);
        }
        
        function calculateHours(object)
        {
            var hours;
            
            if( object.clock_out == 0 )
            {
                hours = parseFloat(object.working_hours);
                
                if( object.breaks )
                {
                    var tempStartDate;
                    $.each(object.breaks, function(index,obj)
                    {
                        if( obj.back_to_work_date )
                        {
                            tempStartDate = obj.back_to_work_date + " " + obj.back_to_work_time;
                        }
                        else
                        {
                            tempStartDate = obj.back_to_work_date;
                        }
                    });
                    
                    if( tempStartDate )
                    {
                        var startDate = new Date(tempStartDate);
                        var endDate   = new Date();
                        var seconds = (endDate.getTime() - startDate.getTime()) / 1000;
                        hours = parseFloat(hours) + parseFloat(seconds);
                    }
                    else
                    {
                        hours = parseFloat(hours);
                    }
                }
                else
                {
                    var startDate = new Date(object.clock_in);
                    var endDate   = new Date();
                    var seconds = (endDate.getTime() - startDate.getTime()) / 1000;
                    hours = parseFloat(seconds);
                }
            }
            else
            {
                hours = parseFloat(object.working_hours);
            }
            
            return hours;
        }
        
        function secondsToHms(seconds) 
        {
            seconds = Number(seconds);
            var h = Math.floor(seconds / 3600);
            var m = Math.floor(seconds % 3600 / 60);
            //var s = Math.floor(d % 3600 % 60);
        
            var hDisplay = h > 0 ? h + (h == 1 ? " Hour " : " Hours ") : "";
            var mDisplay = m > 0 ? m + (m == 1 ? " Minute " : " Minutes ") : "";
            //var sDisplay = s > 0 ? s + (s == 1 ? " second" : " seconds") : "";
            return hDisplay + mDisplay;// + sDisplay; 
        }
        
        function showConfirmManagerDetails(object,index)
        {
            if( object.confirm_timestamp )
            {
                var confirm_temp = object.confirm_timestamp.split(" ");
                var tempTimeConfirm = convertTime(confirm_temp[1]);
                
                $('#confirm_by_'+index).html(object.confirm_employee_fullname);
                $('#confirm_date_'+index).html(confirm_temp[0]);
                $('#confirm_time_'+index).html(tempTimeConfirm);
                $('#confirm_note_'+index).html(object.note);
            }
        }
    
        function convertTime(time)
        {
            var temp = time.split(':');
            var hours = temp[0];
            
            if( hours < 12)
            {
                hours = hours + ":" + temp[1] + " AM";
            }
            else if( hours == 12)
            {
                hours = hours + ":" + temp[1] + " PM";
            }
            else if( hours > 12)
            {
                hours = hours - 12 ;
                if( hours < 10 )
                {
                    hours = "0" + hours + ":" + temp[1] + " PM";
                }
                else
                {
                    hours = hours + ":" + temp[1] + " PM";
                }
            }
            return hours;
        }
        
        function calculateAdvance(object,index)
        {
            var tempDate = object.clock_in.split(" ");
            var date = tempDate[0];
            
            $.ajax({
                url: "/Panama/timeclock/apis/api/AdvanceLoanTotal",
                type: "GET",
                data: { "date1" : date , "date2" : date , "employee_id" : localStorage.choosenEmployee },
                success: function(data)
                {   
                    if ( data.status == "success")
                    {
                        advance_total = data.emp_advance.toFixed(2);
                        $('#total_advance_'+index).html('$' + advance_total);
                    }
                    else if ( data.status == "failed")
                    {
                        advance_total = 0;
                        advance_total = advance_total.toFixed(2);
                        $('#total_advance_'+index).html('$' + advance_total);
                    }
                },
                error: function(data)
                {
                }           
            });        
        }
        
        function capitalizeFirstLetter(string) 
        {
            return string.charAt(0).toUpperCase() + string.slice(1);
        }
        
        function goBack()
        {
            window.location.href = "payroll_detail.php";
        }
        
        function editEmployeeDetails(id)
        {
            var temp = id.split('_');
            var tempDate = temp[2].split('/');
            var date = tempDate[2] + "-" + tempDate[0] + "-" + tempDate[1];
            var time = temp[3];
            $('#edit_date').val(date);
            $('#edit_time').val(time);
            
            edit_type   = temp[0];
            edit_tc_id  = temp[1];
            //edit_tcb_id = ;
            //edit_clockout_id = ; 
            
            
            $('#timeEditModal').modal('show');
        }
        
        function employeeEditedSuccessfully(date,time)
        {
            $('#timeEditModal').modal('hide');
            
            //alert( edit_tc_id + " " + date + " " + time + " " + edit_type + " " + localStorage.Employee_Name );
            
            edit_time_previous = 0;
                edit_time_next = 0;
            
            $.each(EmployeesObject, function(index,obj) 
            {
                if( edit_tc_id == obj.tc_id )
                {
                    if(obj.breaks)
                    {
                        $.each(obj.breaks, function(index2,obj2)
                        {
                            if( index2 == 0)
                            {
                                edit_time_next = obj2.date + " " + obj2.time;
                            }
                        });
                    }
                    else
                    {
                        if(obj.clock_out == 0)
                        {
                            //Do Nothing
                        }
                        else
                        {
                            edit_time_next = obj.clock_out;
                        }
                    }
                }
            });
            
            var clockinTime = date + " " + time;
            
            var temp = dates.compare(clockinTime,edit_time_next);
            
            alert(clockinTime + " " + temp + " " + edit_time_next);
            
            /*var formData = new FormData();
            formData.append("id", edit_tc_id);
            formData.append("date", date);
            formData.append("time", time);
            formData.append("type", edit_type);
            formData.append("edit_employee",localStorage.Employee_Name);
            
            $.ajax
            ({
                type:'POST',
                url: "/Panama/timeclock/apis/api/EditEmployeeTime",  
                data: formData,
                contentType: false,
                cache: false,
                processData:false,
                success: function(data)
                {
                    if (data.status == "success")
    	            {
    	                l.ladda( 'stop' );
    	            }
    	            else
                	{	
                	    l.ladda( 'stop' );
                		alert('error');
					}
                },
                error: function(data) 
                {	
                    l.ladda( 'stop' );
                	alert('error');
                }  
            });*/
        }
    </script>
</body>
</html><?php /**PATH E:\laragon\www\Time-Clock\resources\views/admin/employee_payroll_details.blade.php ENDPATH**/ ?>