<!DOCTYPE html>
<html>

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">

    <title>Timeclock Admin Panel | Employee Selection</title>

    <?php echo $__env->make('partials.headerLinks', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <style type="text/css">
        .activeSM {
            background-color: white !important;
            /* #38283c !important;*/
        }

        #loading-img {
            background: url(img/load.gif) center center no-repeat;
            height: 100%;
            z-index: 20;
        }

        .overlay {
            background: #e9e9e9;
            display: none;
            position: absolute;
            top: -100px;
            right: -100px;
            bottom: 0;
            left: 0;
            height: 900px;
            opacity: 0.5;
            z-index: 999;
        }
    </style>
    <script>
        const loginUrl = "<?php echo e(route('login')); ?>";

        if (!localStorage.login_timeclock_admin) {
            window.stop();
            window.location.replace(loginUrl);
        }
    </script>
</head>

<body>
    <div id="wrapper">

        <?php echo $__env->make('partials.navbar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        <div id="page-wrapper" class="gray-bg">
            <div class="row border-bottom">
                <?php echo $__env->make('partials.top-bar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

            </div>
            <div class="row wrapper border-bottom white-bg page-heading">
                <div class="col-lg-10">
                    <h2><strong>Payroll Report</strong></h2>
                </div>
                <div class="col-lg-2">
                </div>
            </div>

            <div class="wrapper wrapper-content animated fadeInRight ecommerce">
                <div class="container">
                    <div class="row">
                        <div class="col-sm-10">
                            <div class="row" style="padding-right:20px">
                                <div class="col-sm-6">
                                    <div>
                                        <button id="lastweek" onclick="calculateLastWeek(7)"
                                            style="background-color: #224ea6;border-color: #224ea6;color: white; width: 100%; height: 40px; font-size: 20px; margin-bottom : 20px"
                                            class="btn btn-primary m-t-n-xs">
                                            Last Payroll
                                        </button>
                                    </div>
                                </div>
                                <div class="col-sm-6">
                                    <div>
                                        <button id="thisweek" onclick="calculateCurrentWeek()"
                                            style="background-color: #224ea6;border-color: #224ea6;color: white; width: 100%; height: 40px; font-size: 20px; margin-bottom : 20px"
                                            class="btn btn-primary m-t-n-xs">
                                            This Week
                                        </button>
                                    </div>
                                </div>
                            </div>
                            <div class="row" style="padding-right:20px;margin-top:20px">
                                <div class="col-sm-6">
                                    <div class="form-group">
                                        <label>From</label>
                                        <input type="date" id="from_date" name="from_date" class="form-control" />
                                    </div>
                                </div>
                                <div class="col-sm-6">
                                    <div class="form-group">
                                        <label>To</label>
                                        <input type="date" id="to_date" name="to_date" class="form-control" />
                                    </div>
                                </div>
                            </div>
                            <div class="row" style="padding-right:20px;margin-top:20px">
                                <div class="col-sm-6">
                                    <div class="form-group">
                                        <label>Choose Employee</span></label>
                                        <select class="form-control" id="employee_list" name="employee_list"
                                            required="">
                                            <!-- Dynamically Appending All Employees -->
                                        </select>
                                    </div>
                                </div>
                                <div class="col-sm-6">
                                    <div class="form-group">
                                        <label>Choose Location</label>
                                        <select class="form-control" id="location_list" name="location_list"
                                            required="">
                                            <!-- Dynamically Appending All Locations -->
                                        </select>
                                    </div>
                                </div>
                            </div>
                            <div class="row" style="padding-right:20px;margin-top:20px">
                                <div class="col-sm-12">
                                    <div>
                                        <button onclick="search()"
                                            style="background-color: #224ea6;border-color: #224ea6;color: white; width: 100%; height: 40px; font-size: 20px; margin-bottom : 20px"
                                            class="ladda-button ladda-button-demo btn btn-primary m-t-n-xs"
                                            type="submit" data-style="zoom-in">
                                            <span class="ladda-label">Search</span><span class="ladda-spinner"></span>
                                        </button>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-sm-2"></div>
                    </div>
                </div>
            </div>

            <!-- Empty List -->
            <button id="swal_btn" type="button" style="display:none">
                <!-- Delete Row -->
                <button id="swal_btn2" type="button" style="display:none">
                    <!-- Active/Inactive row -->
                    <button id="swal_btn3" type="button" style="display:none">
        </div>
    </div>

    <!-- Image Loader -->
    <div class="overlay">
        <div id="loading-img"></div>
    </div>
    <!-- Image Loader END -->

    <?php echo $__env->make('partials.scriptLinks', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <!-- Page-Level Scripts -->
    <script>
        const AllEmpUrl = "<?php echo e(route('allempolyees')); ?>";
        const AllLocUrl = "<?php echo e(route('alllocations')); ?>";
        const ViewOnClockEmployees = "<?php echo e(route('ViewOnClockEmployees')); ?>";
        var l = $('.ladda-button-demo').ladda();

        $(document).ready(function() {
            $(".overlay").show();

            var tempDate = getCurrentdate();
            $('#from_date').val(tempDate);
            $('#to_date').val(tempDate);

            $('#emp_name').html(localStorage.Employee_Name);

            getAllEmployees();
            getAllLocations();

            $("#side1").addClass("activeSM");
            $("#side1 a").css("color", "#224ea6");
        });

        function calculateLastWeek(week) {
            l.ladda('start');
            var beforeOneWeek = new Date(new Date().getTime() - 60 * 60 * 24 * week * 1000);
            day = beforeOneWeek.getDay();

            diffToMonday = beforeOneWeek.getDate() - day + (day === 0 ? -6 : 1);
            lastMonday = new Date(beforeOneWeek.setDate(diffToMonday));
            //lastSunday = new Date(beforeOneWeek.setDate(diffToMonday + 6));


            lastSunday = new Date(lastMonday);
            lastSunday.setDate(lastSunday.getDate() + 6);

            var dd = lastMonday.getDate();
            var mm = lastMonday.getMonth() + 1;
            var yyyy = lastMonday.getFullYear();

            if (dd < 10) {
                dd = '0' + dd;
            }

            if (mm < 10) {
                mm = '0' + mm;
            }
            var lastweekMonday = mm + '/' + dd + '/' + yyyy;

            var dd = lastSunday.getDate();
            var mm = lastSunday.getMonth() + 1;
            var yyyy = lastSunday.getFullYear();

            if (dd < 10) {
                dd = '0' + dd;
            }

            if (mm < 10) {
                mm = '0' + mm;
            }
            var lastweekSunday = mm + '/' + dd + '/' + yyyy;

            localStorage.selectedweek = lastweekMonday + "-" + lastweekSunday;
            apiCall(lastweekMonday, lastweekSunday, "All", "All");
        }

        function calculateCurrentWeek() {
            l.ladda('start');

            var weekday = new Array(7);
            weekday[0] = "Sunday";
            weekday[1] = "Monday";
            weekday[2] = "Tuesday";
            weekday[3] = "Wednesday";
            weekday[4] = "Thursday";
            weekday[5] = "Friday";
            weekday[6] = "Saturday";

            var Monday, Sunday;

            var date = new Date();
            var temp = date.getDay();
            var DayofWeek = weekday[temp];

            if (temp == 1) {
                Monday = exactDate(date, 0);
                Sunday = exactDate(date, 6);
            } else if (temp == 0) {
                Monday = exactDate(date, -6);
                Sunday = exactDate(date, 0);
            } else {
                Monday = exactDate(date, temp - ((temp * 2) - 1));
                Sunday = exactDate(date, 7 - temp);
            }

            localStorage.selectedweek = Monday + "-" + Sunday;
            apiCall(Monday, Sunday, "All", "All");
        }

        function exactDate(date, day) {
            var targetDate = new Date(date);
            targetDate.setDate(targetDate.getDate() + day);

            // So you can see the date we have created
            var dd = targetDate.getDate();
            var mm = targetDate.getMonth() + 1; // 0 is January, so we must add 1
            var yyyy = targetDate.getFullYear();

            if (dd < 10) {
                dd = '0' + dd;
            }

            if (mm < 10) {
                mm = '0' + mm;
            }

            var dateString = mm + "/" + dd + "/" + yyyy;

            // So you can see the output
            return dateString;
        }

        function getAllEmployees() {
            var $list = $("#employee_list");
            $list.empty();

            $.ajax({
                url: AllEmpUrl,
                type: "GET",
                success: function(data) {
                    console.log(data);
                    // var dat = jQuery.parseJSON(data);
                    // var dat = data;
                    var Employees = [];

                    if (data.status == "success") {
                        $.each(data.Data, function(index, obj) {
                            Employees.push(obj.emp_username);

                            if (index == 0) {
                                $list.append('<option value="All" selected>All</option>');
                                $list.append('<option value="' + obj.emp_username + '">' + obj
                                    .emp_fname + ' ' + obj.emp_lname + '</option>');
                            } else {
                                $list.append('<option value="' + obj.emp_username + '">' + obj
                                    .emp_fname + ' ' + obj.emp_lname + '</option>');
                            }
                        });

                        localStorage.AllEmployees = JSON.stringify(Employees);
                    } else {
                        $(".overlay").hide();
                        // alert("error");
                    }
                },
                error: function(data) {
                    $(".overlay").hide();
                    // alert("error");
                }
            });
        }

        function getAllLocations() {
            var $list = $("#location_list");
            $list.empty();

            $.ajax({
                url: AllLocUrl,
                type: "GET",
                success: function(data) {
                    var dat = data;

                    if (dat.status == "success") {
                        $.each(dat.Data, function(index, obj) {
                            if (index == 0) {
                                $list.append('<option value="All" selected>All</option>');
                                $list.append('<option value="' + obj.location_name + '">' + obj
                                    .location_name + '</option>');
                            } else {
                                $list.append('<option value="' + obj.location_name + '">' + obj
                                    .location_name + '</option>');
                            }
                        });
                    } else {
                        // alert("error");
                    }
                    $(".overlay").hide();
                },
                error: function(data) {
                    $(".overlay").hide();
                    // alert("error");
                }
            });
        }

        function getCurrentdate() {
            var date = new Date();
            var day = date.getDate();
            var month = date.getMonth() + 1;
            var year = date.getFullYear();
            var hours = date.getHours();
            var mins = date.getMinutes();

            if (month < 10) {
                month = "0" + month;
            }

            if (day < 10) {
                day = "0" + day;
            }

            date = year + "-" + month + "-" + day;

            return date;
        }

        function search() {
            l.ladda('start');

            var from_date = $('#from_date').val();
            from_date = changeDateFormat(from_date);
            var to_date = $('#to_date').val();
            to_date = changeDateFormat(to_date);
            var employee_list = $('#employee_list').val();
            var location_list = $('#location_list').val();

            localStorage.selectedweek = from_date + "-" + to_date;
            apiCall(from_date, to_date, location_list, employee_list);
        }

        function changeDateFormat(date) {
            var temp = date.split('-');
            var newdate = temp[1] + '/' + temp[2] + '/' + temp[0];
            return newdate;
        }

        function apiCall(date1, date2, location, employee) {
            $.ajax({
                url: ViewOnClockEmployees,
                type: "GET",
                data: {
                    "location": location,
                    "employee_id": employee
                },
                success: function(data) {
                    console.log(data);
                    if (data.status == "success") {
                        l.ladda('stop');
                        localStorage.EmployeesObject = JSON.stringify(data.data);
                        localStorage.From_Date = date1;
                        localStorage.To_Date = date2;
                        localStorage.Selected_Loc = location;
                        window.location.href = "http://127.0.0.1:9000/manage-admin/payroll_detail";
                    } else if (data.status == "failed") {
                        l.ladda('stop');
                        // alert(data.error);
                    }
                },
                error: function(data) {
                    console.log(data);
                    l.ladda('stop');
                    // alert("error");
                }
            });
        }
    </script>
</body>

</html>
<?php /**PATH E:\laragon\www\Time-Clock\resources\views/admin/payroll.blade.php ENDPATH**/ ?>