<?php

use Illuminate\Http\Request;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| is assigned the "api" middleware group. Enjoy building your API!
|
*/

Route::get('/user', function (Request $request) {
    return $request->user();
})->middleware('auth:api');

Route::post('test','Controller@test');

//Employee Routes
Route::post('AdminSignIn','Controller@AdminSignIn');
Route::post('EmployeeSignin','Controller@EmployeeSignin');
Route::post('EmployeeSignup','Controller@EmployeeSignup');
Route::post('EditEmployee','Controller@EditEmployee');
Route::get('ViewAllEmployees','Controller@ViewAllEmployees');
Route::get('ViewEmployee','Controller@ViewEmployee');
Route::get('DeleteEmployee','Controller@DeleteEmployee');

//VR Station Routes
Route::post('AddVRStation','Controller@AddVRStation');
Route::post('EditVRStation','Controller@EditVRStation');
Route::get('ViewAllVRStations','Controller@ViewAllVRStations');
Route::get('ViewVRStation','Controller@ViewVRStation');
Route::get('DeleteVRStation','Controller@DeleteVRStation');

//Tax Routes
Route::post('AddTax','Controller@AddTax');
Route::post('EditTax','Controller@EditTax');
Route::get('ViewTax','Controller@ViewTax');
Route::get('ViewSingleTax','Controller@ViewSingleTax');
Route::get('DeleteTax','Controller@DeleteTax');

//Rate per Hour Routes
Route::post('AddRateHour','Controller@AddRateHour');
Route::post('EditRateHour','Controller@EditRateHour');
Route::get('ViewAllRateHours','Controller@ViewAllRateHours');
Route::get('ViewRatePerHour','Controller@ViewRatePerHour');
Route::get('DeleteRateHour','Controller@DeleteRateHour');

//Agreemend Routes
Route::post('AddAgreement','Controller@AddAgreement');
Route::post('EditAgreement','Controller@EditAgreement');
Route::get('ViewAgreement','Controller@ViewAgreement');
Route::get('ViewSingleAgreement','Controller@ViewSingleAgreement');
Route::get('DeleteAgreement','Controller@DeleteAgreement');

//Location Routes
Route::post('AddLocations','Controller@AddLocations');
Route::post('EditLocations','Controller@EditLocations');
Route::get('GetLocation','Controller@GetLocation');
Route::get('DeleteLocation','Controller@DeleteLocation');

//CUSTOMER Routes
Route::post('CustomerSignup','Controller@CustomerSignup');
Route::post('EditCustomerProfile','Controller@EditCustomerProfile');
Route::post('UpdateCustomerStatus','Controller@UpdateCustomerStatus');
Route::post('CustomerPhoneEdit','Controller@CustomerPhoneEdit');
Route::post('CustomerPwdChange','Controller@CustomerPwdChange');
Route::post('CustomerSignin','Controller@CustomerSignin');
Route::get('CustomerSearch','Controller@CustomerSearch');


Route::get('VerifyEmail','Controller@VerifyEmail');

//Balance Routes
Route::post('AddBalance','Controller@AddBalance');
Route::post('CloseBalance','Controller@CloseBalance');
Route::post('GetClosingBalance','Controller@GetClosingBalance');

Route::get('DeleteChild','Controller@DeleteChild');

//Bookings ROutes
Route::post('AddBooking','Controller@AddBooking');
Route::post('MultipleBookings','Controller@MultipleBookings');
Route::post('UpdateBooking','Controller@UpdateBooking');
Route::post('AddAddedHours','Controller@AddAddedHours');

//Qr Routes
Route::post('AddQrCode','Controller@AddQrCode');
Route::post('EditQrStatus','Controller@EditQrStatus');
Route::post('GetQrStatus','Controller@GetQrStatus');

Route::post('AddBatch','Controller@AddBatch');
Route::get('GetBatchNumber','Controller@GetBatchNumber');
Route::post('Addregisters','Controller@Addregisters');
Route::get('ViewRegisters','Controller@ViewRegisters');
Route::get('ViewPhoneRequirement','Controller@ViewPhoneRequirement');
Route::post('UpdateStatusRegister','Controller@UpdateStatusRegister');