<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">

    <title>Dry Clean Locker | Employees </title>

    <link href="{{ asset ('css/bootstrap.min.css') }}" rel="stylesheet">
    <link href="{{ asset ('font-awesome/css/font-awesome.css') }}" rel="stylesheet">

    <!-- FooTable -->
    <link href="{{ asset ('css/plugins/footable/footable.core.css') }}" rel="stylesheet">

    <!-- Sweet Alert -->
    <link href="{{ asset ('css/sweetalert.css') }}" rel="stylesheet">

    <link href="{{ asset ('css/animate.css') }}" rel="stylesheet">
    <link href="{{ asset ('css/style.css') }}" rel="stylesheet">
    <style type="text/css">
        .activeSM
        {
            background-color: white !important; /* #38283c !important;*/
        }
        .fa
        { 
            transform: scale(1.5,1.5);
        }
    </style>
</head>
<body>
    <div id="wrapper">

        <!-- Side Navbar -->
        @include('navbar_static_side') 

        <div id="page-wrapper" class="gray-bg">
            <div class="row border-bottom">
                <!-- Top Navbar -->
                @include('navbar_static_top') 
            </div>
            <div class="row wrapper border-bottom white-bg page-heading">
                <div class="col-lg-10">
                    <h2><strong>Employees</strong></h2>
                    <a href="{{ url('add_employee') }}">
                        <button style="color: #566b8a" type="button" class="btn btn-default btn-sm">
                            <span class="glyphicon glyphicon-plus"></span> Add an Employee
                        </button>
                    </a>
                </div>
                <div class="col-lg-2">

                </div>
            </div>

            <div class="wrapper wrapper-content animated fadeInRight ecommerce">
                <div class="row">    
                    <div class="col-md-6 col-sm-8 col-xs-12">
                        <div class="input-group">
                            <div class="input-group-btn search-panel">
                                <button style="background-color: #566b8a;color: white;" type="button" class="btn btn-default dropdown-toggle" data-toggle="dropdown">
                                    <span id="search_concept">Filter by</span><span class="caret"></span>
                                </button>
                                <ul class="dropdown-menu" role="menu">
                                  <li><a href="#Admin">Admin</a></li>
                                  <li><a href="#Employee">Employee</a></li>
                                  <li><a href="#Driver">Driver</a></li>
                                  <li class="divider"></li>
                                  <li><a href="#All">All</a></li>
                                </ul>
                            </div>
                            <input type="hidden" name="search_param" value="all" id="search_param">         
                            <input type="text" class="form-control" id="search_box" name="search_box" placeholder="Search term..." disabled="">
                            <span class="input-group-btn">
                                <button onclick="searchFilter()" class="btn btn-default" type="button"><span class="glyphicon glyphicon-search"></span></button>
                            </span>
                        </div>
                    </div>
                </div>

                <div class="row">
                    <div class="col-lg-12">
                        <div class="ibox">
                            <div class="ibox-content table-responsive">
                                <table class="table table-striped">
                                    <thead>
                                        <tr>
                                            <th>#</th>
                                            <th>First Name</th>
                                            <th>Last Name</th>
                                            <th>Email Address</th>
                                            <th>Country</th>
                                            <th>Mobile#</th>
                                            <th>Sex</th>
                                            <th style="color: #566b8a;font-weight: bolder;" onclick="sortColumnBase();">Role</th>
                                            <th>Action</th>
                                        </tr>
                                    </thead>
                                    <tbody id="employee_list">
                                       <!-- Dynamically appending Employees List -->
                                    </tbody>
                                    <tfoot>
                                        <tr>
                                            <td colspan="6">
                                                <ul class="pagination pull-right"></ul>
                                            </td>
                                        </tr>
                                    </tfoot>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Empty List -->
            <button id="swal_btn" type="button" style="display:none"></button>
            <!-- Delete Row -->
            <button id="swal_btn2" type="button" style="display:none"></button>

            <!-- Footer -->
            @include('footer')

        </div>
    </div>

    <!-- Modal -->
    <div class="modal fade" id="deleteModal" role="dialog">
        <div class="modal-dialog">
          <!-- Modal content-->
            <div class="modal-content">
                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal">&times;</button>
                    <h4 class="modal-title">Delete Employee</h4>
                </div>
                <div class="modal-body">
                    <p>Are you sure you want to delete the Employee?</p>
                </div>
                <div class="modal-footer">
                     <button type="button" class="btn btn-default" style="background-color: #1ab394; color: white" onclick="deleteEmployee()">Yes</button>
                    <button type="button" class="btn btn-default" style="background-color: #ed5565; color: white" data-dismiss="modal">No</button>
                </div>
            </div>
        </div>
    </div>
    <!-- Modal Close -->



    <!-- Mainly scripts -->
    <script src="{{ asset ('js/jquery-3.1.1.min.js') }}"></script>
    <script src="{{ asset ('js/bootstrap.min.js') }}"></script>
    <script src="{{ asset ('js/plugins/metisMenu/jquery.metisMenu.js') }}"></script>
    <script src="{{ asset ('js/plugins/slimscroll/jquery.slimscroll.min.js') }}"></script>

    <!-- Custom and plugin javascript -->
    <script src="{{ asset ('js/inspinia.js') }}"></script>
    <script src="{{ asset ('js/plugins/pace/pace.min.js') }}"></script>

    <!-- Sweet alert -->
    <script src="{{ asset ('js/plugins/sweetalert/sweetalert.min.js') }}"></script>

    <!-- FooTable -->
    <script src="{{ asset ('js/plugins/footable/footable.all.min.js') }}"></script>

    <!-- Page-Level Scripts -->
    <script>
        var delete_employee;
        var employees_data;

        $(document).ready(function() 
        {
            $("#side6").addClass("activeSM");
            $("#side6 a").css("color","#224ea6");

            $('.search-panel .dropdown-menu').find('a').click(function(e) {
                e.preventDefault();
                var param = $(this).attr("href").replace("#","");
                var concept = $(this).text();
                $('.search-panel span#search_concept').text(concept);
                $('.input-group #search_param').val(param);
                $('#search_box').val(param);
            });

            viewEmployees();

            //Empty List
            $('#swal_btn').click(function(){
                swal({
                     title: "List is Empty!",
                    text: "Please add Employees.",
                    type: "warning",
                    confirmButtonColor: "#DD6B55",
                    closeOnConfirm: false
                }, function () {
                    window.location.assign("{{url('add_employee')}}");
                });
            });

            //Delete Row
            $('#swal_btn2').click(function(){
                swal({
                    title: "Employee Deleted!",
                    text: "",
                    type: "success",
                    confirmButtonColor: "#DD6B55",
                });
            });
        });

        function viewEmployees()
        {
            var $list = $("#employee_list");
            $list.empty();
            $.ajax({
                url: "/DCL/api/PersonViewAll",
                type: "POST",
                success: function(data)
                {   
                    var count = 1;
                    employees_data = data;
                    
                    if ( data.status == "success")
                    {
                        $.each(data.data, function(index,obj) 
                        {
                            $list.append('<tr>'+
                                            '<td><strong>'+count+'</strong></td>'+
                                            '<td>'+obj.FirstName+'</td>'+
                                            '<td>'+obj.LastName+'</td>'+
                                            '<td>'+obj.EmailAddress+'</td>'+
                                            '<td>'+obj.CountryID+'</td>'+
                                            '<td>'+obj.MobileNumber+'</td>'+
                                            '<td>'+obj.Sex+'</td>'+
                                            '<td>'+obj.Type+'</td>'+
                                            '<td>'+
                                                '<div class="btn-group">'+
                                                    '<button id="'+obj.EmailAddress+'" onclick ="saveEmployee(this.id);" class="btn-white btn btn-xs"><img alt="image" width="20" src="img/edit_icon.png" /></button>'+

                                                    '<button id="'+obj.EmailAddress+'" onclick ="deleteEmployeeModal(this.id);" class="btn-white btn btn-xs"><img alt="image" width="20" src="img/delete_icon.png" /></button>'+

                                                    '<button id="'+obj.EmailAddress+'" onclick ="changePassword(this.id);" class="btn-white btn btn-xs"><img alt="image" width="20" src="img/reset_password.png" /></button>'+
                                                '</div>'+
                                            '</td>'+
                                        '</tr>');
                            count++;
                        });
                    }
                    else
                    {
                        swal_btn.click();
                    }
                },
                error: function(data)
                {
                }           
            });        
        }

        function deleteEmployeeModal(id)
        {
            $('#deleteModal').modal('show');
            delete_employee = id;
        }


        function deleteEmployee()
        {
            $('#deleteModal').modal('hide');

            var emp_id = delete_employee;
            $.ajax({            
                url: "/DCL/api/PersonDelete",
                type: "POST",
                data: {"EmailAddress": emp_id},
                success: function(data)
                {
                    if(data.status == "success")
                    {
                        swal_btn2.click();
                        viewEmployees();
                    }
                    else if (data.status == "failed")
                    {
                        alert("failed");
                    }
                },
                error: function(data) 
                {
                }           
            });
        }

        function saveEmployee(id)
        {
            var emp_id = id;
            localStorage.setItem("emp_id",emp_id);
            window.location.href = "{{url('edit_employee')}}";        
        }

        function searchFilter()
        {
            var search_option = $('#search_concept').html();

            if( search_option != "Filter by")
            {
                var $list = $("#employee_list");
                $list.empty();

                var count = 1;

                $.each(employees_data.data, function(index,obj) 
                {
                    if(search_option == "All")
                    {
                        $list.append('<tr>'+
                                        '<td><strong>'+count+'</strong></td>'+
                                        '<td>'+obj.FirstName+'</td>'+
                                        '<td>'+obj.LastName+'</td>'+
                                        '<td>'+obj.EmailAddress+'</td>'+
                                        '<td>'+obj.CountryID+'</td>'+
                                        '<td>'+obj.MobileNumber+'</td>'+
                                        '<td>'+obj.Sex+'</td>'+
                                        '<td>'+obj.Type+'</td>'+
                                        '<td>'+
                                            '<div class="btn-group">'+
                                                '<button id="'+obj.EmailAddress+'" onclick ="saveEmployee(this.id);" class="btn-white btn btn-xs"><img alt="image" width="20" src="img/edit_icon.png" /></button>'+

                                                '<button id="'+obj.EmailAddress+'" onclick ="deleteEmployeeModal(this.id);" class="btn-white btn btn-xs"><img alt="image" width="20" src="img/delete_icon.png" /></button>'+

                                                '<button id="'+obj.EmailAddress+'" onclick ="changePassword(this.id);" class="btn-white btn btn-xs"><img alt="image" width="20" src="img/reset_password.png" /></button>'+
                                            '</div>'+
                                        '</td>'+
                                    '</tr>');
                        count++;
                    }
                    else if( search_option == obj.Type)
                    {
                        $list.append('<tr>'+
                                        '<td><strong>'+count+'</strong></td>'+
                                        '<td>'+obj.FirstName+'</td>'+
                                        '<td>'+obj.LastName+'</td>'+
                                        '<td>'+obj.EmailAddress+'</td>'+
                                        '<td>'+obj.CountryID+'</td>'+
                                        '<td>'+obj.MobileNumber+'</td>'+
                                        '<td>'+obj.Sex+'</td>'+
                                        '<td style="color: #566b8a;font-weight: bolder;">'+obj.Type+'</td>'+
                                        '<td>'+
                                            '<div class="btn-group">'+
                                                '<button id="'+obj.EmailAddress+'" onclick ="saveEmployee(this.id);" class="btn-white btn btn-xs"><img alt="image" width="20" src="img/edit_icon.png" /></button>'+

                                                '<button id="'+obj.EmailAddress+'" onclick ="deleteEmployeeModal(this.id);" class="btn-white btn btn-xs"><img alt="image" width="20" src="img/delete_icon.png" /></button>'+

                                                '<button id="'+obj.EmailAddress+'" onclick ="changePassword(this.id);" class="btn-white btn btn-xs"><img alt="image" width="20" src="img/reset_password.png" /></button>'+
                                            '</div>'+
                                        '</td>'+
                                    '</tr>');
                        count++;
                    }
                });
                if( count == 1)
                {
                    $list.append('<tr><td colspan="5"><h2>No record found.</h2></td></tr>');
                }
            }
        }

        function sortColumnBase()
        {
            var role_count = employees_data.data;
            let roleCount = [...new Set(role_count.map(item => item.Type))];

            var $list = $("#employee_list");
            $list.empty();

            var count = 1;
            var color;

            for( var i=0 ; i < roleCount.length ; i++ )
            {
                $.each(employees_data.data, function(index,obj) 
                {
                    if( roleCount[i] == obj.Type)
                    {
                        if(roleCount[i] == "Admin")
                            color = "#3c763d";
                        else if(roleCount[i] == "Employee")
                            color = "#f8ac59";
                        else if(roleCount[i] == "Driver")
                            color = "#566b8a";

                        $list.append('<tr>'+
                                        '<td><strong>'+count+'</strong></td>'+
                                        '<td>'+obj.FirstName+'</td>'+
                                        '<td>'+obj.LastName+'</td>'+
                                        '<td>'+obj.EmailAddress+'</td>'+
                                        '<td>'+obj.CountryID+'</td>'+
                                        '<td>'+obj.MobileNumber+'</td>'+
                                        '<td>'+obj.Sex+'</td>'+
                                        '<td style="color: '+color+';font-weight: bolder;">'+obj.Type+'</td>'+
                                        '<td>'+
                                            '<div class="btn-group">'+
                                                '<button id="'+obj.EmailAddress+'" onclick ="saveEmployee(this.id);" class="btn-white btn btn-xs"><img alt="image" width="20" src="img/edit_icon.png" /></button>'+

                                                '<button id="'+obj.EmailAddress+'" onclick ="deleteEmployeeModal(this.id);" class="btn-white btn btn-xs"><img alt="image" width="20" src="img/delete_icon.png" /></button>'+

                                                '<button id="'+obj.EmailAddress+'" onclick ="changePassword(this.id);" class="btn-white btn btn-xs"><img alt="image" width="20" src="img/reset_password.png" /></button>'+
                                            '</div>'+
                                        '</td>'+
                                    '</tr>');
                        count++;
                    }
                });
            }
        }
    </script>
</body>
</html>
