<!DOCTYPE html>
<html>
<head>
    <title>Dry Clean Locker | Add a Location </title>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">

    <link href="{{ asset ('css/bootstrap.min.css') }}" rel="stylesheet">
    <link href="{{ asset ('font-awesome/css/font-awesome.css') }}" rel="stylesheet">

    <!-- FooTable -->
    <link href="{{ asset ('css/plugins/footable/footable.core.css') }}" rel="stylesheet">

    <!-- Sweet Alert -->
    <link href="{{ asset ('css/sweetalert.css') }}" rel="stylesheet">

    <!-- Ladda style -->
    <link href="{{ asset ('css/ladda-themeless.min.css')}}" rel="stylesheet">

    <link href="{{ asset ('css/animate.css') }}" rel="stylesheet">
    <link href="{{ asset ('css/style.css') }}" rel="stylesheet">
    <style type="text/css">
        .activeSM
        {
            background-color: white !important; /* #38283c !important;*/
        }
    </style>
</head>

<body>
    <div id="wrapper">
        @include('navbar_static_side')
        
        <div id="page-wrapper" class="gray-bg">
            <div class="row border-bottom">
                @include('navbar_static_top')
            </div>

            <div class="row wrapper border-bottom white-bg page-heading">
                <div class="col-lg-10">
                    <h2><Strong>Add a Location</Strong></h2>
                    <ol class="breadcrumb">
                        <li>
                            <a href="{{ url('view_location')}}">Locations</a>
                        </li>
                        <li class="active">
                            <strong>Add a Location</strong>
                        </li>
                    </ol>
                </div>
                <div class="col-lg-2">

                </div>
            </div>

            <div class="wrapper wrapper-content animated fadeInRight">
                <div class="row">
                    <div class="col-lg-8">
                        <div class="ibox ">
                            <div class="ibox-content">
                                <form id="add_location_form">
                                    <div class="form-group">
                                        <label>Shortcode</label>
                                        <input type="text" id="shortcode" name="shortcode" placeholder="Enter Shortcode" class="form-control" required>
                                    </div>
                                   
                                    <div class="form-group">
                                        <label>Description</label>
                                        <input type="text" id="description" name="description" placeholder="Enter Description" class="form-control" required>
                                    </div>

                                     <div class="form-group">
                                        <label>Address Line 1</label>
                                        <input type="text" id="add1" name="add1" placeholder="Enter Address Line 1" class="form-control" required>
                                    </div>
                                   
                                   <div class="form-group">
                                        <label>Address Line 2</label>
                                        <input type="text" id="add2" name="add2" placeholder="Enter Address Line 2" class="form-control" required>
                                    </div>

                                    <div class="form-group">
                                        <label>City</label>
                                        <input type="text" id="city" name="city" placeholder="Enter City" class="form-control" required>
                                    </div>

                                    <div class="form-group">
                                        <label>Country</label>
                                        <select class="form-control" id="country" name="country" required="">
                                        </select>
                                    </div>

                                    <div class="form-group">
                                        <label>Postcode</label>
                                        <input type="number" id="postcode" name="postcode" onkeypress="return event.charCode >= 48 && event.charCode <= 57" placeholder="Enter Postcode" class="form-control" required>
                                    </div>

                                    <div class="form-group">
                                        <label>Access Notes</label>
                                        <input type="text" id="acc_notes" name="acc_notes" placeholder="Enter Access Notes" class="form-control" required="">
                                    </div>    
                                   
                                    <div>
                                        <button style="background-color: #566b8a;color: white;" class="ladda-button ladda-button-demo btn btn-sm btn-primary m-t-n-xs" type="submit" data-style="zoom-in">
                                                <span class="ladda-label">Submit</span><span class="ladda-spinner"></span>
                                        </button>
                                        <!-- Successfully Added Location -->
                                        <button id="swal_btn" type="button" style="display:none"></button>
                                        <!-- Location not  Added -->
                                        <button id="swal_btn2" type="button" style="display:none"></button>
                                    </div>
                                </form>
                                <a href="{{url('view_location')}}">
                                    <button style="background-color: #5cb85c;color: white;margin-left: 70px;margin-top: -50px;" class="btn btn-sm btn-primary m-t-n-xs" data-style="zoom-in">Cancel</button>
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            @include('footer')
        </div>
    </div>



    <!-- Mainly scripts -->
    <script src="js/jquery-3.1.1.min.js"></script>
    <script src="js/bootstrap.min.js"></script>
    <script src="js/plugins/metisMenu/jquery.metisMenu.js"></script>
    <script src="js/plugins/slimscroll/jquery.slimscroll.min.js"></script>

    <!-- Custom and plugin javascript -->
    <script src="js/inspinia.js"></script>
    <script src="js/plugins/pace/pace.min.js"></script>

    <script src="js/plugins/jquery-ui/jquery-ui.min.js"></script>

    <!-- Sweet alert -->
    <script src="js/plugins/sweetalert/sweetalert.min.js"></script>

    <!-- Jquery Validate -->
    <script src="js/plugins/validate/jquery.validate.min.js"></script>

    <!-- Ladda -->
    <script src="js/plugins/ladda/spin.min.js"></script>
    <script src="js/plugins/ladda/ladda.min.js"></script>
    <script src="js/plugins/ladda/ladda.jquery.min.js"></script>

    <script>
    var errorMessage;
    $(document).ready(function()
    {
        $("#side2").addClass("activeSM");
        $("#side2 a").css("color","#224ea6");

        viewCountries();
        
       $("#add_location_form").validate({
            rules: 
            {
                shortcode: {
                    required: true
                },
                description: {
                    required: true,
                },
                add1: {
                    required: true,
                },
                add2: {
                    required: true,
                },
                city: {
                    required: true,
                },
                postcode: {
                    required: true,
                    number: true
                },
                acc_notes: {
                    required: true,
                }
            },
            messages: 
            {
            },
            submitHandler: function(form) 
            {
                var l = $( '.ladda-button-demo' ).ladda();
                l.ladda( 'start' );
                var swal_btn = document.getElementById("swal_btn");

                var shortcode = $('#shortcode').val();
                var description = $('#description').val();
                var add1 = $('#add1').val();
                var add2 = $('#add2').val();
                var city = $('#city').val();
                var country = $('#country').val();
                var postcode = $('#postcode').val();
                var acc_notes = $('#acc_notes').val();

                if( country == "select")
                {
                    alert('Please select a Country');
                    l.ladda('stop');
                }
                else
                {
                    var formData = new FormData();
                    formData.append("Shortcode", shortcode);
                    formData.append("Description", description);
                    formData.append("AddressLine1", add1);
                    formData.append("AddressLine2", add2);
                    formData.append("City", city);
                    formData.append("CountryID", country);
                    formData.append("Postcode", postcode);
                    formData.append("AccessNotes", acc_notes);
                                        
                    $.ajax
                    ({
                        type:'POST',
                        url:"/DCL/api/AddLocation",
                        data: formData,
                        contentType: false,
                        cache: false,
                        processData:false,
                        success: function(data)
                        {
                            if( data.status == "success" )
                            {
                                l.ladda('stop');
                                swal_btn.click();
                            }
                            else if( data.status == "failed" )
                            {
                                l.ladda('stop');
                                errorMessage = data.error;
                                swal_btn2.click();
                            }
                        },
                        error: function(data) 
                        {
                            alert("error");
                        }           
                    });      
                }          
                return false; // extra insurance preventing the default form action
            }
        });

        $('#swal_btn').click(function(){
            swal({
                title: "Location added successfully!",
                text: "",
                type: "success",
                confirmButtonColor: "#003399",
                closeOnConfirm: false
            }, function () {
                window.location.assign("{{ url('view_location')}}");
            });
        });

        $('#swal_btn2').click(function(){
            swal({
                 title: "Operation Unsuccessfull!",
                text: errorMessage,
                type: "warning",
                confirmButtonColor: "#DD6B55",
            });
        });
    });

    function viewCountries()
    {
        var $list = $("#country");
        $list.empty();
        $.ajax({
            url: "/DCL/api/CountryView",
            type: "POST",
            success: function(data)
            {   
                if ( data.status == "success")
                {
                    $list.append('<option value="select" selected="">Choose a Country</option>');

                    $.each(data.data, function(index,obj) 
                    {                       
                        $list.append('<option value="'+obj.Name+'">'+obj.Name+'</option>');
                    });
                }
                else
                {
                    swal_btn.click();
                }
            },
            error: function(data)
            {
            }           
        });        
    }

</script>

</body>
</html>
