<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">

    <title>Anahita Joon | Customers </title>

    <link href="{{ asset ('css/bootstrap.min.css') }}" rel="stylesheet">
    <link href="{{ asset ('font-awesome/css/font-awesome.css') }}" rel="stylesheet">

    <!-- FooTable -->
    <link href="{{ asset ('css/plugins/footable/footable.core.css') }}" rel="stylesheet">

    <!-- Sweet Alert -->
    <link href="{{ asset ('css/sweetalert.css') }}" rel="stylesheet">

    <link href="{{ asset ('css/animate.css') }}" rel="stylesheet">
    <link href="{{ asset ('css/style.css') }}" rel="stylesheet">
    <style type="text/css">
        .activeSM
        {
            background-color: white !important; /* #38283c !important;*/
        }
        .fa
        { 
            transform: scale(1.5,1.5);
        }
    </style>
<script>
    if (!localStorage.Session)
    {
        window.stop();
        window.location.replace("login");
    }
    </script>
</head>
<body>
    <div id="wrapper">

        <!-- Side Navbar -->
        @include('navbar_static_side') 

        <div id="page-wrapper" class="gray-bg">
            <div class="row border-bottom">
                <!-- Top Navbar -->
                @include('navbar_static_top') 
            </div>
            <div class="row wrapper border-bottom white-bg page-heading">
                <div class="col-lg-10">
                    <h2><strong>Customers</strong></h2>
                    <a href="{{ url('add_customer') }}">
                        <button style="color: #566b8a" type="button" class="btn btn-default btn-sm">
                            <span class="glyphicon glyphicon-plus"></span> Add a Customer
                        </button>
                    </a>
                </div>
                <div class="col-lg-2">

                </div>
            </div>

            <div class="wrapper wrapper-content animated fadeInRight ecommerce">

                <div class="row">
                    <div class="col-lg-12">
                        <div class="ibox">
                            <div class="ibox-content table-responsive">
                                <table class="table table-striped">
                                    <thead>
                                        <tr>
                                            <th>#</th>
                                            <th>Palette</th>
                                            <th>Email Address</th>
                                            <th>Name</th>
					    <th>Season</th>
                                            <th>Phone</th>
                                            <th>Country</th>                                            
                                            <th>Action</th>
                                        </tr>
                                    </thead>
                                    <tbody id="customer_list">
                                       <!-- Dynamically appending Employees List -->
                                    </tbody>
                                    <tfoot>
                                        <tr>
                                            <td colspan="6">
                                                <ul class="pagination pull-right"></ul>
                                            </td>
                                        </tr>
                                    </tfoot>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Empty List -->
            <button id="swal_btn" type="button" style="display:none"></button>
            <!-- Delete Row -->
            <button id="swal_btn2" type="button" style="display:none"></button>
            <!-- Change row -->
            <button id="swal_btn3" type="button" style="display:none"></button>
<!-- Change row -->
            <button id="swal_btn7" type="button" style="display:none"></button>

            <!-- Footer -->
            @include('footer')

        </div>
    </div>

    <!-- Modal -->
    <div class="modal fade" id="deleteModal" role="dialog">
        <div class="modal-dialog">
          <!-- Modal content-->
            <div class="modal-content">
                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal">&times;</button>
                    <h4 class="modal-title">Delete Customer</h4>
                </div>
                <div class="modal-body">
                    <p>Are you sure you want to delete the Customer?</p>
                </div>
                <div class="modal-footer">
                     <button type="button" class="btn btn-default" style="background-color: #1ab394; color: white" onclick="deleteCustomer()">Yes</button>
                    <button type="button" class="btn btn-default" style="background-color: #ed5565; color: white" data-dismiss="modal">No</button>
                </div>
            </div>
        </div>
    </div>
    <!-- Modal Close -->
	
	
	<!-- Modal Outfit -->
    <div class="modal fade" id="OutfitModal" role="dialog">
        <div class="modal-dialog">
          <!-- Modal content-->
            <div class="modal-content">
                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal">&times;</button>
                    <h4 class="modal-title">Customer Outfits</h4>
                </div>
                <div class="modal-body" style="overflow-x: overlay; height: 600px;">
					<div class="row" id="outie">
					//dynamically appending images
					</div>
					
					
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-default" style="background-color: #ed5565; color: white" data-dismiss="modal">CLOSE</button>
                </div>
            </div>
        </div>
    </div>
    <!-- Modal Outfit Close -->
	
	<!-- Modal -->
    <div class="modal fade" id="PaletteModal" role="dialog">
        <div class="modal-dialog">
          <!-- Modal content-->
            <div class="modal-content">
                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal">&times;</button>
                    <h4 class="modal-title">Change Pic</h4>
                </div>
                <div class="modal-body">
					<div class="form-group">
						<label>Upload Picture</label>
						<input type="file" id="photoChange" name="photoChange" class="form-control" required>
					</div>                     
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-default" style="background-color: #1ab394; color: white" onclick="updatePic()">Yes</button>
                    <button type="button" class="btn btn-default" style="background-color: #ed5565; color: white" data-dismiss="modal">No</button>
                </div>
            </div>
        </div>
    </div>
    <!-- Modal Close -->
	



    <!-- Mainly scripts -->
    <script src="{{ asset ('js/jquery-3.1.1.min.js') }}"></script>
    <script src="{{ asset ('js/bootstrap.min.js') }}"></script>
    <script src="{{ asset ('js/plugins/metisMenu/jquery.metisMenu.js') }}"></script>
    <script src="{{ asset ('js/plugins/slimscroll/jquery.slimscroll.min.js') }}"></script>

    <!-- Custom and plugin javascript -->
    <script src="{{ asset ('js/inspinia.js') }}"></script>
    <script src="{{ asset ('js/plugins/pace/pace.min.js') }}"></script>

    <!-- Sweet alert -->
    <script src="{{ asset ('js/plugins/sweetalert/sweetalert.min.js') }}"></script>

    <!-- FooTable -->
    <script src="{{ asset ('js/plugins/footable/footable.all.min.js') }}"></script>

    <!-- Page-Level Scripts -->
    <script>
        var delete_customer;
        var customer_data;
	var change_pic;


        $(document).ready(function() 
        {
            $("#side7").addClass("activeSM");
            $("#side7 a").css("color","#224ea6");

            $('.search-panel .dropdown-menu').find('a').click(function(e) {
                e.preventDefault();
                var param = $(this).attr("href").replace("#","");
                var concept = $(this).text();
                $('.search-panel span#search_concept').text(concept);
                $('.input-group #search_param').val(param);
            });

            viewCustomer();

            //Empty List
            $('#swal_btn').click(function(){
                swal({
                     title: "List is Empty!",
                    text: "Please add Customer.",
                    type: "warning",
                    confirmButtonColor: "#DD6B55",
                    closeOnConfirm: false
                }, function () {
                    window.location.assign("{{url('add_customer')}}");
                });
            });

//Empty List
            $('#swal_btn7').click(function(){
                swal({
                     title: "List is Empty!",
                    text: "Customer has not added any outfits yet.",
                    type: "warning",
                    confirmButtonColor: "#DD6B55",
                    closeOnConfirm: false
                }, function () {
                    window.location.assign("{{url('view_customer')}}");
                });
            });

            //Delete Row
            $('#swal_btn2').click(function(){
                swal({
                    title: "Customer Deleted!",
                    text: "",
                    type: "success",
                    confirmButtonColor: "#DD6B55",
                });
            });


			
			//Change Pic
            $('#swal_btn3').click(function(){
                swal({
                    title: "Pic Changed!",
                    text: "",
                    type: "success",
                    confirmButtonColor: "#DD6B55",
                });
            });
        });

        function viewCustomer()
        {
            var $list = $("#customer_list");
            $list.empty();
            $.ajax({
                url: "/joon/api/CustomerViewAll",
                type: "POST",
                
                success: function(data)
                {   
                    var count = 1;
                    customer_data = data;

                    if ( data.status == "success")
                    {
                        $.each(data.data, function(index,obj) 
                        {
                                $list.append('<tr>'+
                                                '<td><strong>'+count+'</strong></td>'+
                                                '<td><label id="'+obj.email+'" onclick ="PalettePicModal(this.id);" style="position: fixed;margin-left: 135px;margin-top: 2px;"><i class="fa fa-camera" style="font-size:10px;color:#000"></i></label><img width="150" height="150" src="/joon/public/'+obj.palette_image+'"/></td>'+
                                                '<td>'+obj.email+'</td>'+
                                                '<td>'+obj.name+'</td>'+
                                                '<td>'+obj.season+'</td>'+
                                                '<td>'+obj.phone+'</td>'+
                                                '<td>'+obj.country+'</td>'+
                                                '<td>'+
                                                    '<div class="btn-group">'+
                                                        '<button id="'+obj.email+'" onclick ="saveCustomer(this.id);" class="btn-white btn btn-xs"><img alt="image" width="20" src="img/edit_icon.png" /></button>'+

                                                        '<button id="'+obj.email+'" onclick ="deleteCustomerModal(this.id);" class="btn-white btn btn-xs"><img alt="image" width="20" src="img/delete_icon.png" /></button>'+

                                                        '<button id="'+obj.email+'" onclick ="ViewOutfits(this.id);" class="btn-white btn btn-xs"><img alt="image" width="20" src="img/view_icon.png" /></button>'+
                                                    '</div>'+
                                                '</td>'+
                                            '</tr>');
                                count++;
                            
                        });
                    }
                    else
                    {
                        swal_btn.click();
                    }
                },
                error: function(data)
                {
                }           
            });        
        }

        function deleteCustomerModal(id)
        {
            $('#deleteModal').modal('show');
            delete_customer = id;
        }
		
		function PalettePicModal(id)
        {
            $('#PaletteModal').modal('show');
            change_pic = id;
        }	

	function ViewOutfits(id)
        {
            var $list = $("#outie");
            $list.empty();
            $.ajax({
                url: "/joon/api/OutfitView",
                type: "POST",
                data: { "customer_email" : id},                
                success: function(data)
                {   
                    if ( data.status == "success")
                    {
                        $.each(data.data, function(index,obj) 
                        {
                                $list.append('<div class="col-md-4">'+
						'<div class="thumbnail">'+
					           '<img src="http://anahitajoonstyleapp.com/joon/public/'+obj.image+'" alt="Lights" style="width: 150px;height: 200px;">'+
						 '</div>'+
					     '</div>');                            
                        });
                    }
                    else
                    {
                        swal_btn7.click();
                    }
                    $('#OutfitModal').modal('show');
                },
                error: function(data)
                {
                }           
            });        
        }			
		
		function updatePic()
        {			
			var photo= document.getElementById('photoChange').files[0];  

			var formData = new FormData();
			formData.append("customer_email", change_pic);
			formData.append("photo", photo);

            var customer_email = change_pic;
            $.ajax({            
                url: "/joon/api/AddPalette ",
                type: "POST",
                data: formData,
				contentType: false,
				cache: false,
				processData:false,
                success: function(data)
                {
					 $('#PaletteModal').modal('hide');
                   // var data = jQuery.parseJSON(result);
                    if(data.status == "success")
                    {
                        swal_btn3.click();
                        viewCustomer();
                    }
                    else if (data.status == "failed")
                    {
                        alert("failed");
                    }
                },
                error: function(data) 
                {
                }           
            });
        }


        function deleteCustomer()
        {
            $('#deleteModal').modal('hide');

            var customer_email = delete_customer;
            $.ajax({            
                url: "/joon/api/DelCustomer",
                type: "POST",
                data: {"email": customer_email},
                success: function(data)
                {
                   // var data = jQuery.parseJSON(result);
                    if(data.status == "success")
                    {
                        swal_btn2.click();
                        viewCustomer();
                    }
                    else if (data.status == "failed")
                    {
                        alert("failed");
                    }
                },
                error: function(data) 
                {
                }           
            });
        }

        function saveCustomer(id)
        {
            var customer_id = id;
            localStorage.setItem("customer_id",customer_id);
            window.location.href = "{{ url('edit_customer')}}";
        }

    </script>
</body>
</html>
