<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">

    <title>Maktabti| Books</title>

    <link href="{{ asset ('css/bootstrap.min.css') }}" rel="stylesheet">
    <link href="{{ asset ('font-awesome/css/font-awesome.css') }}" rel="stylesheet">

    <!-- FooTable -->
    <link href="{{ asset ('css/plugins/footable/footable.core.css') }}" rel="stylesheet">

    <!-- Sweet Alert -->
    <link href="{{ asset ('css/sweetalert.css') }}" rel="stylesheet">

    <!-- Ladda style -->
    <link href="{{ asset ('css/ladda-themeless.min.css')}}" rel="stylesheet">

    <link href="{{ asset ('css/animate.css') }}" rel="stylesheet">
    <link href="{{ asset ('css/style.css') }}" rel="stylesheet">
    
    <style type="text/css">
        .activeSM
        {
            background-color: white !important; /* #38283c !important;*/
        }
        .container 
        {
          margin-top: 15px;
        }
        .tab-group
        {
           position: relative;
           vertical-align: middle;
           zoom: 1; /* Fix for IE7 */
           *display: inline; /* Fix for IE7 */
        }
        
        .tab-group > li
        {
            background-color: #eeeeee;
            border-radius: 4px;
            position: relative;
            float: left;
        }
        .nav > li.active 
        {
            border-left: 4px solid #566b8a;
            background: #566b8a;
        }
        .tab-group > li.active > a, 
        .tab-group > li.active > a:hover, 
        .tab-group > li.active > a:focus
        {
            background-color: #566b8a;
            color: #fff;
        }
        .tab-group > li > a 
        {
            color: #333;
            border-radius: 0;
            text-align: center;
        }
        .tab-group > li > a:hover 
        {
            border-radius: 4px;
        }
        
        .tab-group li + li 
        {
            margin-left: -1px;
        }
        
        .tab-group > li:not(:first-child):not(:last-child),
        .tab-group > li:not(:first-child):not(:last-child) > a:hover 
        {
          border-radius: 0;
        }
        .tab-group > li:first-child,
        .tab-group > li:first-child > a:hover 
        {
            margin-left: 0;
        }
        .tab-group > li:first-child:not(:last-child),
        .tab-group > li:first-child:not(:last-child) > a:hover 
        {
          border-top-right-radius: 0;
          border-bottom-right-radius: 0;
        }
        .tab-group > li:last-child:not(:first-child),
        .tab-group > li:last-child:not(:first-child) > a:hover 
        {
          border-top-left-radius: 0;
          border-bottom-left-radius: 0;
        }
    </style>


<script>
    if (!localStorage.Session)
    {
        window.stop();
        window.location.replace("login");
    }
    </script>

</head>
<body>
    <div id="wrapper">
	<!-- Side Navbar -->
	@include('navbar_static_side') 

        <div id="page-wrapper" class="gray-bg">
          <div class="row border-bottom">
		<!-- Top Navbar -->
                @include('navbar_static_top') 
          </div>	  
          
          <div class="row wrapper border-bottom white-bg page-heading">
              <!-- English Div -->
              <div id="view_books_title_eng" class="col-lg-10" style="display:none">
                  <h2><strong>Books</strong></h2>
                  <a href="{{url('add_book')}}">
                      <button type="button" class="btn btn-default btn-sm">
                          <span class="glyphicon glyphicon-plus"></span> Add a Book
                      </button>
                  </a>
              </div>
              
              <!-- Arabic Div -->
              <div id="view_books_title_arabic" class="col-lg-10" style="display:none">
                  <h2><strong>كتب</strong></h2>
                  <a href="{{url('add_book')}}">
                      <button type="button" class="btn btn-default btn-sm">
                          <span class="glyphicon glyphicon-plus"></span> أضف كتاب
                      </button>
                  </a>
              </div>
              
              <div class="col-lg-2">

              </div>
          </div>

        <div class="wrapper wrapper-content animated fadeInRight ecommerce">

              

                <div class="row" id="styles_list">
                	
                </div>
            </div> 

            <!-- Empty List -->
            <button id="swal_btn" type="button" style="display:none"></button>
            <!-- Delete Row -->
            <button id="swal_btn2" type="button" style="display:none"></button>
             <!-- Assign -->
            <button id="swal_btn3" type="button" style="display:none"></button>
            <!-- Empty List -->
            <button id="swal_btn_copy" type="button" style="display:none"></button>
            <!-- Delete Row -->
            <button id="swal_btn2_copy" type="button" style="display:none"></button>
             <!-- Assign -->
            <button id="swal_btn3_copy" type="button" style="display:none"></button>

            <!-- Footer -->
            @include('footer')

        </div>
    </div>

    <!-- Modal View Palette Details -->
    <div class="modal fade" id="palettePicDetailsModal" role="dialog">
        <div class="modal-dialog">
          <!-- Modal content-->
            <div class="modal-content">
                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal">&times;</button>
                    <h4 class="modal-title">Palette Details</h4>
                </div>
                <div class="modal-body">  
                	<div class="form-group">
                       <img id="palette_image_detail" src="" width="50">
                    </div>              
					<div class="form-group">
                   		<label>Category</label>									
						<p id="category_name_detail"></p>
                    </div>
                   
                    <div class="form-group">
                        <label>Description</label>
                        <p id="description_detail"></p>
                    </div>                           
                    <div>
                        <button style="background-color: #566b8a;color: white;" onclick="showAssign()" class="ladda-button ladda-button-demo btn btn-sm btn-primary m-t-n-xs" type="submit" data-style="zoom-in">
                             <span class="ladda-label">Assign to a Customer</span><span class="ladda-spinner"></span>
                        </button>
                    </div>

                    <div id="assignToCustomer" style="display: none">
	                    <div class="form-group">
	                   		<label>Customer List</label>									
							<select class="form-control" id="customer_name" name="customer_name" required="">
								<!-- Appending all customers Dynamically -->
							</select>
	                    </div>
	                    <button type="button" class="btn btn-default" onclick="assigning()" style="background-color: green; color: white" >Assign</button>
	                    <button type="button" class="btn btn-default" onclick="hideAssign()" style="background-color: darkorange; color: white">Hide</button>
	                </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-default" style="background-color: #ed5565; color: white" data-dismiss="modal">Cancel</button>
                </div>
            </div>
        </div>
    </div>
    <!-- Modal Close -->

    <!-- Modal Delete Palette -->
    <div class="modal fade" id="palettePicDeleteModal" role="dialog">
        <div class="modal-dialog">
          <!-- Modal content-->
            <div class="modal-content">
                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal">&times;</button>
                    <h4 class="modal-title">
					<font id="view_book_del_modal_eng_title" style="display:none">Delete Book</font>
                    <font id="view_book_del_modal_arb_title" style="display:none">حذف الكتاب</font>
					</h4>
                </div>
                <div class="modal-body">
				<p id="view_book_del_modal_eng" style="display:none">Are you sure you want to delete this Book?</p>
                    <p id="view_book_del_modal_arb" style="display:none">هل أنت متأكد من أنك تريد حذف هذا الكتاب؟</p>
					
                    
                </div>
                <div class="modal-footer">
                     <button type="button" class="btn btn-default" style="background-color: #1ab394; color: white" onclick="deletePalette()">
					 <font id="view_book_del_modal_eng_yes" style="display:none">Yes</font>
                     	<font id="view_book_del_modal_arb_yes" style="display:none">نعم فعلا</font>
					 </button>
                    <button type="button" class="btn btn-default" style="background-color: #ed5565; color: white" data-dismiss="modal">
					<font id="view_book_del_modal_eng_no" style="display:none">NO</font>
                     	<font id="view_book_del_modal_arb_no" style="display:none">لا</font>
					</button>
                </div>
            </div>
        </div>
    </div>
    <!-- Modal Close -->

    <!-- Modal Edit Palette -->
    <div class="modal fade" id="BookSaleModal" role="dialog">
        <div class="modal-dialog">
          <!-- Modal content-->
            <div class="modal-content">
                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal">&times;</button>
                    <h4 class="modal-title">
					<font id="view_book_sale_modal_eng_title" style="display:none">Sale Book</font>
                    <font id="view_book_sale_modal_arb_title" style="display:none">بيع الكتاب</font>
					</h4>
                </div>
                <div class="modal-body">  
                	<div class="form-group">
                       <img id="palette_image" src="" width="50">
                    </div>      
						<div class="form-group">
                            <label>
							<font id="viewqu_sale_modal_eng_form" style="display:none">Number of Books Available</font>
							<font id="viewqu_sale_modal_arb_form" style="display:none">عدد الكتب المتاحة</font>
							</label>
                            <input type="text" id="book_qu" name="book_qu" placeholder="" class="form-control" readonly> 
						</div> 					
                    <form id="edit_palette_form">
						
                        <div class="form-group">
                            <label>
							<font id="add_book_sale_modal_eng_form" style="display:none">Number of Books Sold</font>
							<font id="add_book_sale_modal_arb_form" style="display:none">عدد الكتب المباعة</font>
							</label>
                            <input type="text" id="quantity" name="quantity" placeholder="" class="form-control" required> 
						</div>                           
                        <div>
                           <button type="button" class="ladda-button ladda-button-demo2 btn btn-default" style="background-color: #1ab394; color: white" onclick="AddOrderStore()">
                           <span class="ladda-label">
						   <font id="add_book_sale_modal_eng_yes" style="display:none">Yes</font>
                     	<font id="add_book_sale_modal_arb_yes" style="display:none">نعم فعلا</font>
						   </button>
						   </span><span class="ladda-spinner"></span>
                   
                        </div>
                    </form>

                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-default" style="background-color: #ed5565; color: white" data-dismiss="modal">
					<font id="view_book_sale_modal_eng_cancel" style="display:none">Cancel</font>
                     	<font id="view_sale_del_modal_arb_cancel" style="display:none">إلغاء</font>
					</button>
                </div>
            </div>
        </div>
    </div>
    <!-- Modal Close -->



    <!-- Mainly scripts -->
    <script src="{{ asset ('js/jquery-3.1.1.min.js') }}"></script>
    <script src="{{ asset ('js/bootstrap.min.js') }}"></script>
    <script src="{{ asset ('js/plugins/metisMenu/jquery.metisMenu.js') }}"></script>
    <script src="{{ asset ('js/plugins/slimscroll/jquery.slimscroll.min.js') }}"></script>

    <!-- Custom and plugin javascript -->
    <script src="{{ asset ('js/inspinia.js') }}"></script>
    <script src="{{ asset ('js/plugins/pace/pace.min.js') }}"></script>

    <!-- Sweet alert -->
    <script src="{{ asset ('js/plugins/sweetalert/sweetalert.min.js') }}"></script>

    <!-- FooTable -->
    <script src="{{ asset ('js/plugins/footable/footable.all.min.js') }}"></script>

    <!-- Jquery Validate -->
    <script src="js/plugins/validate/jquery.validate.min.js"></script>

    <!-- Ladda -->
    <script src="js/plugins/ladda/spin.min.js"></script>
    <script src="js/plugins/ladda/ladda.min.js"></script>
    <script src="js/plugins/ladda/ladda.jquery.min.js"></script>

    <!-- Page-Level Scripts -->
    <script>   
        var palette_delete_id;
        var palette_edit_id;
        var palette_details_assign;
        var book_id;
        var book_qu;

        $(document).ready(function() 
        {
            $("#side1").addClass("activeSM");
            $("#side1 a").css("color","#224ea6");

            viewStyles();

            $(".TAB").click(function()
            {
                var status = this.id;

                if( status == "All" )
                {
                  $('.show_all_tab').css("display","block");
                }
                else
                {
                  $('.show_all_tab').css("display","none");
                  $('.'+status).css("display","block");
                }
            });

            $("#edit_palette_form").validate({
	            rules: 
	            {
	                category_name: {
	                    required: true,
	                },
	                description: {
	                    required: true,
	                }
	            },
	            messages: 
	            {
	            },
	            submitHandler: function(form) 
	            {
	                var l = $( '.ladda-button-demo' ).ladda();
	                l.ladda( 'start' );
	                var swal_btn = document.getElementById("swal_btn");
					var photo= document.getElementById('photo').files[0];
	                var category_name = $('#category_name').val();
	                var description = $('#description').val();
	       


	                var formData = new FormData();
	                formData.append("style_id", palette_edit_id);
	                if(photo)
	                {
	                	formData.append("photo", photo);
	                }
	                formData.append("category_name", category_name);
	                formData.append("description", description);
	                
	                    
	                $.ajax
	                ({
	                    type:'POST',
	                    url:"/joon/api/EditStyle",
	                    data: formData,
	                    contentType: false,
	                    cache: false,
	                    processData:false,
	                    success: function(data)
	                    {
	                        if( data.status == "success")
	                        {
	                        	$('#palettePicEditModal').modal('hide');
	                            l.ladda('stop');
	                            viewStyles();
	                            if (radio_val == "English")
			               {
			               	swal_btn.click();
			               }
			               else
			               {
			               	swal_btn_copy.click();
			               }
	                        }
	                        else if( data.status == "failed" )
	                        {
	                        	l.ladda('stop');
	                         	alert("NOT EDITED! Data Is same");
	                        }
	                    },
	                    error: function(data) 
	                    {
	                        alert("error");
	                    }           

	                });                
	                return false; // extra insurance preventing the default form action
	            }
	        });



            //Empty List
            $('#swal_btn').click(function(){
                swal({
                    title: "Book Edited",
                    text: "",
                    type: "success",
                    confirmButtonColor: "green",
                });
            });
            
            //Empty List
            $('#swal_btn_copy').click(function(){
                swal({
                    title: "تحرير الكتاب",
                    text: "",
                    type: "success",
                    confirmButtonColor: "green",
                });
            });

            //Delete Row
            $('#swal_btn2').click(function(){
                swal({
                    title: "Book Deleted!",
                    text: "",
                    type: "warning",
                    confirmButtonColor: "#DD6B55",
                });
            });
            //Delete Row
            $('#swal_btn2_copy').click(function(){
                swal({
                    title: "كتاب محذوف!",
                    text: "",
                    type: "warning",
                    confirmButtonColor: "#DD6B55",
                });
            });
			
	   //Book Sold	
	   $('#swal_btn3').click(function(){
                swal({
                    title: "Book Sold!",
                    text: "",
                     type: "success",
                    confirmButtonColor: "green",
                });
            });
            //Book Sold
            $('#swal_btn3_copy').click(function(){
                swal({
                    title: "الكتاب مباع!",
                    text: "",
                     type: "success",
                    confirmButtonColor: "green",
                });
            });

            

        });

        function viewStyles()
        {
            var $list = $("#styles_list");
            $list.empty();
            $.ajax({
                url: "https://maktabty.org/Maktabti/api/ItemView",
                type: "POST",
               // data: { "category_name" : "All" },
                success: function(data)
                {   
                    if ( data.status == "success")
                    {
                        $.each(data.data, function(index,obj) 
                        {                                            
                            $list.append('<div id="'+obj.book_id+'" class="col-md-3 col-sm-4 col-xs-6 show_all_tab '+obj.category_name+'" style="padding: 10px 10px 0px 10px;">'+
                            				'<label style="position: fixed;margin-left:5px;margin-top: 2px;">'+
                            					'<i class="fa fa-pencil" id="'+obj.book_id+'" onclick ="saveBook(this.id);"style="font-size:20px;color:black;margin-right:5px"></i>'+
                            					'<i class="fa fa-shopping-cart" id="'+obj.book_id+'_'+obj.quantity_avail+'" onclick ="BookSaleModal(this.id);" style="font-size:20px;color:blue;margin-right:5px"></i>'+
                            					'<i class="fa fa-trash" id="'+obj.book_id+'" onclick ="PalettePicDeleteModal(this.id);" style="font-size:20px;color:red"></i>'+
                            				'</label>'+
					                     	'<img src="https://maktabty.org/Maktabti/public/'+obj.cover_photo+'" style="width:100%; height:323px">'+
					                    '</div>');
                        });
                    }
                    else
                    {
                        if (radio_val == "English")
	               {
	               	swal_btn.click();
	               }
	               else
	               {
	               	swal_btn_copy.click();
	               }
                    }
                },
                error: function(data)
                {
                }           
            });        
        }

        function PalettePicDetailsModal(id)
        {
            palette_details_assign = id.split('-');
            var palette_details_id  = palette_details_assign[0];
            $('#palette_image_detail').attr('src','/joon/public/'+palette_details_assign[1]);
            $('#category_name_detail').html(palette_details_assign[2]);
            $('#description_detail').html(palette_details_assign[3]); 


            var $list = $("#customer_name");
            $list.empty();
            //Calling Api to get list of all customers
            $.ajax({            
                url: "/joon/api/CustomerViewAll",
                type: "POST",
                success: function(data)
                {
                    if(data.status == "success")
                    {
                        $.each(data.data, function(index,obj) 
                        {                                            
                            $list.append('<option value="'+obj.email+'">'+obj.name+'</option>');
                        });
                    }
                    else if (data.status == "failed")
                    {
                        alert("failed");
                    }
                    $('#palettePicDetailsModal').modal('show');
                },
                error: function(data) 
                {
                }           
            });
        }

        function showAssign()
        {
        	$('#assignToCustomer').css('display','block');
        }


        function hideAssign()
        {
        	$('#assignToCustomer').css('display','none');
        }

        function assigning()
        {
        	var email = $('#customer_name').val();
        	//Calling Api to get list of all customers
            $.ajax({            
                url: "/joon/api/AddStyleCus",
                type: "POST",
                data: { "customer_email" : email ,  "style_id" : palette_details_assign[0] ,  "category_name" : palette_details_assign[2] },
                success: function(data)
                {
                    if(data.status == "success")
                    {
	               if (radio_val == "English")
	               {
	               	swal_btn3.click();
	               }
	               else
	               {
	               	swal_btn3_copy.click();
	               }
                    	$('#palettePicDetailsModal').modal('hide');
                    }
                    else if (data.status == "failed")
                    {
                        alert("failed");
                    }
                },
                error: function(data) 
                {
                }           
            });
        }

        function PalettePicDeleteModal(id)
        {
            $('#palettePicDeleteModal').modal('show');
            palette_delete_id = id;
        }

		
	function BookSaleModal(id)
        {
            $('#BookSaleModal').modal('show');
            
            //alert(id);
            var book_info = id;
            var fields = book_info.split('_');

           book_id= fields[0];
           book_qu = fields[1];
            $('#book_qu').val(book_qu);
            
            //alert (book_id);
        }
		

        function AddOrderStore()
        {
            //$('#BookSaleModal').modal('hide');

            var quantity = $('#quantity').val();
            var tempquan = parseFloat(quantity);
            var tempbookquan = parseFloat(book_qu);
             
           // alert (book_id );
            if(quantity)
            {
            	if(tempquan > tempbookquan )
	        {
	        	alert ("Quantity is more than available stock!");
	        }
	        else
	        {
                    var l = $( '.ladda-button-demo2' ).ladda();
        	    l.ladda( 'start' );

	            $.ajax({            
	                url: "https://maktabty.org/Maktabti/api/AddOrderStore",
	                type: "POST",
	                data: {"book_id": book_id ,"quantity": quantity },
	                success: function(data)
	                {
	                    if(data.status == "success")
	                    {
	                       l.ladda('stop');
	                       $('#quantity').val('');
			       if (radio_val == "English")
		               {
		               	swal_btn3.click();
		               }
		               else
		               {
		               	swal_btn3_copy.click();
		               }
	                        $('#BookSaleModal').modal('hide');
	                        viewStyles();
	                    }
	                    else if (data.status == "failed")
	                    {
	                        alert("failed");
	                    }
	                },
	                error: function(data) 
	                {
	                }           
	            });
	          }
            }
            else
            {
            	alert("Please enter the quantity");
            }
        }

		
		function deletePalette()
        {
            $('#palettePicDeleteModal').modal('hide');

            $.ajax({            
                url: "https://maktabty.org/Maktabti/api/ItemDelete",
                type: "POST",
                data: {"book_id": palette_delete_id},
                success: function(data)
                {
                    if(data.status == "success")
                    {
                        if (radio_val == "English")
	               {
	               	swal_btn2.click();
	               }
	               else
	               {
	               	swal_btn2_copy.click();
	               }
                        viewStyles();
                    }
                    else if (data.status == "failed")
                    {
                        alert("failed");
                    }
                },
                error: function(data) 
                {
                }           
            });
        }

		
        function saveBook(id)
        {

            var bkid = id;
           // alert (bkid);
            localStorage.setItem("bkid",bkid);
            
            window.location.href = "{{ url('edit_book')}}";
        }

    </script>
</body>
</html>
