<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">

    <title>Dry Clean Locker | Items </title>

    <link href="<?php echo e(asset ('css/bootstrap.min.css')); ?>" rel="stylesheet">
    <link href="<?php echo e(asset ('font-awesome/css/font-awesome.css')); ?>" rel="stylesheet">

    <!-- FooTable -->
    <link href="<?php echo e(asset ('css/plugins/footable/footable.core.css')); ?>" rel="stylesheet">

    <!-- Sweet Alert -->
    <link href="<?php echo e(asset ('css/sweetalert.css')); ?>" rel="stylesheet">

    <link href="<?php echo e(asset ('css/animate.css')); ?>" rel="stylesheet">
    <link href="<?php echo e(asset ('css/style.css')); ?>" rel="stylesheet">
    <style type="text/css">
        .activeSM
        {
            background-color: white !important; /* #38283c !important;*/
        }
    </style>
</head>
<body>
    <div id="wrapper">

        <!-- Side Navbar -->
        <?php echo $__env->make('navbar_static_side', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?> 

        <div id="page-wrapper" class="gray-bg">
            <div class="row border-bottom">
                <!-- Top Navbar -->
                <?php echo $__env->make('navbar_static_top', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?> 
            </div>
            <div class="row wrapper border-bottom white-bg page-heading">
                <div class="col-lg-10">
                    <h2><strong>Items</strong></h2>
                    <a href="<?php echo e(url('add_item')); ?>">
                        <button type="button" class="btn btn-default btn-sm">
                            <span class="glyphicon glyphicon-plus"></span> Add an Item
                        </button>
                    </a>
                </div>
                <div class="col-lg-2">

                </div>
            </div>

            <div class="wrapper wrapper-content animated fadeInRight ecommerce">
                <div class="row">
                    <div class="col-lg-12">
                        <div class="ibox">
                            <div class="ibox-content table-responsive">
                                <table class="table table-striped">
                                    <thead>
                                        <tr>
                                            <th>#</th>
                                            <th>Image</th>
                                            <th>Category</th>
                                            <th>Item Name</th>
                                            <th>Description</th>
                                            <th>Price(€)</th>
                                            <th>Action</th>
                                        </tr>
                                    </thead>
                                    <tbody id="item_list">
                                       <!-- Dynamically appending Employees List -->
                                    </tbody>
                                    <tfoot>
                                        <tr>
                                            <td colspan="6">
                                                <ul class="pagination pull-right"></ul>
                                            </td>
                                        </tr>
                                    </tfoot>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Empty List -->
            <button id="swal_btn" type="button" style="display:none"></button>
            <!-- Delete Row -->
            <button id="swal_btn2" type="button" style="display:none"></button>

            <!-- Footer -->
            <?php echo $__env->make('footer', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>

        </div>
    </div>

    <!-- Modal -->
    <div class="modal fade" id="deleteModal" role="dialog">
        <div class="modal-dialog">
          <!-- Modal content-->
            <div class="modal-content">
                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal">&times;</button>
                    <h4 class="modal-title">Delete an Item</h4>
                </div>
                <div class="modal-body">
                    <p>Are you sure you want to delete an Item?</p>
                </div>
                <div class="modal-footer">
                     <button type="button" class="btn btn-default" style="background-color: #1ab394; color: white" onclick="deleteItem()">Yes</button>
                    <button type="button" class="btn btn-default" style="background-color: #ed5565; color: white" data-dismiss="modal">No</button>
                </div>
            </div>
        </div>
    </div>
    <!-- Modal Close -->



    <!-- Mainly scripts -->
    <script src="<?php echo e(asset ('js/jquery-3.1.1.min.js')); ?>"></script>
    <script src="<?php echo e(asset ('js/bootstrap.min.js')); ?>"></script>
    <script src="<?php echo e(asset ('js/plugins/metisMenu/jquery.metisMenu.js')); ?>"></script>
    <script src="<?php echo e(asset ('js/plugins/slimscroll/jquery.slimscroll.min.js')); ?>"></script>

    <!-- Custom and plugin javascript -->
    <script src="<?php echo e(asset ('js/inspinia.js')); ?>"></script>
    <script src="<?php echo e(asset ('js/plugins/pace/pace.min.js')); ?>"></script>

    <!-- Sweet alert -->
    <script src="<?php echo e(asset ('js/plugins/sweetalert/sweetalert.min.js')); ?>"></script>

    <!-- FooTable -->
    <script src="<?php echo e(asset ('js/plugins/footable/footable.all.min.js')); ?>"></script>

    <!-- Page-Level Scripts -->
    <script>
        var delete_item;

        $(document).ready(function() 
        {
            $("#side5").addClass("activeSM");
            $("#side5 a").css("color","#224ea6");

            viewItems();

            //Empty List
            $('#swal_btn').click(function(){
                swal({
                     title: "List is Empty!",
                    text: "Please add an Item.",
                    type: "warning",
                    confirmButtonColor: "#DD6B55",
                    closeOnConfirm: false
                }, function () {
                    window.location.assign("<?php echo e(url('add_item')); ?>");
                });
            });

            //Delete Row
            $('#swal_btn2').click(function(){
                swal({
                    title: "Item Deleted!",
                    text: "",
                    type: "success",
                    confirmButtonColor: "#DD6B55",
                });
            });
        });

        function viewItems()
        {
            var $list = $("#item_list");
            $list.empty();
            $.ajax({
                url: "/DCL/api/ItemView",
                type: "POST",
                success: function(data)
                {   
                    var count = 1;
                    if ( data.status == "success")
                    {
                        $.each(data.data, function(index,obj) 
                        {
                            var price_fixed = parseFloat(obj.Price);
                            var new_price_fixed = price_fixed.toFixed(2);
                            $list.append('<tr>'+
                                            '<td><strong>'+count+'</strong></td>'+
                                            '<td><img width="35" src="/DCL/public/'+obj.Photo+'"/></td>'+
                                            '<td>'+obj.CategoryID+'</td>'+
                                            '<td>'+obj.Name+'</td>'+
                                            '<td>'+obj.Description+'</td>'+
                                            '<td>'+new_price_fixed+'</td>'+
                                            '<td>'+
                                                '<div class="btn-group">'+
                                                    '<button id="'+obj.ItemID+'" onclick ="saveItem(this.id);" class="btn-white btn btn-xs"><img alt="image" width="20" src="img/edit_icon.png" /></button>'+
                                                    '<button id="'+obj.ItemID+'" onclick ="deleteItemModal(this.id);" class="btn-white btn btn-xs"><img alt="image" width="20" src="img/delete_icon.png" /></button>'+
                                                '</div>'+
                                            '</td>'+
                                        '</tr>');
                            count++;
                        });
                    }
                    else
                    {
                        swal_btn.click();
                    }
                },
                error: function(data)
                {
                }           
            });        
        }

        function deleteItemModal(id)
        {
            $('#deleteModal').modal('show');
            delete_item = id;
        }


        function deleteItem()
        {
            $('#deleteModal').modal('hide');

            var item_id = delete_item;
            $.ajax({            
                url: "/DCL/api/ItemDelete",
                type: "POST",
                data: {"ItemID": item_id},
                success: function(data)
                {
                    if(data.status == "success")
                    {
                        swal_btn2.click();
                        viewItems();
                    }
                    else if (data.status == "failed")
                    {
                        alert("failed");
                    }
                },
                error: function(data) 
                {
                }           
            });
        }

        function saveItem(id)
        {
            var item_id = id;
            localStorage.setItem("item_id",item_id);
            window.location.href = "<?php echo e(url('edit_item')); ?>";    
        }
    </script>
</body>
</html>
