<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">

    <title>Timeclock Employee Web | Day Details</title>

    <link href="css/bootstrap.min.css" rel="stylesheet">
    <link href="font-awesome/css/font-awesome.css" rel="stylesheet">

    <!-- FooTable -->
    <link href="css/plugins/footable/footable.core.css" rel="stylesheet">

    <!-- Sweet Alert -->
    <link href="css/sweetalert.css " rel="stylesheet">

    <link href="css/animate.css" rel="stylesheet">
    <link href="css/style.css" rel="stylesheet">
    <style type="text/css">
        .activeSM
        {
            background-color: white !important; /* #38283c !important;*/
        }
        
        .detailsBtn
        {
            background-color: #224ea6;
            color: white;
            border-color: #224ea6;
        }
    </style>
    <script>
    if (!localStorage.login_timeclock_emp)
    {
        window.stop();
        window.location.replace("index.php");
    }
    </script>
</head>

<body>

    <div id="wrapper">
        <?php
            include 'navbar_static_side.php';
        ?>

        <div id="page-wrapper" class="gray-bg">
            <div class="row border-bottom">
                <?php
                include 'navbar_static_top.php';
                ?>
            </div>
            <div class="row wrapper border-bottom white-bg page-heading">
                <div class="row" style="font-size:24px;margin:20px 0px 0px 40px;">
                    <font>Day Details : </font> <font id="selectedDay" style="font-weight:800;color:#224ea6"></font><br>
                    <font>Name : </font> <font id="employee_name" style="font-weight:800;color:#224ea6"></font><br>
                    <font>Location : </font> <font id="employee_location" style="font-weight:800;color:#224ea6"></font><br>
                    <font>Position : </font> <font id="employee_position" style="font-weight:800;color:#224ea6"></font><br>
                </div>
            </div>

            <div class="wrapper wrapper-content animated fadeInRight ecommerce">
                <div class="row">
                    <div class="col-lg-12">
                        <div class="ibox">
                            <div class="ibox-content table-responsive">
                                <table class="footable table table-stripped toggle-arrow-tiny" data-page-size="15">
                                    <thead>
                                        <tr>
                                            <th>Type</th>                                            
                                            <th>Date</th>
                                            <th>Time</th>
                                        </tr>
                                    </thead>
                                    <tbody id="payroll_list">
                                       <!-- Dynamically appending Locations List -->
                                    </tbody>
                                </table>
                                
                                <div class="row" style="font-size:24px;margin-left: 5px;">
                                    <font style="font-weight:800">Total Time for Today : </font> <font id="total_hours"></font><br>
                                    <font style="font-weight:800">Rate per Hour : $</font> <font id="emp_rate"></font><br>
                                    <font style="font-weight:800">Total Payroll for Today : </font> <font id="total_pay"></font><br>
                                    <font style="font-weight:800">Confirmed By : </font> <font id="confirm_by"></font><br>
                                    <font style="font-weight:800">Confirmed Date : </font> <font id="confirm_date"></font><br>
                                    <font style="font-weight:800">Confirmed Time : </font> <font id="confirm_time"></font><br>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Empty List -->
            <button id="swal_btn" type="button" style="display:none">
            <!-- Delete Row -->
            <button id="swal_btn2" type="button" style="display:none">
            <!-- Active/Inactive row -->
            <button id="swal_btn3" type="button" style="display:none">
            <?php
                include 'footer.php';
            ?>
        </div>
    </div>

    <!-- Mainly scripts -->
    <script src="js/jquery-3.1.1.min.js"></script>
    <script src="js/bootstrap.min.js"></script>
    <script src="js/plugins/metisMenu/jquery.metisMenu.js"></script>
    <script src="js/plugins/slimscroll/jquery.slimscroll.min.js"></script>
    
    <!-- Custom and plugin javascript -->
    <script src="js/inspinia.js"></script>
    <script src="js/plugins/pace/pace.min.js"></script>
    
    <!-- Sweet alert -->
    <script src="js/plugins/sweetalert/sweetalert.min.js"></script>
    
    <!-- FooTable -->
    <script src="js/plugins/footable/footable.all.min.js"></script>
    
    <!-- Page-Level Scripts -->
    <script>
        var date1;
        var date2;
    
        $(document).ready(function() 
        {
            var temp = localStorage.choosenDay;
            date1 = temp + " 00:00";
            date2 = temp + " 23:59";
            
            $('#emp_name').html(localStorage.Employee_Name);
            $('#selectedDay').html(localStorage.choosenDay);
            
            $("#side2").addClass("activeSM");
            $("#side2 a").css("color","#224ea6");
    
            viewPayrollList();
            
            //Empty List
            $('#swal_btn').click(function(){
                swal({
                    title: "No Data",
                    text: "Employee has no Working hours During the Selected Week.",
                    type: "warning",
                    confirmButtonColor: "#DD6B55",
                    closeOnConfirm: false
                }, function () {
                    window.location.assign("employee_selection.php");
                });
            });
            
            $('#swal_btn2').click(function(){
                swal({
                    title: "No Details",
                    text: "Employee has no Working hours During the Selected Day.",
                    type: "warning",
                    confirmButtonColor: "#DD6B55",
                });
            });
        });
    
        function viewPayrollList()
        {
            var $list = $("#payroll_list");
            $list.empty();
            
            $.ajax({
                url: "/timeclock/apis/api/ViewOnClockWebEmployees",
                type: "GET",
                data: { "location" : "All" , "date1" : date1 , "date2" : date2 , "employee_id" : localStorage.emp_username },
                success: function(data)
                {   
                    var perHourPay;
                    var TotalHours = 0;
                    
                    if ( data.status == "success")
                    {
                        $.each(data.data, function(index,obj) 
                        {
                            $('#employee_location').html(obj.location);
                            $('#employee_position').html(obj.position);
                            
                            $list.append('<tr style="color:green">'+
                                            '<td ><strong>ClockIn</strong></td>'+
                                            '<td>'+obj.date+'</td>'+
                                            '<td>'+obj.time+'</td>'+
                                        '</tr>');
                            
                            $.each(obj.employee_details, function(index2,obj2)
                            {
                                $('#employee_name').html(obj2.emp_fname + " " + obj2.emp_lname);
                                perHourPay = parseFloat(obj2.perhour_pay);
                            });
                            
                            if( obj.breaks )
                            {
                                $.each(obj.breaks, function(index3,obj3)
                                {
                                    $list.append('<tr style="color:red">'+
                                                    '<td ><strong>'+obj3.action+'</strong></td>'+
                                                    '<td>'+obj3.date+'</td>'+
                                                    '<td>'+obj3.time+'</td>'+
                                                '</tr>');
                                                
                                    if(obj3.back_to_work_date)
                                    {
                                        $list.append('<tr style="color:green">'+
                                                        '<td ><strong>Back to Work</strong></td>'+
                                                        '<td>'+obj3.back_to_work_date+'</td>'+
                                                        '<td>'+obj3.back_to_work_time+'</td>'+
                                                    '</tr>');
                                    }
                                });
                            }
                            
                            $.each(obj.clockouts, function(index4,obj4)
                            {
                                $list.append('<tr style="color:red">'+
                                                '<td ><strong>ClockOut</strong></td>'+
                                                '<td>'+obj4.date+'</td>'+
                                                '<td>'+obj4.time+'</td>'+
                                            '</tr>');
                            });
                            
                            $list.append('<tr>'+
                                                '<td ></td>'+
                                                '<td></td>'+
                                                '<td></td>'+
                                            '</tr>');
                            
                            TotalHours = TotalHours + parseFloat(obj.working_hours);
                            
                            var confirm_temp = obj.confirm_timestamp.split(" ");
                            $('#confirm_by').html(obj.confirm_employee_fullname);
                            $('#confirm_date').html(confirm_temp[0]);
                            $('#confirm_time').html(confirm_temp[1]);
                        });
                        
                        TotalHours  = (TotalHours / 3600).toFixed(2);
                        
                        var total_pay   = (TotalHours * perHourPay).toFixed(2);
                        $('#total_hours').html(TotalHours);
                        $('#emp_rate').html(perHourPay);
                        $('#total_pay').html('$' + total_pay);
                    }
                    else
                    {
                        swal_btn.click();
                    }
                },
                error: function(data)
                {
                }           
            });        
        }
    
        function viewDetails(day)
        {
            var choosenDay = day;
            if( choosenDay == 0 )
            {
                swal_btn2.click();
            }
            else
            {
                localStorage.setItem("choosenDay",choosenDay);
                window.location.href = "details.php";
            }
        }
    </script>
</body>
</html>