<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">

    <title>Timeclock Employee Web | Employee Selection</title>

    <link href="css/bootstrap.min.css" rel="stylesheet">
    <link href="font-awesome/css/font-awesome.css" rel="stylesheet">

    <!-- FooTable -->
    <link href="css/plugins/footable/footable.core.css" rel="stylesheet">

    <!-- Sweet Alert -->
    <link href="css/sweetalert.css " rel="stylesheet">

    <link href="css/animate.css" rel="stylesheet">
    <link href="css/style.css" rel="stylesheet">
    <style type="text/css">
        .activeSM
        {
            background-color: white !important; /* #38283c !important;*/
        }
    </style>
    <script>
    if (!localStorage.login_timeclock_emp)
    {
        window.stop();
        window.location.replace("index.php");
    }
    </script>
</head>
<body>
    <div id="wrapper">
        <?php
        include 'navbar_static_side.php';
        ?>

        <div id="page-wrapper" class="gray-bg">
            <div class="row border-bottom">
                <?php
                    include 'navbar_static_top.php';
                ?>
            </div>
            <div class="row wrapper border-bottom white-bg page-heading">
                <div class="col-lg-10">
                    <h2><strong>Choose a Week</strong></h2>
                </div>
                <div class="col-lg-2">
                </div>
            </div>

            <div class="wrapper wrapper-content animated fadeInRight ecommerce">
                <div class="container">
                    <div class="row">
                        <div class="col-sm-2"></div>
                        <div class="col-sm-6">
                            <div>
                                <button id="currentweek" onclick="calculateCurrentWeek()" style="background-color: #224ea6;border-color: #224ea6;color: white; width: 100%; height: 40px; font-size: 20px; margin-bottom : 20px" class="btn btn-primary m-t-n-xs">
                                    Current Week
                                </button>
                            </div>
                            <div>
                                <button id="lastweek" onclick="goForward(this.id)" style="background-color: white;border-color: #224ea6;color: #224ea6; width: 100%; height: 40px; font-size: 20px; margin-bottom : 20px" class="btn btn-primary m-t-n-xs">
                                </button>
                            </div>
                            <div>
                                <button id="secondlastweek" onclick="goForward(this.id)" style="background-color: white;border-color: #224ea6;color: #224ea6; width: 100%; height: 40px; font-size: 20px; margin-bottom : 20px" class="btn btn-primary m-t-n-xs">
                                </button>
                            </div>
                            <div>
                                <button id="thirdlastweek" onclick="goForward(this.id)" style="background-color: white;border-color: #224ea6;color: #224ea6; width: 100%; height: 40px; font-size: 20px; margin-bottom : 20px" class="btn btn-primary m-t-n-xs">Schedule
                                </button>
                            </div>
                        </div>
                        <div class="col-sm-4"></div>
                    </div>
                </div>
            </div>
            
            <?php
                include 'footer.php';
            ?>
            <!-- Empty List -->
            <button id="swal_btn" type="button" style="display:none">
            <!-- Delete Row -->
            <button id="swal_btn2" type="button" style="display:none">
            <!-- Active/Inactive row -->
            <button id="swal_btn3" type="button" style="display:none">

            

        </div>
    </div>

    <!-- Mainly scripts -->
    <script src="js/jquery-3.1.1.min.js"></script>
    <script src="js/bootstrap.min.js"></script>
    <script src="js/plugins/metisMenu/jquery.metisMenu.js"></script>
    <script src="js/plugins/slimscroll/jquery.slimscroll.min.js"></script>

    <!-- Custom and plugin javascript -->
    <script src="js/inspinia.js"></script>
    <script src="js/plugins/pace/pace.min.js"></script>

    <!-- Sweet alert -->
    <script src="js/plugins/sweetalert/sweetalert.min.js"></script>

    <!-- FooTable -->
    <script src="js/plugins/footable/footable.all.min.js"></script>

    <!-- Page-Level Scripts -->
    <script>
        $( document ).ready(function() 
        {
            $('#emp_name').html(localStorage.Employee_Name);
            
            $("#side2").addClass("activeSM");
            $("#side2 a").css("color","#224ea6");
            
            calculateWeek(7,"lastweek");
            calculateWeek(14,"secondlastweek");
            calculateWeek(21,"thirdlastweek");
        });
        
        function calculateWeek(week,button)
        {
            var beforeOneWeek = new Date(new Date().getTime() - 60 * 60 * 24 * week * 1000)
              , day = beforeOneWeek.getDay()
              , diffToMonday = beforeOneWeek.getDate() - day + (day === 0 ? -6 : 1)
              , lastMonday = new Date(beforeOneWeek.setDate(diffToMonday))
              , lastSunday = new Date(beforeOneWeek.setDate(diffToMonday + 6));
            
            var dd = lastMonday.getDate();
            var mm = lastMonday.getMonth()+1; 
            var yyyy = lastMonday.getFullYear();
            
            if(dd<10) 
            {
                dd='0'+dd;
            } 
            
            if(mm<10) 
            {
                mm='0'+mm;
            } 
            var lastweekMonday = mm+'/'+dd+'/'+yyyy;
            
            var dd = lastSunday.getDate();
            var mm = lastSunday.getMonth()+1; 
            var yyyy = lastSunday.getFullYear();
            
            if(dd<10) 
            {
                dd='0'+dd;
            } 
            
            if(mm<10) 
            {
                mm='0'+mm;
            } 
            var lastweekSunday = mm+'/'+dd+'/'+yyyy;
            
            $('#'+button).html( lastweekMonday + "-" + lastweekSunday );
        }
        
        function calculateCurrentWeek()
        {
            var beforeOneWeek = new Date(new Date().getTime() - 60 * 60 * 24 * 1 * 1000)
              , day = beforeOneWeek.getDay()
              , diffToMonday = beforeOneWeek.getDate() - day + (day === 0 ? -6 : 1)
              , lastMonday = new Date(beforeOneWeek.setDate(diffToMonday))
              , lastSunday = new Date(beforeOneWeek.setDate(diffToMonday + 6));
            
            var dd = lastMonday.getDate();
            var mm = lastMonday.getMonth()+1; 
            var yyyy = lastMonday.getFullYear();
            
            if(dd<10) 
            {
                dd='0'+dd;
            } 
            
            if(mm<10) 
            {
                mm='0'+mm;
            } 
            var lastweekMonday = mm+'/'+dd+'/'+yyyy;
            
            var dd = lastSunday.getDate();
            var mm = lastSunday.getMonth()+1; 
            var yyyy = lastSunday.getFullYear();
            
            if(dd<10) 
            {
                dd='0'+dd;
            } 
            
            if(mm<10) 
            {
                mm='0'+mm;
            } 
            var lastweekSunday = mm+'/'+dd+'/'+yyyy;
            
            localStorage.selectedweek = lastweekMonday + "-" + lastweekSunday;
            window.location.href = "weekly_report.php";
        }
        
        function goForward(id)
        {
            var week = $("#"+id).html();
            localStorage.selectedweek = week;
            window.location.href = "weekly_report.php";
        }
    </script>
</body>
</html>
