<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">

    <title>Timeclock Employee Web | Weekly Report</title>

    <link href="css/bootstrap.min.css" rel="stylesheet">
    <link href="font-awesome/css/font-awesome.css" rel="stylesheet">

    <!-- FooTable -->
    <link href="css/plugins/footable/footable.core.css" rel="stylesheet">

    <!-- Sweet Alert -->
    <link href="css/sweetalert.css " rel="stylesheet">

    <link href="css/animate.css" rel="stylesheet">
    <link href="css/style.css" rel="stylesheet">
    <style type="text/css">
        .activeSM
        {
            background-color: white !important; /* #38283c !important;*/
        }
        
        .detailsBtn
        {
            background-color: #224ea6;
            color: white;
            border-color: #224ea6;
        }
    </style>
    <script>
    if (!localStorage.login_timeclock_emp)
    {
        window.stop();
        window.location.replace("index.php");
    }
    </script>
</head>

<body>

    <div id="wrapper">
        <?php
            include 'navbar_static_side.php';
        ?>

        <div id="page-wrapper" class="gray-bg">
            <div class="row border-bottom">
                <?php
                include 'navbar_static_top.php';
                ?>
            </div>
            <div class="row wrapper border-bottom white-bg page-heading">
                <div class="col-lg-10">
                    <h2><strong>Payroll Details for a week</strong></h2>
                    <h2 style="color:#224ea6;font-weight:bolder" id="selectedWeek"></h2>
                </div>
                <div class="col-lg-2">

                </div>
            </div>

            <div class="wrapper wrapper-content animated fadeInRight ecommerce">
                <div class="row">
                    <div class="col-lg-12">
                        <div class="ibox">
                            <div class="ibox-content table-responsive">
                                <div class="row">
                                    <center>
                                    <div class="col-xs-6">
                                        <h2 style="font-weight:800">Total Hours</h2>
                                        <h2 id="total_hours" style="font-weight:800;color:#224ea6"></h2>
                                    </div>
                                    <div class="col-xs-6">
                                        <h2 style="font-weight:800">Amount to Pay</h2>
                                        <h2 id="total_pay" style="font-weight:800;color:#224ea6"></h2>
                                    </div>
                                    </center>
                                </div>
                                
                                <table class="footable table table-stripped toggle-arrow-tiny" data-page-size="15">
                                    <thead>
                                        <tr>
                                            <th>Day</th>                                            
                                            <th>Date</th>
                                            <th>Total Hours</th>
                                            <th>Amount to Pay</th>
                                            <th>Action</th>
                                        </tr>
                                    </thead>
                                    <tbody id="payroll_list">
                                       <!-- Dynamically appending Locations List -->
                                    </tbody>
                                    <tfoot>
                                        <tr>
                                            <td colspan="6">
                                                <ul class="pagination pull-right"></ul>
                                            </td>
                                        </tr>
                                    </tfoot>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Empty List -->
            <button id="swal_btn" type="button" style="display:none">
            <!-- Delete Row -->
            <button id="swal_btn2" type="button" style="display:none">
            <!-- Active/Inactive row -->
            <button id="swal_btn3" type="button" style="display:none">

            <?php
            include 'footer.php';
            ?>

        </div>
    </div>

    <!-- Mainly scripts -->
    <script src="js/jquery-3.1.1.min.js"></script>
    <script src="js/bootstrap.min.js"></script>
    <script src="js/plugins/metisMenu/jquery.metisMenu.js"></script>
    <script src="js/plugins/slimscroll/jquery.slimscroll.min.js"></script>
    
    <!-- Custom and plugin javascript -->
    <script src="js/inspinia.js"></script>
    <script src="js/plugins/pace/pace.min.js"></script>
    
    <!-- Sweet alert -->
    <script src="js/plugins/sweetalert/sweetalert.min.js"></script>
    
    <!-- FooTable -->
    <script src="js/plugins/footable/footable.all.min.js"></script>
    
    <!-- Page-Level Scripts -->
    <script>
        var date1;
        var date2;
    
        $(document).ready(function() 
        {
            var temp = localStorage.selectedweek.split('-');
            date1 = temp[0] + " 00:00";
            date2 = temp[1] + " 23:59";
            
            $('#emp_name').html(localStorage.Employee_Name);
            $('#selectedWeek').html(localStorage.selectedweek);
            
            $("#side2").addClass("activeSM");
            $("#side2 a").css("color","#224ea6");
    
            viewPayrollList();
            
            //Empty List
            $('#swal_btn').click(function(){
                swal({
                    title: "No Data",
                    text: "Employee has no Working hours During the Selected Week.",
                    type: "warning",
                    confirmButtonColor: "#DD6B55",
                    closeOnConfirm: false
                }, function () {
                    window.location.assign("employee_selection.php");
                });
            });
            
            $('#swal_btn2').click(function(){
                swal({
                    title: "No Details",
                    text: "Employee has no Working hours During the Selected Day.",
                    type: "warning",
                    confirmButtonColor: "#DD6B55",
                });
            });
        });
    
        function viewPayrollList()
        {
            var $list = $("#payroll_list");
            $list.empty();
            
            $.ajax({
                url: "/timeclock/apis/api/ViewOnClockWebEmployees",
                type: "GET",
                data: { "location" : "All" , "date1" : date1 , "date2" : date2 , "employee_id" : localStorage.emp_username },
                success: function(data)
                {   
                    var perHourPay;
                    var Mdate = Tdate = Wdate = Thdate = Fdate = Sdate = Sudate = 0;
                    var Mhours = Thours = Whours = Thhours = Fhours = Shours = Suhours = 0;
                    var weekday = new Array(7);
                    weekday[0] = "Sunday";
                    weekday[1] = "Monday";
                    weekday[2] = "Tuesday";
                    weekday[3] = "Wednesday";
                    weekday[4] = "Thursday";
                    weekday[5] = "Friday";
                    weekday[6] = "Saturday";
                    
                    if ( data.status == "success")
                    {
                        $.each(data.data, function(index,obj) 
                        {
                            $.each(obj.employee_details, function(index2,obj2)
                            {
                                perHourPay = parseFloat(obj2.perhour_pay);
                            });
                            
                            var d = new Date(obj.clock_out);
                            var DayofWeek = weekday[d.getDay()];
                            
                            if( DayofWeek == "Monday" )
                            {
                                $.each(obj.clockouts, function(index3,obj3)
                                {
                                    Mdate = obj3.date;
                                });
                                
                                Mhours = Mhours + parseFloat(obj.working_hours);
                            }
                            else if( DayofWeek == "Tuesday")
                            {
                                $.each(obj.clockouts, function(index3,obj3)
                                {
                                    Tdate = obj3.date;
                                });
                                
                                Thours = Thours + parseFloat(obj.working_hours);
                            }
                            else if( DayofWeek == "Wednesday")
                            {
                                $.each(obj.clockouts, function(index3,obj3)
                                {
                                    Wdate = obj3.date;
                                });
                                
                                Whours = Whours + parseFloat(obj.working_hours);
                            }
                            else if( DayofWeek == "Thursday")
                            {
                                $.each(obj.clockouts, function(index3,obj3)
                                {
                                    Thdate = obj3.date;
                                });
                                
                                Thhours = Thhours + parseFloat(obj.working_hours);
                            }
                            else if( DayofWeek == "Friday")
                            {
                                $.each(obj.clockouts, function(index3,obj3)
                                {
                                    Fdate = obj3.date;
                                });
                                
                                Fhours = Fhours + parseFloat(obj.working_hours);
                            }
                            else if( DayofWeek == "Saturday")
                            {
                                $.each(obj.clockouts, function(index3,obj3)
                                {
                                    Sdate = obj3.date;
                                });
                                
                                Shours = Shours + parseFloat(obj.working_hours);
                            }
                            else if( DayofWeek == "Sunday")
                            {
                                $.each(obj.clockouts, function(index3,obj3)
                                {
                                    Sudate = obj3.date;
                                });
                                
                                Suhours = Suhours + parseFloat(obj.working_hours);
                            }
                            
                            console.log(Mdate + " " + Tdate+ " " + Wdate+ " " + Thdate+ " " + Fdate+ " " + Sdate+ " " + Sudate);
                            console.log(Mhours+ " " + Thours+ " " + Whours+ " " + Thhours+ " " + Fhours+ " " + Shours+ " " + Suhours);
                        });
                        
                        Mhours  = (Mhours / 3600).toFixed(2);
                        Thours  = (Thours / 3600).toFixed(2);
                        Whours  = (Whours / 3600).toFixed(2);
                        Thhours  = (Thhours / 3600).toFixed(2);
                        Fhours  = (Fhours / 3600).toFixed(2);
                        Shours  = (Shours / 3600).toFixed(2);
                        Suhours  = (Suhours / 3600).toFixed(2);
                        
                        var total_hours = parseFloat(Mhours) + parseFloat(Thours) + parseFloat(Whours) + parseFloat(Thhours) + parseFloat(Fhours) + parseFloat(Shours) + parseFloat(Suhours);
                        var total_pay   = (total_hours * perHourPay).toFixed(2);
                        
                        $('#total_hours').html(total_hours.toFixed(2));
                        $('#total_pay').html('$' + total_pay);
                        
                        $list.append('<tr>'+
                                        '<td><strong>Monday</strong></td>'+
                                        '<td>'+Mdate+'</td>'+
                                        '<td>'+Mhours+'</td>'+
                                        '<td>$'+(Mhours * perHourPay).toFixed(2)+'</td>'+
                                        '<td>'+
                                            '<div class="btn-group">'+
                                                '<button id="'+Mdate+'" onclick ="viewDetails(this.id);" class="detailsBtn btn-white btn btn-xs">View Details</button>'+
                                            '</div>'+
                                        '</td>'+
                                    '</tr>'+
                                    '<tr>'+
                                        '<td><strong>Tuesday</strong></td>'+
                                        '<td>'+Tdate+'</td>'+
                                        '<td>'+Thours+'</td>'+
                                        '<td>$'+(Thours * perHourPay).toFixed(2)+'</td>'+
                                        '<td>'+
                                            '<div class="btn-group">'+
                                                '<button id="'+Tdate+'" onclick ="viewDetails(this.id);" class="detailsBtn btn-white btn btn-xs">View Details</button>'+
                                            '</div>'+
                                        '</td>'+
                                    '</tr>'+
                                    '<tr>'+
                                        '<td><strong>Wednesday</strong></td>'+
                                        '<td>'+Wdate+'</td>'+
                                        '<td>'+Whours+'</td>'+
                                        '<td>$'+(Whours * perHourPay).toFixed(2)+'</td>'+
                                        '<td>'+
                                            '<div class="btn-group">'+
                                                '<button id="'+Wdate+'" onclick ="viewDetails(this.id);" class="detailsBtn btn-white btn btn-xs">View Details</button>'+
                                            '</div>'+
                                        '</td>'+
                                    '</tr>'+
                                    '<tr>'+
                                        '<td><strong>Thursday</strong></td>'+
                                        '<td>'+Thdate+'</td>'+
                                        '<td>'+Thhours+'</td>'+
                                        '<td>$'+(Thhours * perHourPay).toFixed(2)+'</td>'+
                                        '<td>'+
                                            '<div class="btn-group">'+
                                                '<button id="'+Thdate+'" onclick ="viewDetails(this.id);" class="detailsBtn btn-white btn btn-xs">View Details</button>'+
                                            '</div>'+
                                        '</td>'+
                                    '</tr>'+
                                    '<tr>'+
                                        '<td><strong>Friday</strong></td>'+
                                        '<td>'+Fdate+'</td>'+
                                        '<td>'+Fhours+'</td>'+
                                        '<td>$'+(Fhours * perHourPay).toFixed(2)+'</td>'+
                                        '<td>'+
                                            '<div class="btn-group">'+
                                                '<button id="'+Fdate+'" onclick ="viewDetails(this.id);" class="detailsBtn btn-white btn btn-xs">View Details</button>'+
                                            '</div>'+
                                        '</td>'+
                                    '</tr>'+
                                    '<tr>'+
                                        '<td><strong>Saturday</strong></td>'+
                                        '<td>'+Sdate+'</td>'+
                                        '<td>'+Shours+'</td>'+
                                        '<td>$'+(Shours * perHourPay).toFixed(2)+'</td>'+
                                        '<td>'+
                                            '<div class="btn-group">'+
                                                '<button id="'+Sdate+'" onclick ="viewDetails(this.id);" class="detailsBtn btn-white btn btn-xs">View Details</button>'+
                                            '</div>'+
                                        '</td>'+
                                    '</tr>'+
                                    '<tr>'+
                                        '<td><strong>Sunday</strong></td>'+
                                        '<td>'+Sudate+'</td>'+
                                        '<td>'+Suhours+'</td>'+
                                        '<td>$'+(Suhours * perHourPay).toFixed(2)+'</td>'+
                                        '<td>'+
                                            '<div class="btn-group">'+
                                                '<button id="'+Sudate+'" onclick ="viewDetails(this.id);" class="detailsBtn btn-white btn btn-xs">View Details</button>'+
                                            '</div>'+
                                        '</td>'+
                                    '</tr>');
                    }
                    else
                    {
                        swal_btn.click();
                    }
                },
                error: function(data)
                {
                }           
            });        
        }
    
        function viewDetails(day)
        {
            var choosenDay = day;
            if( choosenDay == 0 )
            {
                swal_btn2.click();
            }
            else
            {
                localStorage.setItem("choosenDay",choosenDay);
                window.location.href = "details.php";
            }
        }
    </script>
</body>
</html>
