<!DOCTYPE html>
<html>
<head>
  <title>Maktabti | Add Book </title>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">

  <link href="<?php echo e(asset ('css/bootstrap.min.css')); ?>" rel="stylesheet">
  <link href="<?php echo e(asset ('font-awesome/css/font-awesome.css')); ?>" rel="stylesheet">

  <!-- FooTable -->
  <link href="<?php echo e(asset ('css/plugins/footable/footable.core.css')); ?>" rel="stylesheet">

  <!-- Sweet Alert -->
  <link href="<?php echo e(asset ('css/sweetalert.css')); ?>" rel="stylesheet">

  <!-- Ladda style -->
  <link href="<?php echo e(asset ('css/ladda-themeless.min.css')); ?>" rel="stylesheet">
  <link href="<?php echo e(asset ('css/animate.css')); ?>" rel="stylesheet">
  <link href="<?php echo e(asset ('css/style.css')); ?>" rel="stylesheet">
  
  <style type="text/css">
  .activeSM
  {
    background-color: white !important; /* #38283c !important;*/
  }
</style>
<style>
article, aside, figure, footer, header, hgroup, 
menu, nav, section { display: block; }
</style>
<script>
  if (!localStorage.Session)
  {
    window.stop();
    window.location.replace("login");
  }
</script>
<style>
* {
  box-sizing: border-box;
}

body {
  background-color: #f1f1f1;
}

#regForm {
  background-color: #ffffff;
  margin: 100px auto;
  font-family: Raleway;
  padding: 40px;
  width: 70%;
  min-width: 300px;
}

h1 {
  text-align: center;  
}

input {
  padding: 10px;
  width: 100%;
  font-size: 17px;
  font-family: Raleway;
  border: 1px solid #aaaaaa;
}

/* Mark input boxes that gets an error on validation: */
input.invalid {
  background-color: #ffdddd;
}

/* Hide all steps by default: */

button {
  background-color: #4CAF50;
  color: #ffffff;
  border: none;
  padding: 10px 20px;
  font-size: 17px;
  font-family: Raleway;
  cursor: pointer;
}

button:hover {
  opacity: 0.8;
}

#prevBtn {
  background-color: #bbbbbb;
}

/* Make circles that indicate the steps of the form: */
.step {
  height: 15px;
  width: 15px;
  margin: 0 2px;
  background-color: #bbbbbb;
  border: none;  
  border-radius: 50%;
  display: inline-block;
  opacity: 0.5;
}

.step.active {
  opacity: 1;
}

/* Mark the steps that are finished and valid: */
.step.finish {
  background-color: #4CAF50;
}
 .image-upload > input[type="file"]
{
    display: none;
}

.image-upload #add_book_image
{
    width: 80px;
    cursor: pointer;
}
</style>
</head>

<body>
  <div id="wrapper">
    <?php echo $__env->make('navbar_static_side', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>

    <div id="page-wrapper" class="gray-bg">
      <div class="row border-bottom">
        <?php echo $__env->make('navbar_static_top', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>
      </div>

			
			
	<div class="row wrapper border-bottom white-bg page-heading">
        	<div id="Add_book_title_eng" style="display:none" class="col-lg-10">
			<h2><strong>Add Book</strong></h2>					  
			<ol class="breadcrumb">
				<li>
					<a href="<?php echo e(url('view_books')); ?>">Books</a>
				</li>
				<li class="active">
					<strong>Add a Book</strong>
				</li>
			</ol>
		</div>
        	
        	<div id="Add_book_title_arabic" style="display:none"  class="col-lg-10">
			<h2><strong>أضف كتاب </strong></h2>
			<ol class="breadcrumb">
				<li>
					<a href="<?php echo e(url('view_books')); ?>">كتب</a>
				</li>
				<li class="active">
					<strong>أضف كتاب</strong>
				</li>
			</ol>
		</div>
	        <div class="col-lg-2">	
	        </div>
      </div>

      <div class="wrapper wrapper-content animated fadeInRight">
        <div class="row">
          <div class="col-lg-8">
            <div class="ibox ">
              <div class="ibox-content">
                <form id="regForm" style="display: block" >
					
                  <h1>
				 
				   <font id="add_book_form_heading_eng" style="display:none"> Book Information:</font>
                   <font id="add_book_form_heading_arb" style="display:none">:معلومات الكتاب</font>
				  </h1> <br>
                  <!-- One "tab" for each step in the form: -->

                   <label>
				  
				    <font id="add_book_name_english_eng" style="display:none">Book Name (English)</font>
                    <font id="add_book_name_english_arb" style="display:none">(اسم الكتاب (الإنجليزية</font>
				   </label>
                   <input type="text" id="name_english" name="name_english" placeholder="" class="form-control" required>
                   <br>

                   <label>
				  
				    <font id="add_book_name_arabic_eng" style="display:none">Book Name (Arabic)</font>
                    <font id="add_book_name_arabic_arb" style="display:none">(اسم الكتاب (عربى</font>
				   </label>
                   <input type="text" id="name_arabic" name="name_arabic" placeholder="" class="form-control" required>
                   <br>
                   
                   <label>
				  
				    <font id="add_book_photo_eng" style="display:none">Upload Book Cover Photo</font>
                    <font id="add_book_photo_arb" style="display:none">تحميل صورة الغلاف</font>
				   </label>
                   <input type="file" id="photo" name="photo" class="form-control"  onchange="readURL(this);" required>
                   <img id="blah" src="img/no-image-found.png" width="100" alt="your image" />
                   <br>
                   
                   <label>
				  
				    <font id="add_book_category_list_eng" style="display:none"> Choose Book Category</font>
                     <font id="add_book_category_list_arb" style="display:none">اختر فئة الكتاب</font>
				   </label>								
                   <select class="form-control" id="category_list" name="category_list" required="">
                   </select>
                   <br>
                   
                   <label>
				  
				    <font id="add_book_description_english_eng" style="display:none"> Description (English)</font>
                    <font id="add_book_description_english_arb" style="display:none">(وصف (الإنجليزية</font>
				   </label>
                   <textarea rows="5" id="description_english" name="description_english" placeholder="" class="form-control" required></textarea>
                   <br>

                   <label>
				  
				    <font id="add_book_description_arabic_eng" style="display:none"> Description (Arabic)</font>
                    <font id="add_book_description_arabic_arb" style="display:none">(وصف (عربى</font>
				   </label>
                   <textarea rows="5" id="description_arabic" name="description_arabic" placeholder="" class="form-control" required></textarea>
                   <br>
                   
                   <label>
				  
				    <font id="add_book_price_eng" style="display:none"> Unit Price</font>
                    <font id="add_book_price_arb" style="display:none">سعر الوحده</font>
				   </label>
                   <input type="text" id="price" name="price" placeholder="" class="form-control" required>
                   <br>

                   <label>
				  
				    <font id="add_book_quantity_avail_eng" style="display:none"> In Stock</font>
                    <font id="add_book_quantity_avail_arb" style="display:none">في المخزن</font>
				   </label>
                   <input type="text" id="quantity_avail" name="quantity_avail" placeholder="" class="form-control" required>
                   <br>

                    <div>
                            <button style="background-color: #566b8a;color: white;" class="ladda-button ladda-button-demo btn btn-sm btn-primary m-t-n-xs" type="submit" data-style="zoom-in">
                                 <span class="ladda-label">
								 
								<font id="add_book_formsub_eng" style="display:none">Submit</font>
								<font id="add_book_formsub_arb" style="display:none">خضع</font>
								 </span><span class="ladda-spinner"></span>
                            </button>
                        </div>		

              </form>
			  
			   <!-- Arabic Form End --> 
			  

              <form id="regForm2" style="display: none">
                  <h1>
				  
				  <font id="add_book_img_head_eng" style="display:none"> Book Images:</font>
                  <font id="add_book_img_head_arb" style="display:none">:صور الكتاب</font>
				  </h1> <br>
                  <!-- One "tab" for each step in the form: -->
                  <div  class="row" id="uploaded_img_div">
                  	<!-- Dynamically Uploading Images -->
                  </div>
                  <br>
                  <div class="tab image-upload">
                  	<label for="photo_pages">
				<img id="add_book_image" src="img/plus_icon.png" width="100" alt="your image" />
			</label>
			<input type="file" id="photo_pages" name="photo_pages" class="form-control" onchange="readURL2(this);" required>
                 </div>

<br>
<br>
                <div>
                            <button style="background-color: #566b8a;color: white;" class="ladda-button ladda-button-demo btn btn-sm btn-primary m-t-n-xs" type="submit" data-style="zoom-in">
                                 <span class="ladda-label">
								 
								 <font id="add_book_form_images_eng" style="display:none"> Add Book Images</font>
								<font id="add_book_form_images_arb" style="display:none">:صور الكتاب</font>
				  
								 </span><span class="ladda-spinner"></span>
                            </button>

                           <!--  <button style="background-color: #566b8a;color: white;" class="ladda-button ladda-button-demo btn btn-sm btn-primary m-t-n-xs" type="submit" data-style="zoom-in">
                                 <span class="ladda-label">Save</span><span class="ladda-spinner"></span>
                            </button>  -->
                            
                            <button id="swal_btn"  type="button" style="display:none"></button>
                            <button id="swal_btn2" type="button" style="display:none"></button>
                            <button id="swal_btn3" type="button" style="display:none"></button>
                            <button id="swal_btn_copy"  type="button" style="display:none"></button>
                            <button id="swal_btn2_copy" type="button" style="display:none"></button>
                            <button id="swal_btn3_copy" type="button" style="display:none"></button>

                        </div>

              </form>
              <br>
              <a id="save_book_button" href="<?php echo e(url('view_books')); ?>" style="display:none">
                    <button style="background-color: green;color: white;" class="btn btn-sm btn-primary m-t-n-xs" type="submit" data-style="zoom-in">
                         <span class="ladda-label">
						
						  <font id="add_book_saveimg_eng" style="display:none">  Save Book</font>
							<font id="add_book_saveimg_arb" style="display:none">حفظ الكتاب</font>
				  
				  
						 </span><span class="ladda-spinner"></span>
                    </button>
	      </a>
              

                



            </div>
          </div>
        </div>
      </div>
    </div>
    <?php echo $__env->make('footer', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>
  </div>
</div>



<!-- Mainly scripts -->
<script src="js/jquery-3.1.1.min.js"></script>
<script src="js/bootstrap.min.js"></script>
<script src="js/plugins/metisMenu/jquery.metisMenu.js"></script>
<script src="js/plugins/slimscroll/jquery.slimscroll.min.js"></script>

<!-- Custom and plugin javascript -->
<script src="js/inspinia.js"></script>
<script src="js/plugins/pace/pace.min.js"></script>

<script src="js/plugins/jquery-ui/jquery-ui.min.js"></script>

<!-- Sweet alert -->
<script src="js/plugins/sweetalert/sweetalert.min.js"></script>

<!-- Jquery Validate -->
<script src="js/plugins/validate/jquery.validate.min.js"></script>

<!-- Ladda -->
<script src="js/plugins/ladda/spin.min.js"></script>
<script src="js/plugins/ladda/ladda.min.js"></script>
<script src="js/plugins/ladda/ladda.jquery.min.js"></script>

<script>
  var errorMessage;
  var bk_id;
  var book_images_array;
  
  $(document).ready(function()
  {
    viewCategories();
    $("#side7").addClass("activeSM");
    $("#side7 a").css("color","#224ea6");

    $("#regForm").validate({
      rules: 
      {
        photo: {
          required: true
        },
        name_english: {
          required: true,
        },
        name_arabic: {
          required: true,
        }
      },
      messages: 
      {
      },
      submitHandler: function(form) 
      {
        var l = $( '.ladda-button-demo' ).ladda();
        l.ladda( 'start' );

        var photo= document.getElementById('photo').files[0];
        var name_english = $('#name_english').val();
        var name_arabic = $('#name_arabic').val();
        var description_english = $('#description_english').val();
        var description_arabic = $('#description_arabic').val();
        var price = $('#price').val();
        var quantity_avail = $('#quantity_avail').val();
        var law_category = $('#category_list').val();

        var formData = new FormData();
        formData.append("name_english", name_english);
        formData.append("name_arabic", name_arabic);
        formData.append("description_english", description_english);
        formData.append("description_arabic", description_arabic);
        formData.append("price", price);
        formData.append("quantity_avail", quantity_avail);
        formData.append("law_category", law_category);
        formData.append("photo", photo);


        $.ajax
        ({
          type:'POST',
          url:"https://maktabty.org/Maktabti/api/AddItem",
          data: formData,
          contentType: false,
          cache: false,
          processData:false,
          success: function(data)
          {
            if( data.status == "success")
            {
               l.ladda('stop');               
               if (radio_val == "English")
               {
               	swal_btn.click();
               }
               else
               {
               	swal_btn_copy.click();
               }
               
               bk_id = data.book_id;
               
              $('#regForm').css('display','none');
              $('#regForm2').css('display','block');
              $('#save_book_button').css('display','block');
            }
            else if( data.status == "failed" )
            {
              l.ladda('stop');
              errorMessage = data.error;
               if (radio_val == "English")
               {
               	swal_btn2.click();
               }
               else
               {
               	swal_btn2_copy.click();
               }           }
          },
          error: function(data) 
          {
            alert("error");
          }           

        });                
              return false; // extra insurance preventing the default form action
            }
          });

     $("#regForm2").validate({
      rules: 
      {
        photo_pages: {
          required: true
        },
      },
      messages: 
      {
      },
      submitHandler: function(form) 
      {
        var l = $( '.ladda-button-demo' ).ladda();
        l.ladda( 'start' );

        var photo= document.getElementById('photo_pages').files[0];

        var formData = new FormData();
        formData.append("book_id", bk_id);
        formData.append("photo", photo);


        $.ajax
        ({
          type:'POST',
          url:"https://maktabty.org/Maktabti/api/BooksImages",
          data: formData,
          contentType: false,
          cache: false,
          processData:false,
          success: function(data)
          {
            if( data.status == "success")
            {
              l.ladda('stop');
              $('#add_book_image').attr('src', 'img/plus_icon.png');
              viewBook();
            }
            else if( data.status == "failed" )
            {
              l.ladda('stop');
              errorMessage = data.error;
               if (radio_val == "English")
               {
               	swal_btn2.click();
               }
               else
               {
               	swal_btn2_copy.click();
               }
            }
          },
          error: function(data) 
          {
           l.ladda('stop');
            alert("error");
          }           

        });                
              return false; // extra insurance preventing the default form action
            }
          });


    $('#swal_btn').click(function(){
      swal({
        title: "Success",
        text: "Your book has been Added successfully",
        type: "success",
        confirmButtonColor: "#566b8a",
      });
    });
    
    $('#swal_btn_copy').click(function(){
      swal({
        title: "نجاح",
        text: "تمت إضافة كتابك بنجاح",
        type: "success",
        confirmButtonColor: "#566b8a",
      });
    });

    $('#swal_btn2').click(function(){
      swal({
       title: "Operation Unsuccessfull!",
       text: errorMessage,
       type: "warning",
       confirmButtonColor: "#DD6B55",
     });
    });
    
    $('#swal_btn2_copy').click(function(){
      swal({
       title: "عملية غير ناجحة!",
       text: errorMessage,
       type: "warning",
       confirmButtonColor: "#DD6B55",
     });
    });
    
    
    $('#swal_btn3').click(function(){
      swal({
        title: "Deleted",
        text: "Your book image has been deleted",
        type: "success",
        confirmButtonColor: "#566b8a",
      });
    });  
    
    $('#swal_btn3_copy').click(function(){
      swal({
        title: "تم الحذف",
        text: "تم حذف صورة كتابك",
        type: "success",
        confirmButtonColor: "#566b8a",
      });
    });    
    
  });
  
    function viewBook()
    {    
        $.ajax({
            url: "https://maktabty.org/Maktabti/api/ItemView",
            type: "POST",
            data: {"book_id" : bk_id},
            success: function(data)
            {   
                var count = 1;
                //var dat = jQuery.parseJSON(data);
                if ( data.status == "success")
                {
                    $.each(data.data, function(index,obj) 
                    {
                        book_images_array = obj.images;                                          
                    });
                    viewBookModal();
                }
                else
                {
                	if (radio_val == "English")
	                {
	               		swal_btn.click();
	                }
	                else
	                {
	               		swal_btn_copy.click();
	                }
                }
            },
            error: function(data)
            {
            }           
        });        
    }
    
    	function viewBookModal()
	{
		var $list = $('#uploaded_img_div');
		$list.empty();
		if( book_images_array.length > 0 )
		{
			$.each(book_images_array, function(index,obj) 
	           	{
	           		$list.append('<div class="col-sm-3 col-xs-6" style="margin-bottom:10px">'+       			 				
    			 				'<label style="position: fixed;margin-left:5px;margin-top: 2px;">'+                            					
                            					'<i class="fa fa-trash" id="'+obj.bk_im_id+'" onclick ="deleteImage(this.id);" style="font-size:20px;color:red"></i>'+
                            				'</label>'+ 		
							'<img src="https://maktabty.org/Maktabti/public/'+obj.image+'" style="width:100%; height:100px">'+
						'</div>');	    
			});
		}
		
	}
	
	function deleteImage(id)
	{
	    $.ajax({
            url: "https://maktabty.org/Maktabti/api/BooksImagesDelete",
            type: "POST",
            data: { "img_id" : id },
            success: function(data)
            {   
                if ( data.status == "success")
                {
                	if (radio_val == "English")
	                {
	               		swal_btn3.click();
	                }
	                else
	                {
	               		swal_btn3_copy.click();
	                }
                	viewBook();
                }
                else
                {
                    alert("Book not Deleted");
                }
            },
            error: function(data)
            {
            }           
        });
	}


 function viewCategories()
    {
        var $list = $("#category_list");
        $list.empty();
        $.ajax({
            url: "https://maktabty.org/Maktabti/api/CategoryView",
            type: "POST",
            success: function(data)
            {   
                if ( data.status == "success")
                {
                    $list.append('<option value="select">Choose a Category</option>');
                    $.each(data.data, function(index,obj) 
                    {
                        $list.append('<option value="'+obj.category_name+'">'+obj.category_name+'</option>');
                    });
                }
                else
                {
                	if (radio_val == "English")
			{
				swal_btn.click();
			}
			else
			{
				swal_btn_copy.click();
			}
                }
            },
            error: function(data)
            {
            }           
        });        
    }

</script>

<script>
function fixStepIndicator(n) {
// This function removes the "active" class of all steps...
var i, x = document.getElementsByClassName("step");
for (i = 0; i < x.length; i++) {
  x[i].className = x[i].className.replace(" active", "");
}
//... and adds the "active" class on the current step:
x[n].className += " active";
}
</script>

<script>
  function readURL(input) {
    if (input.files && input.files[0]) {
      var reader = new FileReader();

      reader.onload = function (e) {
        $('#blah')
        .attr('src', e.target.result)
        .width(150)
        .height(150);
      };

      reader.readAsDataURL(input.files[0]);
    }
  }
  
  function readURL2(input) {
    if (input.files && input.files[0]) {
      var reader = new FileReader();

      reader.onload = function (e) {
        $('#add_book_image')
        .attr('src', e.target.result);
      };

      reader.readAsDataURL(input.files[0]);
    }
  }
</script>
</body>
</html>
