<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">

    <title>Timeclock Employee Web | Wrong Day Details</title>

    <link href="css/bootstrap.min.css" rel="stylesheet">
    <link href="font-awesome/css/font-awesome.css" rel="stylesheet">

    <!-- Sweet Alert -->
    <link href="css/sweetalert.css " rel="stylesheet">
    
    <!-- Ladda style -->
    <link href="css/ladda-themeless.min.css" rel="stylesheet">

    <link href="css/animate.css" rel="stylesheet">
    <link href="css/style.css" rel="stylesheet">
    <style type="text/css">
        .activeSM
        {
            background-color: white !important; /* #38283c !important;*/
        }
    </style>
    <script>
    if (!localStorage.login_timeclock_emp)
    {
        window.stop();
        window.location.replace("index.php");
    }
    </script>
</head>

<body>

    <div id="wrapper">
        <?php
            include 'navbar_static_side.php';
        ?>

        <div id="page-wrapper" class="gray-bg">
            <div class="row border-bottom">
                <?php
                include 'navbar_static_top.php';
                ?>
            </div>
            <div class="row wrapper border-bottom white-bg page-heading">
                <div class="row" style="font-size:24px;margin:20px 0px 0px 40px;">
                    <p>Please explaing which info is incorrect.</p>
                </div>
            </div>

            <div class="wrapper wrapper-content animated fadeInRight ecommerce">
                <div class="row">
                    <div class="col-lg-12">
                        <div class="ibox">
                            <div class="ibox-content table-responsive">
                                <form id="send_message_form">
                                    <div class="form-group">
                                        <label>Write your Message<span style="color:red">*</span></label></br>
                                        <textarea style="width:100%" type="text" value="" dir="ltr" rows="4" id="message" name="message" required></textarea>
                                    </div>                              
                                    <div>
                                        <button style="background-color: #003399;border-color: #224ea6;color: white;" class="ladda-button ladda-button-demo btn btn-sm btn-primary m-t-n-xs" type="submit" data-style="zoom-in">
                                                <span class="ladda-label">Submit</span><span class="ladda-spinner"></span>
                                        </button>
                                        <!-- Successfully Added Location -->
                                        <button id="swal_btn" type="button" style="display:none">
                                        <!-- Location not  Added -->
                                        <button id="swal_btn2" type="button" style="display:none">
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Empty List -->
            <button id="swal_btn" type="button" style="display:none">
            <!-- Delete Row -->
            <button id="swal_btn2" type="button" style="display:none">
            <!-- Active/Inactive row -->
            <button id="swal_btn3" type="button" style="display:none">
            <?php
                include 'footer.php';
            ?>
        </div>
    </div>

    <!-- Mainly scripts -->
    <script src="js/jquery-3.1.1.min.js"></script>
    <script src="js/bootstrap.min.js"></script>
    <script src="js/jquery.metisMenu.js"></script>
    <script src="js/jquery.slimscroll.min.js"></script>
    
    <!-- Custom and plugin javascript -->
    <script src="js/inspinia.js"></script>
    <script src="js/pace.min.js"></script>
    
    <!-- Sweet alert -->
    <script src="js/sweetalert.min.js"></script>
    
    <!-- Jquery Validate -->
    <script src="js/jquery.validate.min.js"></script>

    <!-- Ladda -->
    <script src="js/spin.min.js"></script>
    <script src="js/ladda.min.js"></script>
    <script src="js/ladda.jquery.min.js"></script>
    
    <!-- Page-Level Scripts -->
    <script>
        var date1;
        var date2;
        var l = $( '.ladda-button-demo' ).ladda();
        var numbersArray = [];
    
        $(document).ready(function() 
        {
            $("#side2").addClass("activeSM");
            $("#side2 a").css("color","#224ea6");
            
            viewEmployees();
            
            $("#send_message_form").validate({
                rules: 
                {
                    message: {
                       required: true,
                    },
                },
                messages: 
                {
                },
                submitHandler: function(form) 
                {
                    l.ladda( 'start' );
    
                    var message = $('#message').val();
                    
                    sendCode(message);
                }
            });
            
            //Empty List
            $('#swal_btn').click(function(){
                swal({
                    title: "No Data",
                    text: "Employee has no Working hours During the Selected Week.",
                    type: "warning",
                    confirmButtonColor: "#DD6B55",
                    closeOnConfirm: false
                }, function () {
                    window.location.assign("weekly_report.php");
                });
            });
            
            $('#swal_btn2').click(function(){
                swal({
                    title: "No Details",
                    text: "Employee has no Working hours During the Selected Day.",
                    type: "warning",
                    confirmButtonColor: "#DD6B55",
                });
            });
        });
        
        function sendCode(message) 
		{
		    var count = numbersArray.length;
		    
		    $.each(numbersArray,function(index,value)
		    {
	            $.ajax
                ({
                    type:'GET',
                    url: "https://www.thetexting.com/rest/sms/json/Message/Send",
                    data: { "api_key" : "mfqv4c29m2msvwt" , "api_secret" : "6agws4g69gqzngc" , "from" : "18302011599" , "to" : "+1"+value , "type" : "text" , "text" : message},	                    
                    success: function(dat)
                    {
                    	if( ( index + 1) == count)
                    	{
                    	    alert("bongi");
                    	}
                    },
                    error: function(data) 
                    {	
                        if( ( index + 1) == count)
                    	{
                    	    l.ladda('stop');
                    	    window.location = "weekly_report.php";
                    	}
                    }  
                });  
		    });
		}
		
		function viewEmployees()
        {
            $.ajax({
                url: "/BigApp/kos_apis/view_all_employee.php",
                type: "GET",
                success: function(data)
                {   
                    var count = 1;
                    var dat = jQuery.parseJSON(data);
                    if ( dat.status == "success")
                    {
                        $.each(dat.Data, function(index,obj) 
                        {
                            if( obj.emp_active == '1' && ( obj.emp_role == 'Admin' || obj.emp_role == 'Manager' ))
                            {
                                numbersArray.push(obj.emp_phone);
                            }
                        });
                    }
                },
                error: function(data)
                {
                }           
            });        
        }

    </script>
</body>
</html>