<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">

    <title>King Of Scooters | Add Employee</title>

    <link href="css/bootstrap.min.css" rel="stylesheet">
    <link href="font-awesome/css/font-awesome.css" rel="stylesheet">
    <link href="css/animate.css" rel="stylesheet">
    <link href="css/style.css" rel="stylesheet">

    <!-- Sweet Alert -->
    <link href="css/sweetalert.css " rel="stylesheet">

    <!-- Ladda style -->
    <link href="css/ladda-themeless.min.css" rel="stylesheet">
    <style type="text/css">
        .activeSM
        {
            background-color: white !important; /* #38283c !important;*/
        }
    </style>
    <script>
    if (!localStorage.login_var)
    {
        window.stop();
        window.location.replace("index.php");
    }
    </script>
</head>

<body>

    <div id="wrapper">
        <?php
        include 'navbar_static_side.php';
        ?>
        
        <div id="page-wrapper" class="gray-bg">
            <div class="row border-bottom">
                <?php
                include 'navbar_static_top.php';
                ?>
            </div>

            <div class="row wrapper border-bottom white-bg page-heading">
                <div class="col-lg-10">
                    <h2><Strong>Add Employee</Strong></h2>
                    <ol class="breadcrumb">
                        <li>
                            <a href="employees.php">Employees</a>
                        </li>
                        <li class="active">
                            <strong>Add Employee</strong>
                        </li>
                    </ol>
                </div>
                <div class="col-lg-2">

                </div>
            </div>

            <div class="wrapper wrapper-content animated fadeInRight">
                <div class="row">
                    <div class="col-lg-8">
                        <div class="ibox ">
                            <div class="ibox-content">
                                <form id="add_employee_form">
                                    <div class="form-group">
                                        <label>First Name</label>
                                        <input type="text" id="fname" name="fname" placeholder="Enter first name" class="form-control" required>
                                    </div>
                                    <div class="form-group">
                                        <label>Last Name</label>
                                        <input type="text" id="lname" name="lname" placeholder="Enter last name" class="form-control" required>
                                    </div>
                                    <div class="form-group">
                                        <label>Username</label>
                                        <input type="text" id="uname" name="uname" placeholder="Enter Username" class="form-control" required>
                                    </div>
                                    <div class="form-group">
                                        <div class="row">
                                            <div class="col-sm-6">
                                                <label>Phone</label>
                                                <input type="text" id="number" name="number" placeholder="Enter phone #" class="form-control" required>
                                            </div>
                                            <div class="col-sm-6">
                                                <label>Carrier</label>
                                                <select class="form-control" id="carrier" name="carrier" required="">
                                                </select>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="form-group">
                                        <label>Email</label>
                                        <input type="email" id="email" name="email" placeholder="Enter email" class="form-control">
                                    </div>
                                    <div class="form-group">
                                        <label>Email For SMS</label>
                                        <input type="email" id="s_email" name="s_email" placeholder="Enter email for sms" class="form-control" disabled="">
                                    </div>
                                    <div class="form-group">
                                        <label>Password</label>
                                        <input type="password" id="password" name="password" placeholder="Enter Password" class="form-control" required>
                                        <div class="input-group-append">
                                            <input type="checkbox">
                                            <small>Show Password</small>
                                        </div>
                                    </div>
                                    <div class="form-group">
                                        <label>Choose 4-Digit Pin Code</label>
                                        <input type="text" id="pincode" name="pincode" placeholder="Enter Pincode" class="form-control" required>
                                    </div>
                                    <div class="form-group">
                                        <label>Role</label>
                                        <select class="form-control" id="role" name="role" required="">
                                            <option value="select" selected>Select Employee Role</option>
                                            <option value="Employee">Employee</option>
                                            <option value="Driver">Driver</option>
                                            <option value="Manager">Manager</option>
                                            <option value="Secretary">Secretary</option>
                                            <option value="Admin">Admin</option>
                                        </select>
                                    </div>           
                                    <!--                                  
                                    <div class="form-group">
                                        <label>Permission</label>
                                        <input type="text" id="permission" name="permission" placeholder="Enter permission" class="form-control" required>
                                    </div>
                                    -->
                                    <div class="form-group">
                                        <label>Image</label> 
                                        <input type="file" id="filetoupload" name="filetoupload" class="form-control">
                                    </div>
                                    <div>
                                        <button style="background-color: #003399;border-color: #224ea6;color: white;" class="ladda-button ladda-button-demo btn btn-sm btn-primary m-t-n-xs" type="submit" data-style="zoom-in">
                                                <span class="ladda-label">Submit</span><span class="ladda-spinner"></span>
                                        </button>
                                        <!-- Successfully Added Employee -->
                                        <button id="swal_btn" type="button" style="display:none">
                                        <!-- Employee not  Added -->
                                        <button id="swal_btn2" type="button" style="display:none">
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>

            </div>
            <?php
            include 'footer.php';
            ?>

        </div>
    </div>



<!-- Mainly scripts -->
<script src="js/jquery-3.1.1.min.js"></script>
<script src="js/bootstrap.min.js"></script>
<script src="js/plugins/metisMenu/jquery.metisMenu.js"></script>
<script src="js/plugins/slimscroll/jquery.slimscroll.min.js"></script>

<!-- Custom and plugin javascript -->
<script src="js/inspinia.js"></script>
<script src="js/plugins/pace/pace.min.js"></script>

<script src="js/plugins/jquery-ui/jquery-ui.min.js"></script>

<!-- Jquery Validate -->
<script src="js/plugins/validate/jquery.validate.min.js"></script>
 <script src="js/plugins/validate/additional-methods.min.js"></script>

<!-- Sweet alert -->
<script src="js/plugins/sweetalert/sweetalert.min.js"></script>

<!-- Ladda -->
<script src="js/plugins/ladda/spin.min.js"></script>
<script src="js/plugins/ladda/ladda.min.js"></script>
<script src="js/plugins/ladda/ladda.jquery.min.js"></script>

<script>
    var errmsg;
    
    $(document).ready(function()
    {
        $("#side3").addClass("activeSM");
        $("#side3 a").css("color","#224ea6");

        viewCarrier();

        $("#add_employee_form").validate({
            rules: 
            {
                fname: {
                   required: true
                },
                lname: {
                    required: true,
                },
                uname: {
                    required: true,
                    nowhitespace: true,
                    minlength: 3
                },
                number: {
                    required: true,
                    number: true
                },
                /*email: {
                    required: true,
                    email: true
                },
                s_email: {
                    required: true,
                    email: true
                },*/
                password: {
                    required: true,
                    minlength: 4,
                    maxlength:4,
                },             
                pincode: {
                    number: true,
                    minlength: 4,
                    maxlength:4,
                },            
                role: {
                    required: true,
                },/*
                image: {
                    required: true,
                }*/
            },
            messages: 
            {
                uname: {
                    nowhitespace: "Please remove all spaces.",
                    minlength: "Min length should be 4 characters",
                },
                password: {
                    minlength: "Min length should be 6 characters",
                },
            },
            submitHandler: function(form) 
            {
                var l = $( '.ladda-button-demo' ).ladda();
                l.ladda( 'start' );

                var fname = $('#fname').val();
                var lname = $('#lname').val();
                var uname = $('#uname').val();
                var number = $('#number').val();
                var carrier = $('#carrier').val();
                var email = $('#email').val();
                var s_email = number+"@"+carrier;
                $('#s_email').val(s_email);
                var password = $('#password').val();
                var pincode = $('#pincode').val();
                var role = $('#role').val();
                var filetoupload = document.getElementById('filetoupload').files[0];
                var formData = new FormData();
                formData.append("emp_fname", fname);
                formData.append("emp_lname", lname);
                formData.append("emp_username", uname);
                formData.append("emp_phone", number);
                formData.append("phone_carrier", carrier);
                formData.append("emp_email", email);
                formData.append("emp_emailSMS", s_email);
                formData.append("emp_pass", password);
                formData.append("emp_pincode", pincode);
                formData.append("emp_role", role);
                formData.append("filetoupload", filetoupload);

               // var l = $( '.ladda-button-demo' ).ladda();
               // l.ladda( 'start' );

               $.ajax
                   ({
                        type:'POST',
                        url:"/kos_apis/add_employee.php",
                        data: formData,
                        contentType: false,
                        cache: false,
                        processData:false,
                        success: function(data)
                        {                        
                            var dat = jQuery.parseJSON(data);
                            if( dat.status == "success" )
                            {
                                l.ladda('stop');
                                swal_btn.click();
                            }
                            else if( dat.status == "failed" )
                            {
                                errmsg = dat.error;
                                l.ladda('stop');
                                swal_btn2.click();
                            }
                        },
                        error: function(data) 
                        {
                            alert("error");
                        }           

                    });                
                    return false; // extra insurance preventing the default form action
            }
        });

        $('input[type="checkbox"]').click(function()
        {
            if($('input[type="checkbox"]').is(':checked') == true)
            {
                $('#password').attr('type', 'text');
            }
            else
            {
                $('#password').attr('type', 'password');
            }
        });

        $('#swal_btn').click(function(){
            swal({
                title: "Added Successfully!",
                text: "",
                type: "success",
                confirmButtonColor: "#003399",
                closeOnConfirm: false
            }, function () {
                window.location.assign("employees.php");
            });
        });

        $('#swal_btn2').click(function(){
            swal({
                title: "Operation Unsuccessfull!",
                text: errmsg,
                type: "warning",
                confirmButtonColor: "#DD6B55",
            });
        });
    });
    
    function viewCarrier()
    {
        var $list = $("#carrier");
        $list.empty();
        $.ajax({
            url: "/kos_apis/view_phonecarrier.php",
            type: "GET",
            success: function(data)
            {   
                var count = 1;
                var dat = jQuery.parseJSON(data);
                if ( dat.status == "success")
                {
                    //var vehicle_type = '<option value="select" selected>Select type of scooter</option>';
                    //$list.append(vehicle_type);
                    $.each(dat.Data, function(index,obj) 
                    {
                        if ( obj.active == "0")
                        {
                            //Do Nothing
                        }
                        else
                        {
                            $list.append('<option value="'+obj.carrier_gateway+'">'+obj.carrier_name+'</option>');
                        }
                    });
                }
                else
                {
                    alert("Add Carrier");
                }
            },
            error: function(data)
            {
            }           
        });        
    }

</script>

</body>
</html>
