<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">

    <title>King Of Scooters | Add Location</title>

    <link href="css/bootstrap.min.css" rel="stylesheet">
    <link href="font-awesome/css/font-awesome.css" rel="stylesheet">
    <link href="css/animate.css" rel="stylesheet">
    <link href="css/style.css" rel="stylesheet">

    <!-- Sweet Alert -->
    <link href="css/sweetalert.css " rel="stylesheet">

    <!-- Ladda style -->
    <link href="css/ladda-themeless.min.css" rel="stylesheet">
    <style type="text/css">
        .activeSM
        {
            background-color: white !important; /* #38283c !important;*/
        }
    </style>
    <script>
    if (!localStorage.login_var)
    {
        window.stop();
        window.location.replace("index.php");
    }
    </script>
</head>

<body>
    <div id="wrapper">
        <?php
        include 'navbar_static_side.php';
        ?>
        
        <div id="page-wrapper" class="gray-bg">
            <div class="row border-bottom">
                <?php
                include 'navbar_static_top.php';
                ?>
            </div>

            <div class="row wrapper border-bottom white-bg page-heading">
                <div class="col-lg-10">
                    <h2><Strong>Add Location</Strong></h2>
                    <ol class="breadcrumb">
                        <li>
                            <a href="locations.php">Locations</a>
                        </li>
                        <li class="active">
                            <strong>Add Location</strong>
                        </li>
                    </ol>
                </div>
                <div class="col-lg-2">

                </div>
            </div>

            <div class="wrapper wrapper-content animated fadeInRight">
                <div class="row">
                    <div class="col-lg-8">
                        <div class="ibox ">
                            <div class="ibox-content">
                                <form id="add_location_form">
                                    <div class="form-group">
                                        <label>Location Name</label>
                                        <input type="text" id="location_name" name="location_name" placeholder="Enter location name" class="form-control" required>
                                    </div>
                                    <div class="form-group">
                                        <label>Location Type</label>
                                        <select class="form-control" id="location_type" name="location_type" required="">
                                            <option value="Simple" selected>Simple</option>
                                            <option value="Truck">Truck</option>
                                        </select>
                                    </div>
                                    <div class="form-group">
                                        <label>Location Password</label>
                                        <input type="password" id="location_password" name="location_password" placeholder="Enter location password" class="form-control" required>
                                        <div class="input-group-append">
                                            <input type="checkbox">
                                            <small>Show Password</small>
                                        </div>
                                    </div>                                    
                                    <div>
                                        <button style="background-color: #003399;border-color: #224ea6;color: white;" class="ladda-button ladda-button-demo btn btn-sm btn-primary m-t-n-xs" type="submit" data-style="zoom-in">
                                                <span class="ladda-label">Submit</span><span class="ladda-spinner"></span>
                                        </button>
                                        <!-- Successfully Added Location -->
                                        <button id="swal_btn" type="button" style="display:none">
                                        <!-- Location not  Added -->
                                        <button id="swal_btn2" type="button" style="display:none">
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <?php
            include 'footer.php';
            ?>
        </div>
    </div>



    <!-- Mainly scripts -->
    <script src="js/jquery-3.1.1.min.js"></script>
    <script src="js/bootstrap.min.js"></script>
    <script src="js/plugins/metisMenu/jquery.metisMenu.js"></script>
    <script src="js/plugins/slimscroll/jquery.slimscroll.min.js"></script>

    <!-- Custom and plugin javascript -->
    <script src="js/inspinia.js"></script>
    <script src="js/plugins/pace/pace.min.js"></script>

    <script src="js/plugins/jquery-ui/jquery-ui.min.js"></script>

    <!-- Sweet alert -->
    <script src="js/plugins/sweetalert/sweetalert.min.js"></script>

    <!-- Jquery Validate -->
    <script src="js/plugins/validate/jquery.validate.min.js"></script>

    <!-- Ladda -->
    <script src="js/plugins/ladda/spin.min.js"></script>
    <script src="js/plugins/ladda/ladda.min.js"></script>
    <script src="js/plugins/ladda/ladda.jquery.min.js"></script>

    <script>
    $(document).ready(function()
    {
        $("#side2").addClass("activeSM");
        $("#side2 a").css("color","#224ea6");

        $("#add_location_form").validate({
            rules: 
            {
                location_name: {
                   required: true
                },
                location_password: {
                    required: true,
                    minlength: 4,
                    maxlength: 4
                },
            },
            messages: 
            {
            },
            submitHandler: function(form) 
            {
                var l = $( '.ladda-button-demo' ).ladda();
                l.ladda( 'start' );

                var location_name = $('#location_name').val();
                var location_password = $('#location_password').val();
                var location_type = $('#location_type').val();

                var formData = new FormData();
                formData.append("location_name", location_name);
                formData.append("location_pass", location_password);
                formData.append("location_type", location_type);
                                    
                $.ajax
                ({
                    type:'POST',
                    url:"/kos_apis/add_location.php",
                    data: formData,
                    contentType: false,
                    cache: false,
                    processData:false,
                    success: function(data)
                    {                        
                        var dat = jQuery.parseJSON(data);
                        if( dat.status == "success" )
                        {
                            l.ladda('stop');
                            swal_btn.click();
                        }
                        else if( data.status == "failed" )
                        {
                            l.ladda('stop');
                            swal_btn2.click();
                        }
                    },
                    error: function(data) 
                    {
                        alert("error");
                    }           

                });                
                return false; // extra insurance preventing the default form action
            }
        });

        $('#swal_btn').click(function(){
            swal({
                title: "Added Successfully!",
                text: "",
                type: "success",
                confirmButtonColor: "#003399",
                closeOnConfirm: false
            }, function () {
                window.location.assign("locations.php");
            });
        });

        $('#swal_btn2').click(function(){
            swal({
                 title: "Operation Unsuccessfull!",
                text: "Location not Added.",
                type: "warning",
                confirmButtonColor: "#DD6B55",
            });
        });
        
        $('input[type="checkbox"]').click(function()
        {
            if($('input[type="checkbox"]').is(':checked') == true)
            {
                $('#location_password').attr('type', 'text');
            }
            else
            {
                $('#location_password').attr('type', 'password');
            }
        });

    });
</script>

</body>
</html>
