<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">

    <title>King Of Scooters | Calendar Min Prices</title>

    <link href="css/bootstrap.min.css" rel="stylesheet">
    <link href="font-awesome/css/font-awesome.css" rel="stylesheet">

    <!-- FooTable -->
    <link href="css/plugins/footable/footable.core.css" rel="stylesheet">

    <!-- Sweet Alert -->
    <link href="css/sweetalert.css " rel="stylesheet">

    <link href="css/animate.css" rel="stylesheet">
    <link href="css/style.css" rel="stylesheet">
    <style type="text/css">
        .activeSM
        {
            background-color: white !important; /* #38283c !important;*/
        }
    </style>
</head>

<body>

    <div id="wrapper">
        <?php
        include 'navbar_static_side.php';
        ?>

        <div id="page-wrapper" class="gray-bg">
            <div class="row border-bottom">
                <?php
                include 'navbar_static_top.php';
                ?>
            </div>
            <div class="row wrapper border-bottom white-bg page-heading">
                <div class="col-lg-10">
                    <h2><strong>Calendar Min Prices</strong></h2>
                    <a href="add_calendar_min_price.php">
                        <button type="button" class="btn btn-default btn-sm">
                            <span class="glyphicon glyphicon-plus"></span> Add Calendar Min Price
                        </button>
                    </a>
                </div>
                <div class="col-lg-2">

                </div>
            </div>

            <div class="wrapper wrapper-content animated fadeInRight ecommerce">
                <div class="row">
                    <div class="col-lg-12">
                        <div class="ibox">
                            <div class="ibox-content table-responsive">
                                <table class="footable table table-stripped toggle-arrow-tiny" data-page-size="15">
                                    <thead>
                                        <tr>
                                            <th>SNo</th>
                                            <th>Vehicle Type</th>
                                            <th>From Date</th>
                                            <th>To Date</th>
                                            <th>Fixed Hours</th>
                                            <th>Fixed Hours Price ($)</th>
                                            <th>Over Night (24hrs Format)</th>
                                            <th>Over Night Price ($)</th>
                                            <th>Fixed Days</th>
                                            <th>Fixed Days Price ($)</th>
                                            <th>Location</th>
                                            <th>Status</th>
                                            <th>Action</th>
                                        </tr>
                                    </thead>
                                    <tbody id="calendar_min_price_list">
                                       <!-- Dynamically appending Calendar Min Price List List -->
                                    </tbody>
                                    <tfoot>
                                        <tr>
                                            <td colspan="6">
                                                <ul class="pagination pull-right"></ul>
                                            </td>
                                        </tr>
                                    </tfoot>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Empty List -->
            <button id="swal_btn" type="button" style="display:none">
            <!-- Delete Row -->
            <button id="swal_btn2" type="button" style="display:none">
            <!-- Active/Inactive row -->
            <button id="swal_btn3" type="button" style="display:none">

            <?php
            include 'footer.php';
            ?>

        </div>
    </div>



<!-- Mainly scripts -->
<script src="js/jquery-3.1.1.min.js"></script>
<script src="js/bootstrap.min.js"></script>
<script src="js/plugins/metisMenu/jquery.metisMenu.js"></script>
<script src="js/plugins/slimscroll/jquery.slimscroll.min.js"></script>

<!-- Custom and plugin javascript -->
<script src="js/inspinia.js"></script>
<script src="js/plugins/pace/pace.min.js"></script>

<!-- Sweet alert -->
<script src="js/plugins/sweetalert/sweetalert.min.js"></script>

<!-- FooTable -->
<script src="js/plugins/footable/footable.all.min.js"></script>

 <!-- Page-Level Scripts -->
<script>
    var delete_calMinPrice;

    $(document).ready(function() 
    {
        $("#side6").addClass("activeSM");
        $("#side6 a").css("color","#224ea6");

        viewCalendarMinPriceList();
        //Empty List
        $('#swal_btn').click(function(){
            swal({
                 title: "List is Empty!",
                text: "Please add Calendar Min Price List.",
                type: "warning",
                confirmButtonColor: "#DD6B55",
                closeOnConfirm: false
            }, function () {
                window.location.assign("add_calendar_min_price.php");
            });
        });

        //Delete Row
        $('#swal_btn2').click(function(){
            swal({
                title: "Calendar Min Price List Row Deleted!",
                text: "",
                type: "success",
                confirmButtonColor: "#DD6B55",
            });
        });

        //Active Row
        $('#swal_btn3').click(function(){
            swal({
                 title: "Activated/Deactivated",
                text: "Calendar Min Price Activated/Deactivated Successfully.",
                type: "success",
                confirmButtonColor: "#003399",
            });
        });
    });

    function viewCalendarMinPriceList()
    {
        var $list = $("#calendar_min_price_list");
        $list.empty();
        $.ajax({
            url: "/kos_apis/view_all_cal_price.php",
            type: "GET",
            success: function(data)
            {   
                var count = 1;
                var dat = jQuery.parseJSON(data);
                if ( dat.status == "success")
                {
                    $.each(dat.Data, function(index,obj) 
                    {
                        //Extracting Fixed Hours
                        var tempFixedHours1 = obj.fixed_hours;
                        var tempFixedHours2 = tempFixedHours1.split(',');

                        var tempFixedHours3  = tempFixedHours2[0].split(':');
                        var tempFixedHours31 = tempFixedHours2[1].split(':');
                        var tempFixedHours32 = tempFixedHours2[2].split(':');

                        //Extracting Overnight
                        var tempOverNight1 = obj.over_night;
                        var tempOverNight2 = tempOverNight1.split(',');

                        var tempOverNight3  = tempOverNight2[0].split(':');
                        var tempOverNight31 = tempOverNight2[1].split(':');
                        var tempOverNight32 = tempOverNight2[2].split(':');

                        //Extracting Fixed Days
                        var tempFixedDays1 = obj.fixed_days;
                        var tempFixedDays2 = tempFixedDays1.split(',');

                        var tempFixedDays3  = tempFixedDays2[0].split(':');
                        var tempFixedDays31 = tempFixedDays2[1].split(':');
                        var tempFixedDays32 = tempFixedDays2[2].split(':');
                        var tempFixedDays33 = tempFixedDays2[3].split(':');
                        var tempFixedDays34 = tempFixedDays2[4].split(':');
                        var tempFixedDays35 = tempFixedDays2[5].split(':');
                        var tempFixedDays36 = tempFixedDays2[6].split(':');

                        if( obj.active == '0')
                        {
                            var status = '<span id="'+obj.cp_id+'" onclick ="statusChange(this.id);" class="label label-danger">Inactive</span>';
                        }
                        else
                        {
                            var status = '<span id="'+obj.cp_id+'" onclick ="statusChange(this.id);" class="label label-primary">Active</span>';
                        }


                        $list.append('<tr>'+
                                        '<td><strong>'+count+'</strong></td>'+
                                        '<td>'+obj.vehicle_type+'</td>'+
                                        '<td>'+obj.from_date+'</td>'+
                                        '<td>'+obj.to_date+'</td>'+

                                        '<td>'+tempFixedHours3[0]+'</td>'+
                                        '<td>'+tempFixedHours3[1]+'</td>'+
                                        '<td>'+tempOverNight3[0]+'</td>'+
                                        '<td>'+tempOverNight3[1]+'</td>'+
                                        '<td>'+tempFixedDays3[0]+'</td>'+
                                        '<td>'+tempFixedDays3[1]+'</td>'+
                                        '<td>'+obj.location_name+'</td>'+
                                        '<td>'+status+'</td>'+
                                        '<td>'+
					                       '<div class="btn-group">'+
                                                '<button id="'+obj.cp_id+'" onclick ="saveCalendarMinPrice(this.id);" class="btn-white btn btn-xs">Edit</button>'+
                                                '<button id="'+obj.cp_id+'" onclick ="deleteCalendarMinPrice(this.id);" class="btn-white btn btn-xs">Delete</button>'+
                                            '</div>'+
                                        '</td>'+
                                    '</tr>');
                        $list.append('<tr>'+
                                        '<td></td>'+
                                        '<td></td>'+
                                        '<td></td>'+
                                        '<td></td>'+

                                        '<td>'+tempFixedHours31[0]+'</td>'+
                                        '<td>'+tempFixedHours31[1]+'</td>'+
                                        '<td>'+tempOverNight31[0]+'</td>'+
                                        '<td>'+tempOverNight31[1]+'</td>'+
                                        '<td>'+tempFixedDays31[0]+'</td>'+
                                        '<td>'+tempFixedDays31[1]+'</td>'+
                                        '<td></td>'+
                                        '<td></td>'+
                                    '</tr>');
                        $list.append('<tr>'+
                                        '<td></td>'+
                                        '<td></td>'+
                                        '<td></td>'+
                                        '<td></td>'+

                                        '<td>'+tempFixedHours32[0]+'</td>'+
                                        '<td>'+tempFixedHours32[1]+'</td>'+
                                        '<td>'+tempOverNight32[0]+'</td>'+
                                        '<td>'+tempOverNight32[1]+'</td>'+
                                        '<td>'+tempFixedDays32[0]+'</td>'+
                                        '<td>'+tempFixedDays32[1]+'</td>'+
                                        '<td></td>'+
                                        '<td></td>'+
                                    '</tr>');
                        $list.append('<tr>'+
                                        '<td></td>'+
                                        '<td></td>'+
                                        '<td></td>'+
                                        '<td></td>'+

                                        '<td></td>'+
                                        '<td></td>'+
                                        '<td></td>'+
                                        '<td></td>'+
                                        '<td>'+tempFixedDays33[0]+'</td>'+
                                        '<td>'+tempFixedDays33[1]+'</td>'+
                                        '<td></td>'+
                                        '<td></td>'+
                                    '</tr>');
                        $list.append('<tr>'+
                                        '<td></td>'+
                                        '<td></td>'+
                                        '<td></td>'+
                                        '<td></td>'+

                                        '<td></td>'+
                                        '<td></td>'+
                                        '<td></td>'+
                                        '<td></td>'+
                                        '<td>'+tempFixedDays34[0]+'</td>'+
                                        '<td>'+tempFixedDays34[1]+'</td>'+
                                        '<td></td>'+
                                        '<td></td>'+
                                    '</tr>');
                        $list.append('<tr>'+
                                        '<td></td>'+
                                        '<td></td>'+
                                        '<td></td>'+
                                        '<td></td>'+

                                        '<td></td>'+
                                        '<td></td>'+
                                        '<td></td>'+
                                        '<td></td>'+
                                        '<td>'+tempFixedDays35[0]+'</td>'+
                                        '<td>'+tempFixedDays35[1]+'</td>'+
                                        '<td></td>'+
                                        '<td></td>'+
                                    '</tr>');
                        $list.append('<tr>'+
                                        '<td></td>'+
                                        '<td></td>'+
                                        '<td></td>'+
                                        '<td></td>'+

                                        '<td></td>'+
                                        '<td></td>'+
                                        '<td></td>'+
                                        '<td></td>'+
                                        '<td>'+tempFixedDays36[0]+'</td>'+
                                        '<td>'+tempFixedDays36[1]+'</td>'+
                                        '<td></td>'+
                                        '<td></td>'+
                                    '</tr>');

                       
                        count++;
                    });
                }
                else
                {
                    swal_btn.click();
                }
            },
            error: function(data)
            {
            }           
        });        
    }

    function deleteCalendarMinPrice(id)
    {
        var cp_id= id;
        $.ajax({            
            url: "/kos_apis/delete_cal_min_price.php",
            type: "get",
            data: {"cp_id": cp_id},
            success: function(result)
            {
                var data = jQuery.parseJSON(result);
                if(data.status == "success")
                {
                    swal_btn2.click();
                    viewCalendarMinPriceList();
                }
                else if (data.status == "failed")
                {
                    alert("failed");
                }
            },
            error: function(data) 
            {
            }           
        });
    }
    
    function saveCalendarMinPrice(id)
    {
        var cp_id = id;
        localStorage.setItem("cp_id",cp_id);
        window.location.href = "update_calendar_min_price.php";   
    }

    function statusChange(id)
    {
        var cp_id = id;
        $.ajax({            
            url: "/kos_apis/active_calprice.php",
            type: "get",
            data: {"cp_id": cp_id},
            success: function(result)
            {
                var data = jQuery.parseJSON(result);
                if(data.status == "success")
                {
                    swal_btn3.click();
                    viewCalendarMinPriceList();
                }
                else if (data.status == "failed")
                {
                    alert("failed");
                }
            },
            error: function(data) 
            {
            }           
        });        
    }
</script>

</body>
</html>
