<!DOCTYPE html>
<html>
<head>

    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">

    <title>King Of Scooters | Employee Verification Panel</title>

    <link href="css/bootstrap.min.css" rel="stylesheet">
    <link href="font-awesome/css/font-awesome.css" rel="stylesheet">

    <!-- FooTable -->
    <link href="css/plugins/footable/footable.core.css" rel="stylesheet">

    <link href="css/animate.css" rel="stylesheet">
    <link href="css/style.css" rel="stylesheet">
    <style type="text/css">
        .activeSM
        {
            background-color: white !important; /* #38283c !important;*/
        }
        .verif_butt
        {
            width: 100%;
            height: 50px;
            border-color: #224ea6;
            margin-bottom: 20px;
            font-size: 20px;
        }
        .verif_butt:hover
        {
            background-color: #224ea6; /* Blue */
            color: white;
        }
    </style>

    <script>
    if (!localStorage.login_var)
    {
        window.stop();
        window.location.replace("index.php");
    }
</script>

</head>

<body>

    <div id="wrapper">
        <?php
        include 'navbar_static_side.php';
        ?>

        <div id="page-wrapper" class="gray-bg">
            <div class="row border-bottom">
                <?php
                include 'navbar_static_top.php';
                ?>
            </div>
            
            <div class="row wrapper border-bottom white-bg page-heading">
                <div class="col-lg-10">
                    <h2><Strong>Verification Panel</Strong></h2>
                    <ol class="breadcrumb">
                        <li>
                            <a href="verification_panel.php">Verification Panel</a>
                        </li>
                        <li class="active">
                            <strong id="ver_stat"></strong>
                        </li>
                    </ol>
                </div>
                <div class="col-lg-2">

                </div>
            </div>
            
            <div class="row">    
                <div class="col-md-6 col-sm-8 col-xs-12">
                    <div class="input-group">
                        <div class="input-group-btn search-panel">
                            <button style="background-color: #566b8a;color: white;" type="button" class="btn btn-default dropdown-toggle" data-toggle="dropdown">
                                <span id="search_concept">Filter by</span> <span class="caret"></span>
                            </button>
                            <ul class="dropdown-menu" role="menu">
                              <li><a href="#Customer First Name">Customer First Name</a></li>
                              <li><a href="#Phone#">Phone#</a></li>
                              <li><a href="#Order#">Order#</a></li>                                    
                              <li class="divider"></li>
                              <li><a href="#All">All</a></li>
                            </ul>
                        </div>
                        <input type="hidden" name="search_param" value="all" id="search_param">         
                        <input type="text" class="form-control" id="search_box" name="search_box" placeholder="Search term...">
                        <span class="input-group-btn">
                            <button onclick="searchFilter()" class="btn btn-default" type="button"><span class="glyphicon glyphicon-search"></span></button>
                        </span>
                    </div>
                </div>
            </div>
            
            <div class="wrapper wrapper-content animated fadeInRight ecommerce">
                <div class="row">
                    <div class="col-lg-12">
                        <div class="ibox">
                            <div id="orders_list" class="ibox-content table-responsive">
                                <!-- Dynamically appending Employees List -->
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <?php
            include 'footer.php';
            ?>

        </div>
    </div>



<!-- Mainly scripts -->
<script src="js/jquery-3.1.1.min.js"></script>
<script src="js/bootstrap.min.js"></script>
<script src="js/plugins/metisMenu/jquery.metisMenu.js"></script>
<script src="js/plugins/slimscroll/jquery.slimscroll.min.js"></script>

<!-- Custom and plugin javascript -->
<script src="js/inspinia.js"></script>
<script src="js/plugins/pace/pace.min.js"></script>

<!-- FooTable -->
<script src="js/plugins/footable/footable.all.min.js"></script>

<!-- Page-Level Scripts -->
<script>
    var datObj;
    $(document).ready(function() 
    {
        $("#side1").addClass("activeSM");
        $("#side1 a").css("color","#224ea6");
        
        $("#ver_stat").html(localStorage.verification_emp_status);
        
        $('.search-panel .dropdown-menu').find('a').click(function(e) 
        {
            e.preventDefault();
            var param = $(this).attr("href").replace("#","");
            var concept = $(this).text();
            $('.search-panel span#search_concept').text(concept);
            $('.input-group #search_param').val(param);
        });
        
        viewDeals();
    });
    
    function viewDeals()
    {
        var $list = $("#orders_list");
        $list.empty();
        $.ajax({
            url: "/kos_apis/vieworders_employeepanel.php",
            type: "GET",
            success: function(data)
            {   
                var dat = jQuery.parseJSON(data);
                
                if ( dat.status == "success")
                {
                    datObj = dat.order_details;
                    $.each(dat.order_details, function(index,obj) 
                    {       
                        if(obj.customer_details == 0)
                        {
                            $list.append('<table class="table table-striped table-bordered" style="margin-bottom:30px;border: 2px solid black;">'+
                                            '<tbody style="font-size:x-large">'+
                                                '<tr>'+
                                                    '<td>Order #:</td>'+
                                                    '<td>'+obj.deal_id+'</td>'+
                                                '</tr>'+
                                                '<tr>'+
                                                    '<td>Vehicle#:</td>'+
                                                    '<td>'+obj.vehicle_id+'</td>'+
                                                '</tr>'+
                                                '<tr>'+
                                                    '<td>Vehicle Type</td>'+
                                                    '<td>'+obj.vehicle_type+'</td>'+
                                                '</tr>'+
                                                '<tr>'+
                                                    '<td>Vehicle Term</td>'+
                                                    '<td>'+obj.term+'</td>'+
                                                '</tr>'+
                                                '<tr>'+
                                                    '<td>Vehicle Price</td>'+
                                                    '<td>'+obj.price+'</td>'+
                                                '</tr>'+
                                                '<tr>'+
                                                    '<td>Return Time</td>'+
                                                    '<td>'+obj.return_time+'</td>'+
                                                '</tr>'+
                                                '<tr>'+
                                                    '<td>Return Date</td>'+
                                                    '<td>'+obj.return_date+'</td>'+
                                                '</tr>'+
                                                '<tr>'+
                                                    '<td>Status</td>'+
                                                    '<td>'+obj.verification_status+'</td>'+
                                                '</tr>'+
                                                '<tr>'+
                                                    '<td>First Name</td>'+
                                                    '<td></td>'+
                                                '</tr>'+
                                                '<tr>'+
                                                    '<td>Last Name</td>'+
                                                    '<td></td>'+
                                                '</tr>'+
                                                '<tr>'+
                                                    '<td>Location</td>'+
                                                    '<td>'+obj.location+'</td>'+
                                                '</tr>'+
                                                '<tr>'+
                                                    '<td>Age</td>'+
                                                    '<td></td>'+
                                                '</tr>'+
                                                '<tr>'+
                                                    '<td>DOB</td>'+
                                                    '<td></td>'+
                                                '</tr>'+
                                                '<tr>'+
                                                    '<td>Phone #:</td>'+
                                                    '<td></td>'+
                                                '</tr>'+
                                                '<tr>'+
                                                    '<td>DL #:</td>'+
                                                    '<td></td>'+
                                                '</tr>'+
                                                '<tr>'+
                                                    '<td>DL Exp Date:</td>'+
                                                    '<td></td>'+
                                                '</tr>'+
                                                '<tr>'+
                                                    '<td>Credit Card#:</td>'+
                                                    '<td>'+obj.card_scan+'</td>'+
                                                '</tr>'+
                                                '<tr>'+
                                                    '<td>Auth</td>'+
                                                    '<td>AUTH</td>'+
                                                '</tr>'+
                                                '<tr>'+ 
                                                    '<td>Cash Deposit</td>'+
                                                    '<td>'+obj.deposit_amount+'</td>'+
                                                '</tr>'+
                                                '<tr>'+
                                                    '<td>Action</td>'+
                                                    '<td>'+
                                                        '<div class="btn-group">'+
                                                            '<button id="'+obj.deal_id+'" class="btn-white btn btn-xs" style="background:#224ea6;color:white;font-size: 30px;">Click to Verify</button>'+
                                                        '</div>'+
                                                    '</td>'+
                                                '</tr>'+
                                            '</tbody>'+
                                        '</table>');
                        }
                        else
                        {
                            $.each(obj.customer_details, function(index2,obj2) 
                            {
                                $list.append('<table class="table table-striped table-bordered" style="margin-bottom:30px;border: 2px solid black;">'+
                                                '<tbody style="font-size:x-large">'+
                                                    '<tr>'+
                                                        '<td>Order #:</td>'+
                                                        '<td>'+obj.deal_id+'</td>'+
                                                    '</tr>'+
                                                    '<tr>'+
                                                        '<td>Vehicle #:</td>'+
                                                        '<td>'+obj.vehicle_id+'</td>'+
                                                    '</tr>'+
                                                    '<tr>'+
                                                        '<td>Vehicle Type</td>'+
                                                        '<td>'+obj.vehicle_type+'</td>'+
                                                    '</tr>'+
                                                    '<tr>'+
                                                        '<td>Vehicle Term</td>'+
                                                        '<td>'+obj.term+'</td>'+
                                                    '</tr>'+
                                                    '<tr>'+
                                                        '<td>Vehicle Price</td>'+
                                                        '<td>'+obj.price+'</td>'+
                                                    '</tr>'+
                                                    '<tr>'+
                                                        '<td>Return Time</td>'+
                                                        '<td>'+obj.return_time+'</td>'+
                                                    '</tr>'+
                                                    '<tr>'+
                                                        '<td>Return Date</td>'+
                                                        '<td>'+obj.return_date+'</td>'+
                                                    '</tr>'+
                                                    '<tr>'+
                                                        '<td>Status</td>'+
                                                        '<td>'+obj.verification_status+'</td>'+
                                                    '</tr>'+
                                                    '<tr>'+
                                                        '<td>First Name</td>'+
                                                        '<td>'+obj2.fname+'</td>'+
                                                    '</tr>'+
                                                    '<tr>'+
                                                        '<td>Last Name</td>'+
                                                        '<td>'+obj2.lname+'</td>'+
                                                    '</tr>'+
                                                    '<tr>'+
                                                        '<td>Location</td>'+
                                                        '<td>'+obj.location+'</td>'+
                                                    '</tr>'+
                                                    '<tr>'+
                                                        '<td>Age</td>'+
                                                        '<td>'+obj2.age+'</td>'+
                                                    '</tr>'+
                                                    '<tr>'+
                                                        '<td>DOB</td>'+
                                                        '<td>'+obj2.dob+'</td>'+
                                                    '</tr>'+
                                                    '<tr>'+
                                                        '<td>Phone #:</td>'+
                                                        '<td>'+obj2.customer_phone+'</td>'+
                                                    '</tr>'+
                                                    '<tr>'+
                                                        '<td>DL #:</td>'+
                                                        '<td>'+obj2.dl_no+'</td>'+
                                                    '</tr>'+
                                                    '<tr>'+
                                                        '<td>DL Exp Date:</td>'+
                                                        '<td>'+obj2.dl_exmonth+'/'+obj2.dl_exyear+'</td>'+
                                                    '</tr>'+
                                                    '<tr>'+
                                                        '<td>Credit Card#:</td>'+
                                                        '<td>'+obj.card_scan+'</td>'+
                                                    '</tr>'+
                                                    '<tr>'+
                                                        '<td>Auth</td>'+
                                                        '<td>AUTH</td>'+
                                                    '</tr>'+
                                                    '<tr>'+ 
                                                        '<td>Cash Deposit</td>'+
                                                        '<td>'+obj.deposit_amount+'</td>'+
                                                    '</tr>'+
                                                    '<tr>'+
                                                        '<td>Action</td>'+
                                                        '<td>'+
                                                            '<div class="btn-group">'+
                                                                '<button id="'+obj.deal_id+'" class="btn-white btn btn-xs" style="background:#224ea6;color:white;font-size: 30px;">Click to Verify</button>'+
                                                            '</div>'+
                                                        '</td>'+
                                                    '</tr>'+
                                                '</tbody>'+
                                            '</table>');
                            });
                        }
                    });
                }
                else
                {
                    swal_btn.click();
                }
            },
            error: function(data)
            {
            }           
        });        
    }
    
    function searchFilter()
    {
        var count = 1;
        var search_option = $('#search_concept').html();

        if(search_option == "All")
        {
            $('#search_box').val("All");
        }
        var search_value = $('#search_box').val();

        if( search_option != "Filter by" && search_value )
        {
            var $list = $("#orders_list");
            $list.empty();

            if( search_option == "Customer First Name" )
            {
                $.each(datObj, function(index,obj) 
                {       
                    if(obj.customer_details == 0)
                    {
                    }
                    else
                    {
                        $.each(obj.customer_details, function(index2,obj2) 
                        {
                            if( obj2.fname == search_value )
                            {
                                $list.append('<table class="table table-striped table-bordered" style="margin-bottom:30px;border: 2px solid black;">'+
                                                '<tbody style="font-size:x-large">'+
                                                    '<tr>'+
                                                        '<td>Order #:</td>'+
                                                        '<td>'+obj.deal_id+'</td>'+
                                                    '</tr>'+
                                                    '<tr>'+
                                                        '<td>Vehicle #:</td>'+
                                                        '<td>'+obj.vehicle_id+'</td>'+
                                                    '</tr>'+
                                                    '<tr>'+
                                                        '<td>Vehicle Type</td>'+
                                                        '<td>'+obj.vehicle_type+'</td>'+
                                                    '</tr>'+
                                                    '<tr>'+
                                                        '<td>Vehicle Term</td>'+
                                                        '<td>'+obj.term+'</td>'+
                                                    '</tr>'+
                                                    '<tr>'+
                                                        '<td>Vehicle Price</td>'+
                                                        '<td>'+obj.price+'</td>'+
                                                    '</tr>'+
                                                    '<tr>'+
                                                        '<td>Return Time</td>'+
                                                        '<td>'+obj.return_time+'</td>'+
                                                    '</tr>'+
                                                    '<tr>'+
                                                        '<td>Return Date</td>'+
                                                        '<td>'+obj.return_date+'</td>'+
                                                    '</tr>'+
                                                    '<tr>'+
                                                        '<td>Status</td>'+
                                                        '<td>'+obj.verification_status+'</td>'+
                                                    '</tr>'+
                                                    '<tr>'+
                                                        '<td>First Name</td>'+
                                                        '<td>'+obj2.fname+'</td>'+
                                                    '</tr>'+
                                                    '<tr>'+
                                                        '<td>Last Name</td>'+
                                                        '<td>'+obj2.lname+'</td>'+
                                                    '</tr>'+
                                                    '<tr>'+
                                                        '<td>Location</td>'+
                                                        '<td>'+obj.location+'</td>'+
                                                    '</tr>'+
                                                    '<tr>'+
                                                        '<td>Age</td>'+
                                                        '<td>'+obj2.age+'</td>'+
                                                    '</tr>'+
                                                    '<tr>'+
                                                        '<td>DOB</td>'+
                                                        '<td>'+obj2.dob+'</td>'+
                                                    '</tr>'+
                                                    '<tr>'+
                                                        '<td>Phone #:</td>'+
                                                        '<td>'+obj2.customer_phone+'</td>'+
                                                    '</tr>'+
                                                    '<tr>'+
                                                        '<td>DL #:</td>'+
                                                        '<td>'+obj2.dl_no+'</td>'+
                                                    '</tr>'+
                                                    '<tr>'+
                                                        '<td>DL Exp Date:</td>'+
                                                        '<td>'+obj2.dl_exmonth+'/'+obj2.dl_exyear+'</td>'+
                                                    '</tr>'+
                                                    '<tr>'+
                                                        '<td>Credit Card#:</td>'+
                                                        '<td>'+obj.card_scan+'</td>'+
                                                    '</tr>'+
                                                    '<tr>'+
                                                        '<td>Auth</td>'+
                                                        '<td>AUTH</td>'+
                                                    '</tr>'+
                                                    '<tr>'+ 
                                                        '<td>Cash Deposit</td>'+
                                                        '<td>'+obj.deposit_amount+'</td>'+
                                                    '</tr>'+
                                                    '<tr>'+
                                                        '<td>Action</td>'+
                                                        '<td>'+
                                                            '<div class="btn-group">'+
                                                                '<button id="'+obj.deal_id+'" class="btn-white btn btn-xs" style="background:#224ea6;color:white;font-size: 30px;">Click to Verify</button>'+
                                                            '</div>'+
                                                        '</td>'+
                                                    '</tr>'+
                                                '</tbody>'+
                                            '</table>');
                                count++;           
                            }     
                        });
                    }
                });
                if( count == 1)
                {
                    $list.append('<tr><td colspan="2"><h2>No record found.</h2></td></tr>');
                    $('#search_box').val("");
                }
            }
            else if( search_option == "Phone#")
            {
                $.each(datObj, function(index,obj) 
                {    
                    if( obj.user_phone == search_value )
                    {
                        if(obj.customer_details == 0)
                        {
                            $list.append('<table class="table table-striped table-bordered" style="margin-bottom:30px;border: 2px solid black;">'+
                                            '<tbody style="font-size:x-large">'+
                                                '<tr>'+
                                                    '<td>Order #:</td>'+
                                                    '<td>'+obj.deal_id+'</td>'+
                                                '</tr>'+
                                                '<tr>'+
                                                    '<td>Vehicle#:</td>'+
                                                    '<td>'+obj.vehicle_id+'</td>'+
                                                '</tr>'+
                                                '<tr>'+
                                                    '<td>Vehicle Type</td>'+
                                                    '<td>'+obj.vehicle_type+'</td>'+
                                                '</tr>'+
                                                '<tr>'+
                                                    '<td>Vehicle Term</td>'+
                                                    '<td>'+obj.term+'</td>'+
                                                '</tr>'+
                                                '<tr>'+
                                                    '<td>Vehicle Price</td>'+
                                                    '<td>'+obj.price+'</td>'+
                                                '</tr>'+
                                                '<tr>'+
                                                    '<td>Return Time</td>'+
                                                    '<td>'+obj.return_time+'</td>'+
                                                '</tr>'+
                                                '<tr>'+
                                                    '<td>Return Date</td>'+
                                                    '<td>'+obj.return_date+'</td>'+
                                                '</tr>'+
                                                '<tr>'+
                                                    '<td>Status</td>'+
                                                    '<td>'+obj.verification_status+'</td>'+
                                                '</tr>'+
                                                '<tr>'+
                                                    '<td>First Name</td>'+
                                                    '<td></td>'+
                                                '</tr>'+
                                                '<tr>'+
                                                    '<td>Last Name</td>'+
                                                    '<td></td>'+
                                                '</tr>'+
                                                '<tr>'+
                                                    '<td>Location</td>'+
                                                    '<td>'+obj.location+'</td>'+
                                                '</tr>'+
                                                '<tr>'+
                                                    '<td>Age</td>'+
                                                    '<td></td>'+
                                                '</tr>'+
                                                '<tr>'+
                                                    '<td>DOB</td>'+
                                                    '<td></td>'+
                                                '</tr>'+
                                                '<tr>'+
                                                    '<td>Phone #:</td>'+
                                                    '<td></td>'+
                                                '</tr>'+
                                                '<tr>'+
                                                    '<td>DL #:</td>'+
                                                    '<td></td>'+
                                                '</tr>'+
                                                '<tr>'+
                                                    '<td>DL Exp Date:</td>'+
                                                    '<td></td>'+
                                                '</tr>'+
                                                '<tr>'+
                                                    '<td>Credit Card#:</td>'+
                                                    '<td>'+obj.card_scan+'</td>'+
                                                '</tr>'+
                                                '<tr>'+
                                                    '<td>Auth</td>'+
                                                    '<td>AUTH</td>'+
                                                '</tr>'+
                                                '<tr>'+ 
                                                    '<td>Cash Deposit</td>'+
                                                    '<td>'+obj.deposit_amount+'</td>'+
                                                '</tr>'+
                                                '<tr>'+
                                                    '<td>Action</td>'+
                                                    '<td>'+
                                                        '<div class="btn-group">'+
                                                            '<button id="'+obj.deal_id+'" class="btn-white btn btn-xs" style="background:#224ea6;color:white;font-size: 30px;">Click to Verify</button>'+
                                                        '</div>'+
                                                    '</td>'+
                                                '</tr>'+
                                            '</tbody>'+
                                        '</table>');
                        }
                        else
                        {
                            $.each(obj.customer_details, function(index2,obj2) 
                            {
                                $list.append('<table class="table table-striped table-bordered" style="margin-bottom:30px;border: 2px solid black;">'+
                                                '<tbody style="font-size:x-large">'+
                                                    '<tr>'+
                                                        '<td>Order #:</td>'+
                                                        '<td>'+obj.deal_id+'</td>'+
                                                    '</tr>'+
                                                    '<tr>'+
                                                        '<td>Vehicle #:</td>'+
                                                        '<td>'+obj.vehicle_id+'</td>'+
                                                    '</tr>'+
                                                    '<tr>'+
                                                        '<td>Vehicle Type</td>'+
                                                        '<td>'+obj.vehicle_type+'</td>'+
                                                    '</tr>'+
                                                    '<tr>'+
                                                        '<td>Vehicle Term</td>'+
                                                        '<td>'+obj.term+'</td>'+
                                                    '</tr>'+
                                                    '<tr>'+
                                                        '<td>Vehicle Price</td>'+
                                                        '<td>'+obj.price+'</td>'+
                                                    '</tr>'+
                                                    '<tr>'+
                                                        '<td>Return Time</td>'+
                                                        '<td>'+obj.return_time+'</td>'+
                                                    '</tr>'+
                                                    '<tr>'+
                                                        '<td>Return Date</td>'+
                                                        '<td>'+obj.return_date+'</td>'+
                                                    '</tr>'+
                                                    '<tr>'+
                                                        '<td>Status</td>'+
                                                        '<td>'+obj.verification_status+'</td>'+
                                                    '</tr>'+
                                                    '<tr>'+
                                                        '<td>First Name</td>'+
                                                        '<td>'+obj2.fname+'</td>'+
                                                    '</tr>'+
                                                    '<tr>'+
                                                        '<td>Last Name</td>'+
                                                        '<td>'+obj2.lname+'</td>'+
                                                    '</tr>'+
                                                    '<tr>'+
                                                        '<td>Location</td>'+
                                                        '<td>'+obj.location+'</td>'+
                                                    '</tr>'+
                                                    '<tr>'+
                                                        '<td>Age</td>'+
                                                        '<td>'+obj2.age+'</td>'+
                                                    '</tr>'+
                                                    '<tr>'+
                                                        '<td>DOB</td>'+
                                                        '<td>'+obj2.dob+'</td>'+
                                                    '</tr>'+
                                                    '<tr>'+
                                                        '<td>Phone #:</td>'+
                                                        '<td>'+obj2.customer_phone+'</td>'+
                                                    '</tr>'+
                                                    '<tr>'+
                                                        '<td>DL #:</td>'+
                                                        '<td>'+obj2.dl_no+'</td>'+
                                                    '</tr>'+
                                                    '<tr>'+
                                                        '<td>DL Exp Date:</td>'+
                                                        '<td>'+obj2.dl_exmonth+'/'+obj2.dl_exyear+'</td>'+
                                                    '</tr>'+
                                                    '<tr>'+
                                                        '<td>Credit Card#:</td>'+
                                                        '<td>'+obj.card_scan+'</td>'+
                                                    '</tr>'+
                                                    '<tr>'+
                                                        '<td>Auth</td>'+
                                                        '<td>AUTH</td>'+
                                                    '</tr>'+
                                                    '<tr>'+ 
                                                        '<td>Cash Deposit</td>'+
                                                        '<td>'+obj.deposit_amount+'</td>'+
                                                    '</tr>'+
                                                    '<tr>'+
                                                        '<td>Action</td>'+
                                                        '<td>'+
                                                            '<div class="btn-group">'+
                                                                '<button id="'+obj.deal_id+'" class="btn-white btn btn-xs" style="background:#224ea6;color:white;font-size: 30px;">Click to Verify</button>'+
                                                            '</div>'+
                                                        '</td>'+
                                                    '</tr>'+
                                                '</tbody>'+
                                            '</table>');
                            });
                        }
                        count++;
                    }
                });
                if( count == 1)
                {
                    $list.append('<tr><td colspan="2"><h2>No record found.</h2></td></tr>');
                    $('#search_box').val("");
                }
            }
            else if( search_option == "Order#" )
            {
                $.each(datObj, function(index,obj) 
                {       
                    if( obj.deal_id == search_value )
                    {
                        if(obj.customer_details == 0)
                        {
                            $list.append('<table class="table table-striped table-bordered" style="margin-bottom:30px;border: 2px solid black;">'+
                                            '<tbody style="font-size:x-large">'+
                                                '<tr>'+
                                                    '<td>Order #:</td>'+
                                                    '<td>'+obj.deal_id+'</td>'+
                                                '</tr>'+
                                                '<tr>'+
                                                    '<td>Vehicle#:</td>'+
                                                    '<td>'+obj.vehicle_id+'</td>'+
                                                '</tr>'+
                                                '<tr>'+
                                                    '<td>Vehicle Type</td>'+
                                                    '<td>'+obj.vehicle_type+'</td>'+
                                                '</tr>'+
                                                '<tr>'+
                                                    '<td>Vehicle Term</td>'+
                                                    '<td>'+obj.term+'</td>'+
                                                '</tr>'+
                                                '<tr>'+
                                                    '<td>Vehicle Price</td>'+
                                                    '<td>'+obj.price+'</td>'+
                                                '</tr>'+
                                                '<tr>'+
                                                    '<td>Return Time</td>'+
                                                    '<td>'+obj.return_time+'</td>'+
                                                '</tr>'+
                                                '<tr>'+
                                                    '<td>Return Date</td>'+
                                                    '<td>'+obj.return_date+'</td>'+
                                                '</tr>'+
                                                '<tr>'+
                                                    '<td>Status</td>'+
                                                    '<td>'+obj.verification_status+'</td>'+
                                                '</tr>'+
                                                '<tr>'+
                                                    '<td>First Name</td>'+
                                                    '<td></td>'+
                                                '</tr>'+
                                                '<tr>'+
                                                    '<td>Last Name</td>'+
                                                    '<td></td>'+
                                                '</tr>'+
                                                '<tr>'+
                                                    '<td>Location</td>'+
                                                    '<td>'+obj.location+'</td>'+
                                                '</tr>'+
                                                '<tr>'+
                                                    '<td>Age</td>'+
                                                    '<td></td>'+
                                                '</tr>'+
                                                '<tr>'+
                                                    '<td>DOB</td>'+
                                                    '<td></td>'+
                                                '</tr>'+
                                                '<tr>'+
                                                    '<td>Phone #:</td>'+
                                                    '<td></td>'+
                                                '</tr>'+
                                                '<tr>'+
                                                    '<td>DL #:</td>'+
                                                    '<td></td>'+
                                                '</tr>'+
                                                '<tr>'+
                                                    '<td>DL Exp Date:</td>'+
                                                    '<td></td>'+
                                                '</tr>'+
                                                '<tr>'+
                                                    '<td>Credit Card#:</td>'+
                                                    '<td>'+obj.card_scan+'</td>'+
                                                '</tr>'+
                                                '<tr>'+
                                                    '<td>Auth</td>'+
                                                    '<td>AUTH</td>'+
                                                '</tr>'+
                                                '<tr>'+ 
                                                    '<td>Cash Deposit</td>'+
                                                    '<td>'+obj.deposit_amount+'</td>'+
                                                '</tr>'+
                                                '<tr>'+
                                                    '<td>Action</td>'+
                                                    '<td>'+
                                                        '<div class="btn-group">'+
                                                            '<button id="'+obj.deal_id+'" class="btn-white btn btn-xs" style="background:#224ea6;color:white;font-size: 30px;">Click to Verify</button>'+
                                                        '</div>'+
                                                    '</td>'+
                                                '</tr>'+
                                            '</tbody>'+
                                        '</table>');
                        }
                        else
                        {
                            $.each(obj.customer_details, function(index2,obj2) 
                            {
                                $list.append('<table class="table table-striped table-bordered" style="margin-bottom:30px;border: 2px solid black;">'+
                                                '<tbody style="font-size:x-large">'+
                                                    '<tr>'+
                                                        '<td>Order #:</td>'+
                                                        '<td>'+obj.deal_id+'</td>'+
                                                    '</tr>'+
                                                    '<tr>'+
                                                        '<td>Vehicle #:</td>'+
                                                        '<td>'+obj.vehicle_id+'</td>'+
                                                    '</tr>'+
                                                    '<tr>'+
                                                        '<td>Vehicle Type</td>'+
                                                        '<td>'+obj.vehicle_type+'</td>'+
                                                    '</tr>'+
                                                    '<tr>'+
                                                        '<td>Vehicle Term</td>'+
                                                        '<td>'+obj.term+'</td>'+
                                                    '</tr>'+
                                                    '<tr>'+
                                                        '<td>Vehicle Price</td>'+
                                                        '<td>'+obj.price+'</td>'+
                                                    '</tr>'+
                                                    '<tr>'+
                                                        '<td>Return Time</td>'+
                                                        '<td>'+obj.return_time+'</td>'+
                                                    '</tr>'+
                                                    '<tr>'+
                                                        '<td>Return Date</td>'+
                                                        '<td>'+obj.return_date+'</td>'+
                                                    '</tr>'+
                                                    '<tr>'+
                                                        '<td>Status</td>'+
                                                        '<td>'+obj.verification_status+'</td>'+
                                                    '</tr>'+
                                                    '<tr>'+
                                                        '<td>First Name</td>'+
                                                        '<td>'+obj2.fname+'</td>'+
                                                    '</tr>'+
                                                    '<tr>'+
                                                        '<td>Last Name</td>'+
                                                        '<td>'+obj2.lname+'</td>'+
                                                    '</tr>'+
                                                    '<tr>'+
                                                        '<td>Location</td>'+
                                                        '<td>'+obj.location+'</td>'+
                                                    '</tr>'+
                                                    '<tr>'+
                                                        '<td>Age</td>'+
                                                        '<td>'+obj2.age+'</td>'+
                                                    '</tr>'+
                                                    '<tr>'+
                                                        '<td>DOB</td>'+
                                                        '<td>'+obj2.dob+'</td>'+
                                                    '</tr>'+
                                                    '<tr>'+
                                                        '<td>Phone #:</td>'+
                                                        '<td>'+obj2.customer_phone+'</td>'+
                                                    '</tr>'+
                                                    '<tr>'+
                                                        '<td>DL #:</td>'+
                                                        '<td>'+obj2.dl_no+'</td>'+
                                                    '</tr>'+
                                                    '<tr>'+
                                                        '<td>DL Exp Date:</td>'+
                                                        '<td>'+obj2.dl_exmonth+'/'+obj2.dl_exyear+'</td>'+
                                                    '</tr>'+
                                                    '<tr>'+
                                                        '<td>Credit Card#:</td>'+
                                                        '<td>'+obj.card_scan+'</td>'+
                                                    '</tr>'+
                                                    '<tr>'+
                                                        '<td>Auth</td>'+
                                                        '<td>AUTH</td>'+
                                                    '</tr>'+
                                                    '<tr>'+ 
                                                        '<td>Cash Deposit</td>'+
                                                        '<td>'+obj.deposit_amount+'</td>'+
                                                    '</tr>'+
                                                    '<tr>'+
                                                        '<td>Action</td>'+
                                                        '<td>'+
                                                            '<div class="btn-group">'+
                                                                '<button id="'+obj.deal_id+'" class="btn-white btn btn-xs" style="background:#224ea6;color:white;font-size: 30px;">Click to Verify</button>'+
                                                            '</div>'+
                                                        '</td>'+
                                                    '</tr>'+
                                                '</tbody>'+
                                            '</table>');
                            });
                        }
                        count++;
                    }
                });
                if( count == 1)
                {
                    $list.append('<tr><td colspan="2"><h2>No record found.</h2></td></tr>');
                    $('#search_box').val("");
                }
            }
            else
            {
               $.each(datObj, function(index,obj) 
                {       
                    if(obj.customer_details == 0)
                    {
                        $list.append('<table class="table table-striped table-bordered" style="margin-bottom:30px;border: 2px solid black;">'+
                                        '<tbody style="font-size:x-large">'+
                                            '<tr>'+
                                                '<td>Order #:</td>'+
                                                '<td>'+obj.deal_id+'</td>'+
                                            '</tr>'+
                                            '<tr>'+
                                                '<td>Vehicle#:</td>'+
                                                '<td>'+obj.vehicle_id+'</td>'+
                                            '</tr>'+
                                            '<tr>'+
                                                '<td>Vehicle Type</td>'+
                                                '<td>'+obj.vehicle_type+'</td>'+
                                            '</tr>'+
                                            '<tr>'+
                                                '<td>Vehicle Term</td>'+
                                                '<td>'+obj.term+'</td>'+
                                            '</tr>'+
                                            '<tr>'+
                                                '<td>Vehicle Price</td>'+
                                                '<td>'+obj.price+'</td>'+
                                            '</tr>'+
                                            '<tr>'+
                                                '<td>Return Time</td>'+
                                                '<td>'+obj.return_time+'</td>'+
                                            '</tr>'+
                                            '<tr>'+
                                                '<td>Return Date</td>'+
                                                '<td>'+obj.return_date+'</td>'+
                                            '</tr>'+
                                            '<tr>'+
                                                '<td>Status</td>'+
                                                '<td>'+obj.verification_status+'</td>'+
                                            '</tr>'+
                                            '<tr>'+
                                                '<td>First Name</td>'+
                                                '<td></td>'+
                                            '</tr>'+
                                            '<tr>'+
                                                '<td>Last Name</td>'+
                                                '<td></td>'+
                                            '</tr>'+
                                            '<tr>'+
                                                '<td>Location</td>'+
                                                '<td>'+obj.location+'</td>'+
                                            '</tr>'+
                                            '<tr>'+
                                                '<td>Age</td>'+
                                                '<td></td>'+
                                            '</tr>'+
                                            '<tr>'+
                                                '<td>DOB</td>'+
                                                '<td></td>'+
                                            '</tr>'+
                                            '<tr>'+
                                                '<td>Phone #:</td>'+
                                                '<td></td>'+
                                            '</tr>'+
                                            '<tr>'+
                                                '<td>DL #:</td>'+
                                                '<td></td>'+
                                            '</tr>'+
                                            '<tr>'+
                                                '<td>DL Exp Date:</td>'+
                                                '<td></td>'+
                                            '</tr>'+
                                            '<tr>'+
                                                '<td>Credit Card#:</td>'+
                                                '<td>'+obj.card_scan+'</td>'+
                                            '</tr>'+
                                            '<tr>'+
                                                '<td>Auth</td>'+
                                                '<td>AUTH</td>'+
                                            '</tr>'+
                                            '<tr>'+ 
                                                '<td>Cash Deposit</td>'+
                                                '<td>'+obj.deposit_amount+'</td>'+
                                            '</tr>'+
                                            '<tr>'+
                                                '<td>Action</td>'+
                                                '<td>'+
                                                    '<div class="btn-group">'+
                                                        '<button id="'+obj.deal_id+'" class="btn-white btn btn-xs" style="background:#224ea6;color:white;font-size: 30px;">Click to Verify</button>'+
                                                    '</div>'+
                                                '</td>'+
                                            '</tr>'+
                                        '</tbody>'+
                                    '</table>');
                    }
                    else
                    {
                        $.each(obj.customer_details, function(index2,obj2) 
                        {
                            $list.append('<table class="table table-striped table-bordered" style="margin-bottom:30px;border: 2px solid black;">'+
                                            '<tbody style="font-size:x-large">'+
                                                '<tr>'+
                                                    '<td>Order #:</td>'+
                                                    '<td>'+obj.deal_id+'</td>'+
                                                '</tr>'+
                                                '<tr>'+
                                                    '<td>Vehicle #:</td>'+
                                                    '<td>'+obj.vehicle_id+'</td>'+
                                                '</tr>'+
                                                '<tr>'+
                                                    '<td>Vehicle Type</td>'+
                                                    '<td>'+obj.vehicle_type+'</td>'+
                                                '</tr>'+
                                                '<tr>'+
                                                    '<td>Vehicle Term</td>'+
                                                    '<td>'+obj.term+'</td>'+
                                                '</tr>'+
                                                '<tr>'+
                                                    '<td>Vehicle Price</td>'+
                                                    '<td>'+obj.price+'</td>'+
                                                '</tr>'+
                                                '<tr>'+
                                                    '<td>Return Time</td>'+
                                                    '<td>'+obj.return_time+'</td>'+
                                                '</tr>'+
                                                '<tr>'+
                                                    '<td>Return Date</td>'+
                                                    '<td>'+obj.return_date+'</td>'+
                                                '</tr>'+
                                                '<tr>'+
                                                    '<td>Status</td>'+
                                                    '<td>'+obj.verification_status+'</td>'+
                                                '</tr>'+
                                                '<tr>'+
                                                    '<td>First Name</td>'+
                                                    '<td>'+obj2.fname+'</td>'+
                                                '</tr>'+
                                                '<tr>'+
                                                    '<td>Last Name</td>'+
                                                    '<td>'+obj2.lname+'</td>'+
                                                '</tr>'+
                                                '<tr>'+
                                                    '<td>Location</td>'+
                                                    '<td>'+obj.location+'</td>'+
                                                '</tr>'+
                                                '<tr>'+
                                                    '<td>Age</td>'+
                                                    '<td>'+obj2.age+'</td>'+
                                                '</tr>'+
                                                '<tr>'+
                                                    '<td>DOB</td>'+
                                                    '<td>'+obj2.dob+'</td>'+
                                                '</tr>'+
                                                '<tr>'+
                                                    '<td>Phone #:</td>'+
                                                    '<td>'+obj2.customer_phone+'</td>'+
                                                '</tr>'+
                                                '<tr>'+
                                                    '<td>DL #:</td>'+
                                                    '<td>'+obj2.dl_no+'</td>'+
                                                '</tr>'+
                                                '<tr>'+
                                                    '<td>DL Exp Date:</td>'+
                                                    '<td>'+obj2.dl_exmonth+'/'+obj2.dl_exyear+'</td>'+
                                                '</tr>'+
                                                '<tr>'+
                                                    '<td>Credit Card#:</td>'+
                                                    '<td>'+obj.card_scan+'</td>'+
                                                '</tr>'+
                                                '<tr>'+
                                                    '<td>Auth</td>'+
                                                    '<td>AUTH</td>'+
                                                '</tr>'+
                                                '<tr>'+ 
                                                    '<td>Cash Deposit</td>'+
                                                    '<td>'+obj.deposit_amount+'</td>'+
                                                '</tr>'+
                                                '<tr>'+
                                                    '<td>Action</td>'+
                                                    '<td>'+
                                                        '<div class="btn-group">'+
                                                            '<button id="'+obj.deal_id+'" class="btn-white btn btn-xs" style="background:#224ea6;color:white;font-size: 30px;">Click to Verify</button>'+
                                                        '</div>'+
                                                    '</td>'+
                                                '</tr>'+
                                            '</tbody>'+
                                        '</table>');
                        });
                    }
                });
            }
        }
        else
        {
            alert("Please select filter and enter search parameter");
        }
    }
</script>

</body>
</html>